/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancientforgemastery;

import net.mcreator.ancientforgemastery.init.AncientForgemasteryModItems;
import net.mcreator.ancientforgemastery.network.AncientForgemasteryModVariables;
import net.mcreator.ancientforgemastery.procedures.HHMainProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ancient_forgemastery")
public class HHUnequip {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (!HHUnequip.isHHOn(player)) {
            return;
        }
        HHUnequip.clearHelmetCMDEverywhere(player);
        HHUnequip.setDurationToZero(player);
    }

    @SubscribeEvent
    public static void onEquipChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (event.getSlot() != EquipmentSlot.HEAD) {
            return;
        }
        if (!HHUnequip.isHHOn(player)) {
            return;
        }
        ItemStack oldStack = event.getFrom();
        ItemStack newStack = event.getTo();
        if (!HHUnequip.isOurHelmet(oldStack) || !HHUnequip.hasCmdActive(oldStack)) {
            return;
        }
        if (HHUnequip.isOurHelmet(newStack) && HHUnequip.hasCmdActive(newStack)) {
            return;
        }
        HHUnequip.setDurationToZero(player);
        player.m_20194_().execute(() -> {
            HHUnequip.clearHelmetCMDEverywhere(player);
            HHMainProcedure.execute((LevelAccessor)player.m_9236_(), (Entity)player, ItemStack.f_41583_);
        });
    }

    @SubscribeEvent
    public static void onToss(ItemTossEvent event) {
        boolean headIsActive;
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack dropped = event.getEntity().m_32055_();
        if (!HHUnequip.isOurHelmet(dropped)) {
            return;
        }
        ItemStack head = (ItemStack)player2.m_150109_().f_35975_.get(3);
        boolean bl = headIsActive = HHUnequip.isOurHelmet(head) && HHUnequip.hasCmdActive(head);
        if (headIsActive) {
            return;
        }
        if (HHUnequip.hasCmdActive(dropped)) {
            HHUnequip.clearCMD(dropped);
        }
    }

    private static boolean isHHOn(ServerPlayer player) {
        boolean[] on = new boolean[]{false};
        player.getCapability(AncientForgemasteryModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(cap -> {
            on[0] = cap.HH_ON;
        });
        return on[0];
    }

    private static void setDurationToZero(ServerPlayer player) {
        player.getCapability(AncientForgemasteryModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(cap -> {
            cap.HH_DURATION = 0.0;
            cap.syncPlayerVariables((Entity)player);
        });
    }

    private static boolean isOurHelmet(ItemStack s) {
        return !s.m_41619_() && s.m_41720_() == AncientForgemasteryModItems.HOWLING_HELMET.get();
    }

    private static int readCMD(ItemStack s) {
        if (s.m_41619_() || !s.m_41782_()) {
            return 0;
        }
        CompoundTag tag = s.m_41784_();
        if (tag.m_128425_("CustomModelData", 3)) {
            return tag.m_128451_("CustomModelData");
        }
        if (tag.m_128425_("CustomModelData", 6)) {
            return (int)Math.round(tag.m_128459_("CustomModelData"));
        }
        return 0;
    }

    private static boolean hasCmdActive(ItemStack s) {
        int cmd = HHUnequip.readCMD(s);
        return cmd >= 1 && cmd <= 4;
    }

    private static void clearCMD(ItemStack s) {
        if (!s.m_41782_()) {
            return;
        }
        CompoundTag tag = s.m_41784_();
        if (tag.m_128441_("CustomModelData")) {
            tag.m_128473_("CustomModelData");
        }
    }

    private static void clearHelmetCMDEverywhere(ServerPlayer player) {
        int i;
        Inventory inv = player.m_150109_();
        for (i = 0; i < inv.f_35974_.size(); ++i) {
            HHUnequip.clearCMDIfHelmet((ItemStack)inv.f_35974_.get(i));
        }
        for (i = 0; i < inv.f_35975_.size(); ++i) {
            HHUnequip.clearCMDIfHelmet((ItemStack)inv.f_35975_.get(i));
        }
        for (i = 0; i < inv.f_35976_.size(); ++i) {
            HHUnequip.clearCMDIfHelmet((ItemStack)inv.f_35976_.get(i));
        }
        ItemStack carried = player.f_36096_.m_142621_();
        if (HHUnequip.isOurHelmet(carried)) {
            HHUnequip.clearCMD(carried);
            player.f_36096_.m_142503_(carried);
        }
        inv.m_6596_();
        player.f_36096_.m_38946_();
    }

    private static void clearHelmetCMDInInvOffhandAndCursor(ServerPlayer player) {
        int i;
        Inventory inv = player.m_150109_();
        for (i = 0; i < inv.f_35974_.size(); ++i) {
            HHUnequip.clearCMDIfHelmet((ItemStack)inv.f_35974_.get(i));
        }
        for (i = 0; i < inv.f_35976_.size(); ++i) {
            HHUnequip.clearCMDIfHelmet((ItemStack)inv.f_35976_.get(i));
        }
        ItemStack carried = player.f_36096_.m_142621_();
        if (HHUnequip.isOurHelmet(carried)) {
            HHUnequip.clearCMD(carried);
            player.f_36096_.m_142503_(carried);
        }
    }

    private static void clearCMDIfHelmet(ItemStack s) {
        if (HHUnequip.isOurHelmet(s)) {
            HHUnequip.clearCMD(s);
        }
    }
}

