/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancientforgemastery;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import net.mcreator.ancientforgemastery.init.AncientForgemasteryModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ancient_forgemastery", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class RCTooltip {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (!stack.m_150930_((Item)AncientForgemasteryModItems.RAVAGING_CLAWS.get())) {
            return;
        }
        Player player = e.getEntity();
        boolean rcOn = stack.m_41784_().m_128471_("af:rc_on");
        double lvlTag = stack.m_41784_().m_128459_("af:lvl");
        double level = lvlTag <= 1.0 ? 1.0 : lvlTag;
        double xRaw = 0.0;
        if (rcOn && player != null) {
            double missingWhole = Math.floor(player.m_21233_() - player.m_21223_());
            double mult = 0.25 + level * 0.25;
            xRaw = Math.floor(missingWhole * mult * 2.0) / 2.0;
        }
        String xStr = new DecimalFormat(" ##.#", DecimalFormatSymbols.getInstance(Locale.ROOT)).format(xRaw);
        List list = e.getToolTip();
        int insertAt = RCTooltip.indexAfterMainHandSection(list);
        if (insertAt < 0) {
            insertAt = list.size();
        }
        list.add(insertAt, Component.m_237113_((String)(xStr + " Bonus Attack Damage")).m_130940_(ChatFormatting.DARK_GREEN));
    }

    private static int indexAfterMainHandSection(List<Component> list) {
        Component c;
        int header = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!RCTooltip.isTransKey(list.get(i), "item.modifiers.mainhand")) continue;
            header = i;
            break;
        }
        if (header == -1) {
            return -1;
        }
        int insertAt = header + 1;
        for (int i = header + 1; i < list.size() && !RCTooltip.isAnyModifiersHeader(c = list.get(i)) && !c.getString().isBlank(); ++i) {
            insertAt = i - 1;
        }
        return insertAt;
    }

    private static boolean isTransKey(Component c, String key) {
        TranslatableContents tc;
        ComponentContents componentContents = c.m_214077_();
        return componentContents instanceof TranslatableContents && key.equals((tc = (TranslatableContents)componentContents).m_237508_());
    }

    private static boolean isAnyModifiersHeader(Component c) {
        ComponentContents componentContents = c.m_214077_();
        if (!(componentContents instanceof TranslatableContents)) {
            return false;
        }
        TranslatableContents tc = (TranslatableContents)componentContents;
        return tc.m_237508_().startsWith("item.modifiers.");
    }
}

