package de.cech12.colorblindnessclient.client;

import de.cech12.colorblindnessclient.Constants;
import org.lwjgl.glfw.GLFW;

import java.util.function.Supplier;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public enum ColorEffect {

    /** ACHROMATOMALY effect */
    ACHROMATOMALY(() -> ColorBlindnessKeyMappings.ACHROMATOMALY),
    /** ACHROMATOPSIA effect */
    ACHROMATOPSIA(() -> ColorBlindnessKeyMappings.ACHROMATOPSIA),
    /** DEUTERANOMALY effect */
    DEUTERANOMALY(() -> ColorBlindnessKeyMappings.DEUTERANOMALY),
    /** DEUTERANOPIA effect */
    DEUTERANOPIA(() -> ColorBlindnessKeyMappings.DEUTERANOPIA),
    /** PROTANOMALY effect */
    PROTANOMALY(() -> ColorBlindnessKeyMappings.PROTANOMALY),
    /** PROTANOPIA effect */
    PROTANOPIA(() -> ColorBlindnessKeyMappings.PROTANOPIA),
    /** TRITANOMALY effect */
    TRITANOMALY(() -> ColorBlindnessKeyMappings.TRITANOMALY),
    /** TRITANOPIA effect */
    TRITANOPIA(() -> ColorBlindnessKeyMappings.TRITANOPIA);

    final Supplier<class_304> keyMapping;

    ColorEffect(Supplier<class_304> keyMapping) {
        this.keyMapping = keyMapping;
    }

    private String getKeyTranslatable() {
        return "key." + Constants.MOD_ID + "." + name().toLowerCase();
    }

    public class_304 generateKeyMapping() {
        return new class_304(
                this.getKeyTranslatable(),
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                Constants.KEYMAPPING_CATEGORY
        );
    }

    public static void buttonPressed() {
        for (ColorEffect effect : ColorEffect.values()) {
            if (effect.keyMapping.get() == null) {
                continue;
            }
            if (effect.keyMapping.get().method_1436()) {
                Constants.buttonPressed(effect);
            }
        }
    }

}
