package de.cech12.colorblindnessclient.client;

import com.google.gson.JsonSyntaxException;
import de.cech12.colorblindnessclient.Constants;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_9920;
import net.minecraft.class_9960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectRendererHelper {

    private static final Logger LOGGER = LogManager.getLogger();

    private static final class_2960 ACHROMATOMALY = Constants.id("achromatomaly");
    private static final class_2960 ACHROMATOPSIA = Constants.id("achromatopsia");
    private static final class_2960 DEUTERANOMALY = Constants.id("deuteranomaly");
    private static final class_2960 DEUTERANOPIA = Constants.id("deuteranopia");
    private static final class_2960 PROTANOMALY = Constants.id("protanomaly");
    private static final class_2960 PROTANOPIA = Constants.id("protanopia");
    private static final class_2960 TRITANOMALY = Constants.id("tritanomaly");
    private static final class_2960 TRITANOPIA = Constants.id("tritanopia");
    private static final class_9920 RESOURCE_POOL = new class_9920(3);

    private static class_279 achromatomalyShader;
    private static class_279 achromatopsiaShader;
    private static class_279 deuteranomalyShader;
    private static class_279 deuteranopiaShader;
    private static class_279 protanomalyShader;
    private static class_279 protanopiaShader;
    private static class_279 tritanomalyShader;
    private static class_279 tritanopiaShader;

    /**
     * Should be called by a render event and renders the effect if it is active.
     * @param renderTickTime render tick time
     */
    public static void renderColorBlindnessEffect(float renderTickTime) {
        if (Constants.getActiveEffect() == null) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            makeColorShaders();

            class_279 activeShader = switch (Constants.getActiveEffect()) {
                case ACHROMATOMALY -> achromatomalyShader;
                case ACHROMATOPSIA -> achromatopsiaShader;
                case DEUTERANOMALY -> deuteranomalyShader;
                case DEUTERANOPIA -> deuteranopiaShader;
                case PROTANOMALY -> protanomalyShader;
                case PROTANOPIA -> protanopiaShader;
                case TRITANOMALY -> tritanomalyShader;
                case TRITANOPIA -> tritanopiaShader;
            };

            if (activeShader != null) {
                activeShader.method_1258(class_310.method_1551().method_1522(), RESOURCE_POOL);
            }
        }
    }

    private static class_279 createShaderGroup(class_2960 location) {
        try {
            return class_310.method_1551().method_62887().method_62941(location, class_9960.field_53902);
        } catch (JsonSyntaxException jsonsyntaxexception) {
            LOGGER.warn("Failed to parse shader: {}", location, jsonsyntaxexception);
        }
        return null;
    }

    private static void makeColorShaders() {
        if (achromatomalyShader == null) {
            achromatomalyShader = createShaderGroup(ACHROMATOMALY);
        }
        if (achromatopsiaShader == null) {
            achromatopsiaShader = createShaderGroup(ACHROMATOPSIA);
        }
        if (deuteranomalyShader == null) {
            deuteranomalyShader = createShaderGroup(DEUTERANOMALY);
        }
        if (deuteranopiaShader == null) {
            deuteranopiaShader = createShaderGroup(DEUTERANOPIA);
        }
        if (protanomalyShader == null) {
            protanomalyShader = createShaderGroup(PROTANOMALY);
        }
        if (protanopiaShader == null) {
            protanopiaShader = createShaderGroup(PROTANOPIA);
        }
        if (tritanomalyShader == null) {
            tritanomalyShader = createShaderGroup(TRITANOMALY);
        }
        if (tritanopiaShader == null) {
            tritanopiaShader = createShaderGroup(TRITANOPIA);
        }
    }

}
