/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.colorblindnessclient.client;

import com.mojang.blaze3d.platform.InputConstants;
import de.cech12.colorblindnessclient.Constants;
import de.cech12.colorblindnessclient.client.ColorBlindnessKeyMappings;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;

public enum ColorEffect {
    ACHROMATOMALY(() -> ColorBlindnessKeyMappings.ACHROMATOMALY),
    ACHROMATOPSIA(() -> ColorBlindnessKeyMappings.ACHROMATOPSIA),
    DEUTERANOMALY(() -> ColorBlindnessKeyMappings.DEUTERANOMALY),
    DEUTERANOPIA(() -> ColorBlindnessKeyMappings.DEUTERANOPIA),
    PROTANOMALY(() -> ColorBlindnessKeyMappings.PROTANOMALY),
    PROTANOPIA(() -> ColorBlindnessKeyMappings.PROTANOPIA),
    TRITANOMALY(() -> ColorBlindnessKeyMappings.TRITANOMALY),
    TRITANOPIA(() -> ColorBlindnessKeyMappings.TRITANOPIA);

    final Supplier<KeyMapping> keyMapping;

    private ColorEffect(Supplier<KeyMapping> keyMapping) {
        this.keyMapping = keyMapping;
    }

    private String getKeyTranslatable() {
        return "key.colorblindnessclient." + this.name().toLowerCase();
    }

    public KeyMapping generateKeyMapping() {
        return new KeyMapping(this.getKeyTranslatable(), InputConstants.Type.KEYSYM, -1, "category.colorblindnessclient.keymappings");
    }

    public static void buttonPressed() {
        for (ColorEffect effect : ColorEffect.values()) {
            if (effect.keyMapping.get() == null || !effect.keyMapping.get().consumeClick()) continue;
            Constants.buttonPressed(effect);
        }
    }
}

