/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.colorblindnessclient.client;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.resource.CrossFrameResourcePool;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import de.cech12.colorblindnessclient.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectRendererHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ACHROMATOMALY = Constants.id("achromatomaly");
    private static final ResourceLocation ACHROMATOPSIA = Constants.id("achromatopsia");
    private static final ResourceLocation DEUTERANOMALY = Constants.id("deuteranomaly");
    private static final ResourceLocation DEUTERANOPIA = Constants.id("deuteranopia");
    private static final ResourceLocation PROTANOMALY = Constants.id("protanomaly");
    private static final ResourceLocation PROTANOPIA = Constants.id("protanopia");
    private static final ResourceLocation TRITANOMALY = Constants.id("tritanomaly");
    private static final ResourceLocation TRITANOPIA = Constants.id("tritanopia");
    private static final CrossFrameResourcePool RESOURCE_POOL = new CrossFrameResourcePool(3);
    private static PostChain achromatomalyShader;
    private static PostChain achromatopsiaShader;
    private static PostChain deuteranomalyShader;
    private static PostChain deuteranopiaShader;
    private static PostChain protanomalyShader;
    private static PostChain protanopiaShader;
    private static PostChain tritanomalyShader;
    private static PostChain tritanopiaShader;

    public static void renderColorBlindnessEffect(float renderTickTime) {
        if (Constants.getActiveEffect() == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            PostChain activeShader;
            EffectRendererHelper.makeColorShaders();
            switch (Constants.getActiveEffect()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ACHROMATOMALY: {
                    PostChain postChain = achromatomalyShader;
                    break;
                }
                case ACHROMATOPSIA: {
                    PostChain postChain = achromatopsiaShader;
                    break;
                }
                case DEUTERANOMALY: {
                    PostChain postChain = deuteranomalyShader;
                    break;
                }
                case DEUTERANOPIA: {
                    PostChain postChain = deuteranopiaShader;
                    break;
                }
                case PROTANOMALY: {
                    PostChain postChain = protanomalyShader;
                    break;
                }
                case PROTANOPIA: {
                    PostChain postChain = protanopiaShader;
                    break;
                }
                case TRITANOMALY: {
                    PostChain postChain = tritanomalyShader;
                    break;
                }
                case TRITANOPIA: {
                    PostChain postChain = activeShader = tritanopiaShader;
                }
            }
            if (activeShader != null) {
                activeShader.process(Minecraft.getInstance().getMainRenderTarget(), (GraphicsResourceAllocator)RESOURCE_POOL);
            }
        }
    }

    private static PostChain createShaderGroup(ResourceLocation location) {
        try {
            return Minecraft.getInstance().getShaderManager().getPostChain(location, LevelTargetBundle.MAIN_TARGETS);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            LOGGER.warn("Failed to parse shader: {}", (Object)location, (Object)jsonsyntaxexception);
            return null;
        }
    }

    private static void makeColorShaders() {
        if (achromatomalyShader == null) {
            achromatomalyShader = EffectRendererHelper.createShaderGroup(ACHROMATOMALY);
        }
        if (achromatopsiaShader == null) {
            achromatopsiaShader = EffectRendererHelper.createShaderGroup(ACHROMATOPSIA);
        }
        if (deuteranomalyShader == null) {
            deuteranomalyShader = EffectRendererHelper.createShaderGroup(DEUTERANOMALY);
        }
        if (deuteranopiaShader == null) {
            deuteranopiaShader = EffectRendererHelper.createShaderGroup(DEUTERANOPIA);
        }
        if (protanomalyShader == null) {
            protanomalyShader = EffectRendererHelper.createShaderGroup(PROTANOMALY);
        }
        if (protanopiaShader == null) {
            protanopiaShader = EffectRendererHelper.createShaderGroup(PROTANOPIA);
        }
        if (tritanomalyShader == null) {
            tritanomalyShader = EffectRendererHelper.createShaderGroup(TRITANOMALY);
        }
        if (tritanopiaShader == null) {
            tritanopiaShader = EffectRendererHelper.createShaderGroup(TRITANOPIA);
        }
    }
}

