/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.colorblindnessclient.client;

import com.google.gson.JsonSyntaxException;
import de.cech12.colorblindnessclient.Constants;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectRendererHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ACHROMATOMALY = Constants.id("shaders/post/achromatomaly.json");
    private static final ResourceLocation ACHROMATOPSIA = Constants.id("shaders/post/achromatopsia.json");
    private static final ResourceLocation DEUTERANOMALY = Constants.id("shaders/post/deuteranomaly.json");
    private static final ResourceLocation DEUTERANOPIA = Constants.id("shaders/post/deuteranopia.json");
    private static final ResourceLocation PROTANOMALY = Constants.id("shaders/post/protanomaly.json");
    private static final ResourceLocation PROTANOPIA = Constants.id("shaders/post/protanopia.json");
    private static final ResourceLocation TRITANOMALY = Constants.id("shaders/post/tritanomaly.json");
    private static final ResourceLocation TRITANOPIA = Constants.id("shaders/post/tritanopia.json");
    private static PostChain achromatomalyShader;
    private static PostChain achromatopsiaShader;
    private static PostChain deuteranomalyShader;
    private static PostChain deuteranopiaShader;
    private static PostChain protanomalyShader;
    private static PostChain protanopiaShader;
    private static PostChain tritanomalyShader;
    private static PostChain tritanopiaShader;
    private static int lastWidth;
    private static int lastHeight;
    private static PostChain lastShader;

    public static void renderColorBlindnessEffect(float renderTickTime) {
        if (Constants.getActiveEffect() == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            PostChain activeShader;
            EffectRendererHelper.makeColorShaders();
            switch (Constants.getActiveEffect()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ACHROMATOMALY: {
                    PostChain postChain = achromatomalyShader;
                    break;
                }
                case ACHROMATOPSIA: {
                    PostChain postChain = achromatopsiaShader;
                    break;
                }
                case DEUTERANOMALY: {
                    PostChain postChain = deuteranomalyShader;
                    break;
                }
                case DEUTERANOPIA: {
                    PostChain postChain = deuteranopiaShader;
                    break;
                }
                case PROTANOMALY: {
                    PostChain postChain = protanomalyShader;
                    break;
                }
                case PROTANOPIA: {
                    PostChain postChain = protanopiaShader;
                    break;
                }
                case TRITANOMALY: {
                    PostChain postChain = tritanomalyShader;
                    break;
                }
                case TRITANOPIA: {
                    PostChain postChain = activeShader = tritanopiaShader;
                }
            }
            if (lastShader != activeShader) {
                lastShader = activeShader;
                lastWidth = 0;
                lastHeight = 0;
            }
            EffectRendererHelper.updateShaderGroupSize(activeShader);
            activeShader.process(renderTickTime);
            Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        }
    }

    private static PostChain createShaderGroup(ResourceLocation location) {
        try {
            Minecraft mc = Minecraft.getInstance();
            return new PostChain(mc.getTextureManager(), (ResourceProvider)mc.getResourceManager(), mc.getMainRenderTarget(), location);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load shader: {}", (Object)location, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            LOGGER.warn("Failed to parse shader: {}", (Object)location, (Object)jsonsyntaxexception);
        }
        return null;
    }

    private static void makeColorShaders() {
        if (achromatomalyShader == null) {
            achromatomalyShader = EffectRendererHelper.createShaderGroup(ACHROMATOMALY);
        }
        if (achromatopsiaShader == null) {
            achromatopsiaShader = EffectRendererHelper.createShaderGroup(ACHROMATOPSIA);
        }
        if (deuteranomalyShader == null) {
            deuteranomalyShader = EffectRendererHelper.createShaderGroup(DEUTERANOMALY);
        }
        if (deuteranopiaShader == null) {
            deuteranopiaShader = EffectRendererHelper.createShaderGroup(DEUTERANOPIA);
        }
        if (protanomalyShader == null) {
            protanomalyShader = EffectRendererHelper.createShaderGroup(PROTANOMALY);
        }
        if (protanopiaShader == null) {
            protanopiaShader = EffectRendererHelper.createShaderGroup(PROTANOPIA);
        }
        if (tritanomalyShader == null) {
            tritanomalyShader = EffectRendererHelper.createShaderGroup(TRITANOMALY);
        }
        if (tritanopiaShader == null) {
            tritanopiaShader = EffectRendererHelper.createShaderGroup(TRITANOPIA);
        }
    }

    private static void updateShaderGroupSize(PostChain shaderGroup) {
        if (shaderGroup != null) {
            Minecraft mc = Minecraft.getInstance();
            int width = mc.getWindow().getWidth();
            int height = mc.getWindow().getHeight();
            if (width != lastWidth || height != lastHeight) {
                lastWidth = width;
                lastHeight = height;
                shaderGroup.resize(width, height);
            }
        }
    }

    static {
        lastWidth = 0;
        lastHeight = 0;
        lastShader = null;
    }
}

