package com.nerjal.structureremover;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.datafixers.util.Either;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7924;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_7066.method_41170;
import static net.minecraft.class_7066.method_41166;

public class StructureRemoverCommand {
    private static final DynamicCommandExceptionType STRUCTURE_INVALID_EXCEPTION =
            new DynamicCommandExceptionType(id -> class_2561.method_43469("commands.locate.structure.invalid", id));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder<class_2168> r = LiteralArgumentBuilder.literal("struct-rem");
        dispatcher.register(r
                .requires(s -> s.method_9259(2))
                .then(method_9244("structure", method_41170(class_7924.field_41246))
                        .suggests((ctx, builder) -> {
                            class_2168 source = ctx.getSource();
                            class_243 pos = source.method_9222();
                            class_2378<class_3195> reg = source.method_9211().method_30611().method_30530(class_7924.field_41246);
                            StringRange range = StringRange.between(builder.getStart(), builder.getInput().length());
                            class_2791 chunk = source.method_9225().method_22350(class_2338.method_49638(pos));
                            chunk.method_12179().keySet().stream().map(
                                    s -> reg.method_29113(s)
                                            .map(k -> k.method_29177().toString())
                                            .orElse(null))
                                    .filter(Objects::nonNull).forEach(builder::suggest);
                            if (ctx.getNodes().get(ctx.getNodes().size()-1).getNode() instanceof ArgumentCommandNode<?,?> node) {
                                node.getType().listSuggestions(ctx, builder);
                            }
                            return builder.buildFuture();
                        })
                        .executes(StructureRemoverCommand::remove)
                        .then(method_9244("location", class_2277.method_9737())
                                .executes(StructureRemoverCommand::remove)
                        )
                )
        );
    }

    private static Optional<? extends class_6885.class_6887<class_3195>> getStructureListForPredicate(
            class_7066.@NotNull class_7068<class_3195> predicate,
            class_2378<class_3195> structureRegistry) {
        Either<class_5321<class_3195>, class_6862<class_3195>> either = predicate.method_41173();
        Function<class_5321<class_3195>, Optional<class_6885.class_6886<?>>> var10001 = key ->
                structureRegistry.method_40264(key).map(entry ->
                        class_6885.method_40246(entry)
            );
        Objects.requireNonNull(structureRegistry);
        //noinspection unchecked
        return (Optional<class_6885.class_6887<class_3195>>)either.map(var10001, structureRegistry::method_40266);
    }

    static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            class_2378<class_3195> registry =
                    context.getSource().method_9225().method_30349().method_30530(class_7924.field_41246);
            class_7066.class_7068<class_3195> predicate =
                    method_41166(context, "structure", class_7924.field_41246, STRUCTURE_INVALID_EXCEPTION);
            class_6885<class_3195> list = getStructureListForPredicate(predicate, registry)
                    .orElseThrow(() -> STRUCTURE_INVALID_EXCEPTION.create(predicate.method_41176()));
            class_243 vec;
            try {
                vec = class_2277.method_9736(context, "location");
            } catch (IllegalArgumentException e) {
                vec = context.getSource().method_9222();
            }
            class_2338 pos = new class_2338(new class_2382((int) vec.field_1352, (int) vec.field_1351, (int) vec.field_1350));
            list.forEach(struct ->
                    StructureRemover.removeStructure(context.getSource().method_9225(), pos, struct.comp_349()));
        } catch (Exception e) {
            StructureRemover.LOGGER.error(e);
            throw e;
        }
        return 0;
    }
}
