/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.corpse;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.lukiiy.corpse.Cmd;
import me.lukiiy.manneInventory.MannequinInventoryManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Corpse
extends JavaPlugin
implements Listener {
    private final Set<Mannequin> tracked = ConcurrentHashMap.newKeySet();
    public static NamespacedKey KEY;
    private NamespacedKey xpKey;
    private int lifespan;

    public void onEnable() {
        this.setupConfig();
        KEY = new NamespacedKey((Plugin)this, "corpse");
        this.xpKey = new NamespacedKey((Plugin)this, "xp");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this, task -> {
            if (this.lifespan < 1) {
                return;
            }
            this.tracked.forEach(npc -> {
                String data = (String)npc.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
                if (data == null || !data.contains(";")) {
                    return;
                }
                String[] parts = data.split(";");
                if (parts.length < 2) {
                    return;
                }
                try {
                    if (!npc.isDead() && npc.getWorld().getGameTime() - Long.parseLong(parts[0]) >= Long.parseLong(parts[1])) {
                        this.popCorpseData((Mannequin)npc);
                        npc.remove();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }, 20L, 100L);
        this.registerCommand("corpse", new Cmd());
    }

    public void onDisable() {
    }

    public static Corpse getInstance() {
        return (Corpse)JavaPlugin.getPlugin(Corpse.class);
    }

    public void setupConfig() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.lifespan = this.getConfig().getInt("lifespan", 300);
    }

    private String doPlaceholders(String thing, Player player) {
        return thing.replace("%p", (CharSequence)MiniMessage.miniMessage().serialize(player.displayName()));
    }

    public Mannequin makeCorpse(Player p) {
        Location location = p.getLocation();
        if (location.getWorld() == null) {
            return null;
        }
        return (Mannequin)location.getWorld().spawn(location, Mannequin.class, entity -> {
            entity.setProfile(this.getSkinProfile(p));
            entity.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)(location.getWorld().getGameTime() + ";" + this.lifespan * 20));
            entity.setGravity(this.getConfig().getBoolean("gravity"));
            entity.setInvulnerable(this.getConfig().getBoolean("invulnerable"));
            entity.setImmovable(this.getConfig().getBoolean("immovable"));
            entity.setMainHand(p.getMainHand());
            if (this.getConfig().getBoolean("keepVelocity")) {
                entity.setVelocity(p.getVelocity());
            }
            String selector0$temp = this.getConfig().getString("pose");
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"fall_falling", "crouching", "sneaking", "sleeping"}, (Object)selector0$temp, index$1)) {
                case 0: {
                    entity.setPose(Pose.FALL_FLYING);
                    break;
                }
                case 1: 
                case 2: {
                    entity.setPose(Pose.SNEAKING);
                    break;
                }
                case 3: {
                    entity.setPose(Pose.SLEEPING);
                    break;
                }
                default: {
                    entity.setPose(Pose.SWIMMING);
                }
            }
            double hp = this.getConfig().getDouble("health");
            if (hp > 0.0) {
                AttributeInstance hpInst = entity.getAttribute(Attribute.MAX_HEALTH);
                if (hpInst != null) {
                    hpInst.setBaseValue(hp);
                }
                entity.setHealth(hp);
            }
            String name = this.getConfig().getString("name", "");
            String label = this.getConfig().getString("label", "");
            entity.customName(name.isBlank() ? null : MiniMessage.miniMessage().deserialize((Object)this.doPlaceholders(name, p)));
            entity.setDescription(label.isBlank() ? null : MiniMessage.miniMessage().deserialize((Object)this.doPlaceholders(label, p)));
            entity.setCustomNameVisible(this.getConfig().getBoolean("nameAlwaysVisible"));
        });
    }

    public void popCorpseData(Mannequin mannequin) {
        Inventory npcInv = MannequinInventoryManager.get(mannequin);
        if (npcInv == null || npcInv.isEmpty()) {
            return;
        }
        Location loc = mannequin.getLocation();
        if (loc.getWorld() == null) {
            return;
        }
        Location spawn = loc.add(0.0, 0.3, 0.0);
        for (ItemStack item : npcInv.getContents()) {
            if (item == null) continue;
            loc.getWorld().dropItemNaturally(spawn, item);
        }
        int xp = (Integer)mannequin.getPersistentDataContainer().getOrDefault(this.xpKey, PersistentDataType.INTEGER, (Object)0);
        if (xp > 0) {
            loc.getWorld().spawn(spawn, ExperienceOrb.class, orb -> orb.setExperience(xp));
        }
        mannequin.getEquipment().clear();
        npcInv.clear();
    }

    public Set<Mannequin> getTracked() {
        return Collections.unmodifiableSet(this.tracked);
    }

    private ResolvableProfile getSkinProfile(Player p) {
        String skin = this.getConfig().getString("skin", "").trim();
        if (skin.isEmpty()) {
            return ResolvableProfile.resolvableProfile((PlayerProfile)p.getPlayerProfile());
        }
        try {
            return ResolvableProfile.resolvableProfile((PlayerProfile)this.getServer().createProfile(UUID.fromString(skin)));
        }
        catch (IllegalArgumentException ex) {
            if (skin.length() > 16) {
                PlayerProfile profile = this.getServer().createProfile(UUID.randomUUID());
                profile.setProperty(new ProfileProperty("textures", skin));
                return ResolvableProfile.resolvableProfile((PlayerProfile)profile);
            }
            return ResolvableProfile.resolvableProfile((PlayerProfile)this.getServer().createProfile(skin));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void death(PlayerDeathEvent e) {
        Player p = e.getEntity();
        Mannequin npc = this.makeCorpse(e.getEntity());
        if (npc == null) {
            return;
        }
        if (!this.getConfig().getString("itemTreatment", "default").equalsIgnoreCase("default")) {
            e.getDrops().clear();
            PlayerInventory inv = p.getInventory();
            EntityEquipment equip = npc.getEquipment();
            equip.setHelmet(inv.getHelmet(), false);
            equip.setChestplate(inv.getChestplate(), false);
            equip.setLeggings(inv.getLeggings(), false);
            equip.setBoots(inv.getBoots(), false);
            equip.setItemInOffHand(inv.getItemInMainHand(), false);
            equip.setItemInOffHand(inv.getItemInOffHand(), false);
            Inventory inventory = Bukkit.createInventory(null, (int)54);
            inventory.setContents((ItemStack[])Arrays.stream(inv.getContents()).filter(Objects::nonNull).toArray(ItemStack[]::new));
            MannequinInventoryManager.set(npc, inventory);
        }
        if (!this.getConfig().getString("xpTreatment", "default").equalsIgnoreCase("default")) {
            e.setShouldDropExperience(false);
            npc.getPersistentDataContainer().set(this.xpKey, PersistentDataType.INTEGER, (Object)e.getDroppedExp());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void damage(EntityDamageEvent e) {
        Mannequin npc;
        Entity entity = e.getEntity();
        if (!(entity instanceof Mannequin) || !(npc = (Mannequin)entity).getPersistentDataContainer().has(KEY) || this.getConfig().getBoolean("onlyAcceptEntityDamage")) {
            return;
        }
        if (e.getDamageSource().getCausingEntity() == null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void npcDeath(EntityDeathEvent e) {
        Mannequin npc;
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Mannequin) || !(npc = (Mannequin)livingEntity).getPersistentDataContainer().has(KEY)) {
            return;
        }
        this.popCorpseData(npc);
    }

    @EventHandler
    public void interaction(PlayerInteractEntityEvent e) {
        Mannequin npc;
        Entity entity = e.getRightClicked();
        if (!(entity instanceof Mannequin && (npc = (Mannequin)entity).getPersistentDataContainer().has(KEY) && this.getConfig().getString("itemTreatment", "").equalsIgnoreCase("pop"))) {
            return;
        }
        Inventory npcInv = MannequinInventoryManager.get(npc);
        if (npcInv == null || npcInv.isEmpty()) {
            return;
        }
        Player p = e.getPlayer();
        this.popCorpseData(npc);
        p.playSound(npc.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
    }

    @EventHandler
    public void worldEntityAdd(EntityAddToWorldEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Mannequin)) {
            return;
        }
        Mannequin npc = (Mannequin)entity;
        if (npc.getPersistentDataContainer().has(KEY, PersistentDataType.STRING)) {
            this.tracked.add(npc);
        }
    }

    @EventHandler
    public void worldEntityRemove(EntityRemoveFromWorldEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Mannequin)) {
            return;
        }
        Mannequin npc = (Mannequin)entity;
        if (npc.getPersistentDataContainer().has(KEY, PersistentDataType.STRING)) {
            this.tracked.remove(npc);
        }
    }
}

