/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.corpse;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.lukiiy.corpse.Cmd;
import me.lukiiy.manneInventory.MannequinInventoryManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Corpse
extends JavaPlugin
implements Listener {
    private final Set<Mannequin> tracked = ConcurrentHashMap.newKeySet();
    public static NamespacedKey KEY;

    public void onEnable() {
        this.setupConfig();
        KEY = new NamespacedKey((Plugin)this, "corpse");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this, task -> this.tracked.forEach(npc -> {
            String data = (String)npc.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
            if (data == null || !data.contains(";")) {
                return;
            }
            String[] parts = data.split(";");
            if (parts.length < 2) {
                return;
            }
            try {
                if (!npc.isDead() && npc.getWorld().getGameTime() - Long.parseLong(parts[0]) >= Long.parseLong(parts[1])) {
                    this.popInventory((Mannequin)npc);
                    npc.remove();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }), 20L, 100L);
        this.registerCommand("corpse", new Cmd());
    }

    public void onDisable() {
    }

    public static Corpse getInstance() {
        return (Corpse)JavaPlugin.getPlugin(Corpse.class);
    }

    public void setupConfig() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    private String doPlaceholders(String thing, Player player) {
        return thing.replace("%p", (CharSequence)MiniMessage.miniMessage().serialize(player.displayName()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void death(PlayerDeathEvent e) {
        Player player = e.getEntity();
        PlayerInventory inv = player.getInventory();
        Location location = player.getLocation();
        if (location.getWorld() == null) {
            return;
        }
        Mannequin mannequin = (Mannequin)location.getWorld().spawn(location, Mannequin.class, entity -> {
            entity.setProfile(ResolvableProfile.resolvableProfile((PlayerProfile)player.getPlayerProfile()));
            entity.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)(location.getWorld().getGameTime() + ";" + this.getConfig().getInt("lifespan", 300) * 20));
            entity.setGravity(this.getConfig().getBoolean("gravity"));
            entity.setInvulnerable(this.getConfig().getBoolean("invulnerable"));
            entity.setImmovable(this.getConfig().getBoolean("immovable"));
            if (this.getConfig().getBoolean("keepVelocity")) {
                entity.setVelocity(player.getVelocity());
            }
            String selector0$temp = this.getConfig().getString("pose");
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"fall_falling", "crouching", "sleeping"}, (Object)selector0$temp, index$1)) {
                case 0: {
                    entity.setPose(Pose.FALL_FLYING);
                    break;
                }
                case 1: {
                    entity.setPose(Pose.SNEAKING);
                    break;
                }
                case 2: {
                    entity.setPose(Pose.SLEEPING);
                    break;
                }
                default: {
                    entity.setPose(Pose.SWIMMING);
                }
            }
            double hp = this.getConfig().getDouble("health");
            if (hp > 0.0) {
                AttributeInstance hpInst = entity.getAttribute(Attribute.MAX_HEALTH);
                if (hpInst != null) {
                    hpInst.setBaseValue(hp);
                }
                entity.setHealth(hp);
            }
            String itemMode = this.getConfig().getString("itemTreatment", "default");
            if (!inv.isEmpty() && !itemMode.equalsIgnoreCase("default")) {
                e.getDrops().clear();
                EntityEquipment equip = entity.getEquipment();
                equip.setHelmet(inv.getHelmet(), false);
                equip.setChestplate(inv.getChestplate(), false);
                equip.setLeggings(inv.getLeggings(), false);
                equip.setBoots(inv.getBoots(), false);
                equip.setItemInOffHand(inv.getItemInMainHand(), false);
                equip.setItemInOffHand(inv.getItemInOffHand(), false);
                Inventory inventory = Bukkit.createInventory(null, (int)54);
                inventory.setContents((ItemStack[])Arrays.stream(inv.getContents()).filter(Objects::nonNull).toArray(ItemStack[]::new));
                MannequinInventoryManager.set(entity, inventory);
            }
        });
        mannequin.setProfile(ResolvableProfile.resolvableProfile((PlayerProfile)player.getPlayerProfile()));
        mannequin.setMainHand(player.getMainHand());
        String label = this.getConfig().getString("label", "");
        mannequin.setDescription((Component)(label.isBlank() ? Component.empty() : MiniMessage.miniMessage().deserialize((Object)this.doPlaceholders(label, player))));
        mannequin.setCustomNameVisible(!label.isBlank());
    }

    private void popInventory(Mannequin mannequin) {
        Inventory npcInv = MannequinInventoryManager.get(mannequin);
        if (npcInv == null || npcInv.isEmpty()) {
            return;
        }
        Location loc = mannequin.getLocation();
        if (loc.getWorld() == null) {
            return;
        }
        Location spawn = loc.add(0.0, 0.3, 0.0);
        for (ItemStack item : npcInv.getContents()) {
            if (item == null) continue;
            loc.getWorld().dropItemNaturally(spawn, item);
        }
        mannequin.getEquipment().clear();
        npcInv.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void npcDeath(EntityDeathEvent e) {
        Mannequin npc;
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Mannequin) || !(npc = (Mannequin)livingEntity).getPersistentDataContainer().has(KEY)) {
            return;
        }
        this.popInventory(npc);
    }

    @EventHandler
    public void rightClick(PlayerInteractEntityEvent e) {
        Mannequin npc;
        Entity entity = e.getRightClicked();
        if (!(entity instanceof Mannequin && (npc = (Mannequin)entity).getPersistentDataContainer().has(KEY) && this.getConfig().getString("itemTreatment", "").equalsIgnoreCase("loot"))) {
            return;
        }
        Inventory npcInv = MannequinInventoryManager.get(npc);
        if (npcInv == null || npcInv.isEmpty()) {
            return;
        }
        Player p = e.getPlayer();
        this.popInventory(npc);
        p.playSound(npc.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
    }

    @EventHandler
    public void worldEntityAdd(EntityAddToWorldEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Mannequin)) {
            return;
        }
        Mannequin npc = (Mannequin)entity;
        if (npc.getPersistentDataContainer().has(KEY, PersistentDataType.STRING)) {
            this.tracked.add(npc);
        }
    }

    @EventHandler
    public void worldEntityRemove(EntityRemoveFromWorldEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Mannequin)) {
            return;
        }
        Mannequin npc = (Mannequin)entity;
        if (npc.getPersistentDataContainer().has(KEY, PersistentDataType.STRING)) {
            this.tracked.remove(npc);
        }
    }
}

