/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ninni.spawn.mixin.accessor.ComposterBlockAccessor;
import com.ninni.spawn.mixin.accessor.FireBlockAccessor;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnDecoratedPotPatterns;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnNetwork;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.data.AnthillRotManager;
import com.ninni.spawn.server.data.BlockVariantManager;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommonProxy {
    private final AnimalVariantManager animalVariantManager = new AnimalVariantManager();
    private final BlockVariantManager blockVariantManager = new BlockVariantManager();
    private final AnthillRotManager anthillRotManager = new AnthillRotManager();

    public void init() {
    }

    public void commonSetup() {
        CommonProxy.registerStrippables();
        CommonProxy.registerFlammables();
        CommonProxy.registerCompostables();
        CommonProxy.registerPotPatterns();
        SpawnNetwork.init();
    }

    public void clientSetup() {
    }

    public void playClientSoundEvent(SoundEvent soundEvent, SoundSource source, float volume, float pitch, long seed) {
    }

    public Level getWorld() {
        return ServerLifecycleHooks.getCurrentServer().m_129783_();
    }

    public Player getClientPlayer() {
        return null;
    }

    private static void registerPotPatterns() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.putAll(DecoratedPotPatterns.f_271367_);
        map.put((Object)((Item)SpawnItems.CROWN_POTTERY_SHERD.get()), (Object)SpawnDecoratedPotPatterns.CROWN.getKey());
        map.put((Object)((Item)SpawnItems.SPADE_POTTERY_SHERD.get()), (Object)SpawnDecoratedPotPatterns.SPADE.getKey());
        map.put((Object)((Item)SpawnItems.SCHOOL_POTTERY_SHERD.get()), (Object)SpawnDecoratedPotPatterns.SCHOOL.getKey());
        map.put((Object)((Item)SpawnItems.SHELL_POTTERY_SHERD.get()), (Object)SpawnDecoratedPotPatterns.SHELL.getKey());
        DecoratedPotPatterns.f_271367_ = map.build();
    }

    private static void registerStrippables() {
        AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
        AxeItem.f_150683_.put((Block)SpawnBlocks.ROTTEN_LOG.get(), (Block)SpawnBlocks.STRIPPED_ROTTEN_LOG.get());
        AxeItem.f_150683_.put((Block)SpawnBlocks.ROTTEN_WOOD.get(), (Block)SpawnBlocks.STRIPPED_ROTTEN_WOOD.get());
    }

    private static void registerFlammables() {
        FireBlockAccessor accessor = (FireBlockAccessor)Blocks.f_50083_;
        accessor.callSetFlammable((Block)SpawnBlocks.FALLEN_LEAVES.get(), 60, 100);
        accessor.callSetFlammable((Block)SpawnBlocks.SUNFLOWER.get(), 60, 100);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_LOG.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_WOOD.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.STRIPPED_ROTTEN_LOG.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.STRIPPED_ROTTEN_WOOD.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.CRACKED_ROTTEN_PLANKS.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_PLANKS.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_SLAB.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_STAIRS.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_FENCE.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_FENCE_GATE.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.RED_ALGAE.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.RED_ALGAE_BLOCK.get(), 5, 5);
    }

    private static void registerCompostables() {
        ComposterBlockAccessor.callAdd(0.5f, (ItemLike)SpawnItems.TALL_WINDSWEPT_GRASS.get());
        ComposterBlockAccessor.callAdd(0.3f, (ItemLike)SpawnItems.SHORT_WINDSWEPT_GRASS.get());
        ComposterBlockAccessor.callAdd(0.25f, (ItemLike)SpawnItems.RED_ALGAE.get());
        ComposterBlockAccessor.callAdd(0.25f, (ItemLike)SpawnItems.FALLEN_LEAVES.get());
        ComposterBlockAccessor.callAdd(0.65f, (ItemLike)SpawnItems.SUNFLOWER.get());
        ComposterBlockAccessor.callAdd(0.8f, (ItemLike)SpawnItems.TUNA_SANDWICH.get());
        ComposterBlockAccessor.callAdd(0.8f, (ItemLike)SpawnItems.SNAIL_SHELL.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.ROTTEN_LOG.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.ROTTEN_WOOD.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.STRIPPED_ROTTEN_LOG.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.STRIPPED_ROTTEN_WOOD.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.CRACKED_ROTTEN_PLANKS.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.ROTTEN_PLANKS.get());
    }

    public AnimalVariantManager getAnimalVariantManager() {
        return this.animalVariantManager;
    }

    public BlockVariantManager getBlockVariantManager() {
        return this.blockVariantManager;
    }

    public AnthillRotManager getAnthillRotManager() {
        return this.anthillRotManager;
    }
}

