/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn;

import com.mojang.logging.LogUtils;
import com.ninni.spawn.CommonProxy;
import com.ninni.spawn.client.ClientProxy;
import com.ninni.spawn.registry.SpawnBiomeModifiers;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnCreativeModeTab;
import com.ninni.spawn.registry.SpawnDecoratedPotPatterns;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnFeatures;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnMenuTypes;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnPointsOfInterests;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnStructureProcessors;
import com.ninni.spawn.server.events.ForgeEvents;
import com.ninni.spawn.server.events.ModEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="spawn")
public class Spawn {
    public static final String MOD_ID = "spawn";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public Spawn() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        SpawnBlocks.BLOCKS.register(modEventBus);
        SpawnBiomeModifiers.BIOME_MODIFIERS.register(modEventBus);
        SpawnBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        SpawnCreativeModeTab.CREATIVE_MODE_TABS.register(modEventBus);
        SpawnDecoratedPotPatterns.DECORATED_POT_PATTERNS.register(modEventBus);
        SpawnEntityType.ENTITY_TYPES.register(modEventBus);
        SpawnFeatures.FEATURES.register(modEventBus);
        SpawnParticles.PARTICLE_TYPES.register(modEventBus);
        SpawnSoundEvents.SOUND_EVENTS.register(modEventBus);
        SpawnPointsOfInterests.POI_TYPES.register(modEventBus);
        SpawnItems.ITEMS.register(modEventBus);
        SpawnMenuTypes.MENUS.register(modEventBus);
        SpawnStructureProcessors.PROCESSORS.register(modEventBus);
        PROXY.init();
        eventBus.register((Object)new ForgeEvents());
        eventBus.register((Object)new ModEvents());
        eventBus.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PROXY.commonSetup());
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> PROXY.clientSetup());
    }
}

