/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.events;

import com.google.common.collect.Lists;
import com.ninni.spawn.client.model.AnglerFishModel;
import com.ninni.spawn.client.model.AntModel;
import com.ninni.spawn.client.model.BarracudaModel;
import com.ninni.spawn.client.model.ClamModel;
import com.ninni.spawn.client.model.DragonflyModel;
import com.ninni.spawn.client.model.HamsterModel;
import com.ninni.spawn.client.model.HerringModel;
import com.ninni.spawn.client.model.OctopusModel;
import com.ninni.spawn.client.model.SeaCowModel;
import com.ninni.spawn.client.model.SeahorseModel;
import com.ninni.spawn.client.model.SnailModel;
import com.ninni.spawn.client.model.StickbugModel;
import com.ninni.spawn.client.model.SunfishModel;
import com.ninni.spawn.client.model.TunaEggModel;
import com.ninni.spawn.client.model.TunaModel;
import com.ninni.spawn.client.particles.DragonflyParticle;
import com.ninni.spawn.client.particles.SandCloudParticle;
import com.ninni.spawn.client.particles.TunaEggParticle;
import com.ninni.spawn.client.renderer.block.ClamLauncherRenderer;
import com.ninni.spawn.client.renderer.block.HamsterWheelRenderer;
import com.ninni.spawn.client.renderer.block.MorayCreviceRenderer;
import com.ninni.spawn.client.renderer.block.PigmentShifterRenderer;
import com.ninni.spawn.client.renderer.entity.AnglerFishRenderer;
import com.ninni.spawn.client.renderer.entity.AntRenderer;
import com.ninni.spawn.client.renderer.entity.BarracudaRenderer;
import com.ninni.spawn.client.renderer.entity.ClamRenderer;
import com.ninni.spawn.client.renderer.entity.HamsterRenderer;
import com.ninni.spawn.client.renderer.entity.HerringRenderer;
import com.ninni.spawn.client.renderer.entity.OctopusRenderer;
import com.ninni.spawn.client.renderer.entity.SeaCowRenderer;
import com.ninni.spawn.client.renderer.entity.SeahorseRenderer;
import com.ninni.spawn.client.renderer.entity.SnailRenderer;
import com.ninni.spawn.client.renderer.entity.StickbugRenderer;
import com.ninni.spawn.client.renderer.entity.SunfishRenderer;
import com.ninni.spawn.client.renderer.entity.TunaEggRenderer;
import com.ninni.spawn.client.renderer.entity.TunaRenderer;
import com.ninni.spawn.client.renderer.item.CapturedMobsTooltipRenderer;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.server.item.tooltip.CapturedMobsTooltipData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="spawn", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpawnEntityModelLayers.ANGLER_FISH, AnglerFishModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.ANGLER_FISH_DEFLATED, AnglerFishModel::getDeflatedLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.TUNA, TunaModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.TUNA_EGG, TunaEggModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SEAHORSE_LANKY, SeahorseModel::getLankyLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SEAHORSE_BONKY, SeahorseModel::getBonkyLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SEAHORSE_STOUT, SeahorseModel::getStoutLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SEAHORSE_TINY, SeahorseModel::getTinyLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SNAIL, SnailModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.HAMSTER, HamsterModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.HAMSTER_STANDING, HamsterModel::getStandingLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.ANT, AntModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.CLAM_LAUNCHER, ClamLauncherRenderer::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.PIGMENT_SHIFTER, PigmentShifterRenderer::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.HAMSTER_WHEEL, HamsterWheelRenderer::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.HERRING, HerringModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SEA_COW, SeaCowModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.CLAM_WEDGE_SHELL, ClamModel::createWedgeShellLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.CLAM_SCALLOP, ClamModel::createScallopLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.CLAM_GIANT_CLAM, ClamModel::createGiantClamLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.OCTOPUS, OctopusModel::createBodyLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.OCTOPUS_LOCKING, OctopusModel::createLockingBodyLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.SUNFISH, SunfishModel::createBodyLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.SUNFISH_BABY, SunfishModel::createBabyBodyLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.SUNFISH_NEWBORN, SunfishModel::createNewbornBodyLayer);
        event.registerLayerDefinition(SpawnEntityModelLayers.MORAY_EEL, MorayCreviceRenderer::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.STICKBUG, StickbugModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.DRAGONFLY, DragonflyModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.BARRACUDA, BarracudaModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SpawnEntityType.ANGLER_FISH.get(), AnglerFishRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.TUNA.get(), TunaRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.TUNA_EGG.get(), TunaEggRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.SEAHORSE.get(), SeahorseRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.SNAIL.get(), SnailRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.HAMSTER.get(), HamsterRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.ANT.get(), AntRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.HERRING.get(), HerringRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.SEA_COW.get(), SeaCowRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.CLAM.get(), ClamRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.OCTOPUS.get(), OctopusRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.SUNFISH.get(), SunfishRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.STICKBUG.get(), StickbugRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.BARRACUDA.get(), BarracudaRenderer::new);
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)SpawnBlockEntityTypes.PIGMENT_SHIFTER.get(), PigmentShifterRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpawnBlockEntityTypes.CLAM_LAUNCHER.get(), ClamLauncherRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpawnBlockEntityTypes.HAMSTER_WHEEL.get(), HamsterWheelRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SpawnBlockEntityTypes.MORAY_CREVICE.get(), MorayCreviceRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SpawnParticles.ANGLER_FISH_LANTERN_GLOW.get(), GlowParticle.GlowSquidProvider::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.TUNA_EGG.get(), TunaEggParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.SAND_CLOUD.get(), SandCloudParticle.Factory::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.SPRING_DRAGONFLY.get(), DragonflyParticle.SpringFactory::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.FALL_DRAGONFLY.get(), DragonflyParticle.FallFactory::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.SUMMER_DRAGONFLY.get(), DragonflyParticle.SummerFactory::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.WINTER_DRAGONFLY.get(), DragonflyParticle.WinterFactory::new);
    }

    @SubscribeEvent
    public static void registerTooltips(RegisterClientTooltipComponentFactoriesEvent registry) {
        registry.register(CapturedMobsTooltipData.class, CapturedMobsTooltipRenderer::new);
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addAfter(map, after, blk));
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addBefore(map, before, blk));
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike block) {
        map.putAfter((Object)FUNCTION.apply(after), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike block) {
        map.putBefore((Object)FUNCTION.apply(before), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void accept(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike block) {
        map.put((Object)new ItemStack(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    @SubscribeEvent
    public static void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        ResourceKey tabKey = event.getTabKey();
        if (tabKey.equals((Object)CreativeModeTabs.f_256788_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150992_, (ItemLike)SpawnItems.BIG_SNAIL_SHELL.get(), (ItemLike)SpawnItems.SNAIL_SHELL_TILES.get(), (ItemLike)SpawnItems.SNAIL_SHELL_TILE_STAIRS.get(), (ItemLike)SpawnItems.SNAIL_SHELL_TILE_SLAB.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271474_, (ItemLike)SpawnItems.ROTTEN_LOG.get(), (ItemLike)SpawnItems.ROTTEN_WOOD.get(), (ItemLike)SpawnItems.STRIPPED_ROTTEN_LOG.get(), (ItemLike)SpawnItems.STRIPPED_ROTTEN_WOOD.get(), (ItemLike)SpawnItems.ROTTEN_PLANKS.get(), (ItemLike)SpawnItems.CRACKED_ROTTEN_PLANKS.get(), (ItemLike)SpawnItems.ROTTEN_STAIRS.get(), (ItemLike)SpawnItems.ROTTEN_SLAB.get(), (ItemLike)SpawnItems.ROTTEN_FENCE.get(), (ItemLike)SpawnItems.ROTTEN_FENCE_GATE.get(), (ItemLike)SpawnItems.ROTTEN_DOOR.get(), (ItemLike)SpawnItems.ROTTEN_TRAPDOOR.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42067_, (ItemLike)SpawnItems.REEFSTONE.get(), (ItemLike)SpawnItems.REEFSTONE_STAIRS.get(), (ItemLike)SpawnItems.REEFSTONE_SLAB.get(), (ItemLike)SpawnItems.REEFSTONE_WALL.get(), (ItemLike)SpawnItems.ALGAL_REEFSTONE.get(), (ItemLike)SpawnItems.ALGAL_REEFSTONE_STAIRS.get(), (ItemLike)SpawnItems.ALGAL_REEFSTONE_SLAB.get(), (ItemLike)SpawnItems.ALGAL_REEFSTONE_WALL.get(), (ItemLike)SpawnItems.REEFSTONE_TILES.get(), (ItemLike)SpawnItems.REEFSTONE_TILE_STAIRS.get(), (ItemLike)SpawnItems.REEFSTONE_TILE_SLAB.get(), (ItemLike)SpawnItems.REEFSTONE_TILE_WALL.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256869_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42457_, (ItemLike)SpawnItems.TUNA_EGG_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42458_, (ItemLike)SpawnItems.ANGLER_FISH_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42457_, (ItemLike)SpawnItems.HERRING_BUCKET.get(), (ItemLike)SpawnItems.BABY_SUNFISH_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42459_, (ItemLike)SpawnItems.SEAHORSE_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42455_, (ItemLike)SpawnItems.CAPTURED_OCTOPUS.get(), (ItemLike)SpawnItems.CLAM.get(), (ItemLike)SpawnItems.SUSPICIOUS_STICK.get(), (ItemLike)SpawnItems.ANT_PUPA.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42523_, (ItemLike)SpawnItems.CASTING_NET.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_283830_, (ItemLike)SpawnItems.MUSIC_DISC_ROT.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_283830_, (ItemLike)SpawnItems.MUSIC_DISC_WATER_HORSE.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42712_, (ItemLike)SpawnItems.MUSIC_DISC_JAMMED.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42711_, (ItemLike)SpawnItems.MUSIC_DISC_RAIN.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_257028_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42788_, (ItemLike)SpawnItems.MUCUS_BLOCK.get(), (ItemLike)SpawnItems.GHOSTLY_MUCUS_BLOCK.get(), (ItemLike)SpawnItems.CLAM_LAUNCHER.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42726_, (ItemLike)SpawnItems.HAMSTER_WHEEL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42544_, (ItemLike)SpawnItems.OCTODUCT.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42162_, (ItemLike)SpawnItems.MORAY_CREVICE.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256776_)) {
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42207_, (ItemLike)SpawnItems.SUNFLOWER.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42733_, (ItemLike)SpawnItems.SUNFLOWER_SEEDS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151015_, (ItemLike)SpawnItems.RED_ALGAE_BLOCK.get(), (ItemLike)SpawnItems.RED_ALGAE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42788_, (ItemLike)SpawnItems.MUCUS_BLOCK.get(), (ItemLike)SpawnItems.BIG_SNAIL_SHELL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_220223_, (ItemLike)SpawnItems.SNAIL_EGGS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42789_, (ItemLike)SpawnItems.ANTHILL.get(), (ItemLike)SpawnItems.ROTTEN_LOG_ANTHILL.get(), (ItemLike)SpawnItems.ANT_MOUND.get(), (ItemLike)SpawnItems.MORAY_CREVICE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271090_, (ItemLike)SpawnItems.ROTTEN_LOG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41866_, (ItemLike)SpawnItems.FALLEN_LEAVES.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41830_, (ItemLike)SpawnItems.ALGAL_SAND.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41868_, (ItemLike)SpawnItems.BIG_SEA_PICKLE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42780_, (ItemLike)SpawnItems.POTTED_SWEET_BERRIES.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41865_, (ItemLike)SpawnItems.SHORT_WINDSWEPT_GRASS.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42211_, (ItemLike)SpawnItems.TALL_WINDSWEPT_GRASS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_276468_, (ItemLike)SpawnItems.DRIED_HAMSTER.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41911_, (ItemLike)SpawnItems.SPRING_DRAGON_REEDS.get(), (ItemLike)SpawnItems.SUMMER_DRAGON_REEDS.get(), (ItemLike)SpawnItems.FALL_DRAGON_REEDS.get(), (ItemLike)SpawnItems.WINTER_DRAGON_REEDS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42362_, (ItemLike)SpawnItems.WAX_CORAL_BLOCK.get(), (ItemLike)SpawnItems.THORN_CORAL_BLOCK.get(), (ItemLike)SpawnItems.SPIKE_CORAL_BLOCK.get(), (ItemLike)SpawnItems.HEART_CORAL_BLOCK.get(), (ItemLike)SpawnItems.REED_CORAL_BLOCK.get(), (ItemLike)SpawnItems.DEAD_WAX_CORAL_BLOCK.get(), (ItemLike)SpawnItems.DEAD_THORN_CORAL_BLOCK.get(), (ItemLike)SpawnItems.DEAD_SPIKE_CORAL_BLOCK.get(), (ItemLike)SpawnItems.DEAD_HEART_CORAL_BLOCK.get(), (ItemLike)SpawnItems.DEAD_REED_CORAL_BLOCK.get(), (ItemLike)SpawnItems.WAX_CORAL.get(), (ItemLike)SpawnItems.THORN_CORAL.get(), (ItemLike)SpawnItems.SPIKE_CORAL.get(), (ItemLike)SpawnItems.HEART_CORAL.get(), (ItemLike)SpawnItems.REED_CORAL.get(), (ItemLike)SpawnItems.DEAD_WAX_CORAL.get(), (ItemLike)SpawnItems.DEAD_THORN_CORAL.get(), (ItemLike)SpawnItems.DEAD_SPIKE_CORAL.get(), (ItemLike)SpawnItems.DEAD_HEART_CORAL.get(), (ItemLike)SpawnItems.DEAD_REED_CORAL.get(), (ItemLike)SpawnItems.WAX_CORAL_FAN.get(), (ItemLike)SpawnItems.THORN_CORAL_FAN.get(), (ItemLike)SpawnItems.SPIKE_CORAL_FAN.get(), (ItemLike)SpawnItems.HEART_CORAL_FAN.get(), (ItemLike)SpawnItems.REED_CORAL_FAN.get(), (ItemLike)SpawnItems.DEAD_WAX_CORAL_FAN.get(), (ItemLike)SpawnItems.DEAD_THORN_CORAL_FAN.get(), (ItemLike)SpawnItems.DEAD_SPIKE_CORAL_FAN.get(), (ItemLike)SpawnItems.DEAD_HEART_CORAL_FAN.get(), (ItemLike)SpawnItems.DEAD_REED_CORAL_FAN.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256791_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151025_, (ItemLike)SpawnItems.MUCUS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42785_, (ItemLike)SpawnItems.ANTHILL.get(), (ItemLike)SpawnItems.ROTTEN_LOG_ANTHILL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42786_, (ItemLike)SpawnItems.ANT_FARM.get(), (ItemLike)SpawnItems.ANT_MOUND.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42364_, (ItemLike)SpawnItems.PIGMENT_SHIFTER.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256839_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42575_, (ItemLike)SpawnItems.ROASTED_SUNFLOWER_SEEDS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42529_, (ItemLike)SpawnItems.ESCARGOT.get(), (ItemLike)SpawnItems.CLAM_MEAT.get(), (ItemLike)SpawnItems.COOKED_CLAM_MEAT.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42531_, (ItemLike)SpawnItems.HERRING.get(), (ItemLike)SpawnItems.COOKED_HERRING.get(), (ItemLike)SpawnItems.TUNA_CHUNK.get(), (ItemLike)SpawnItems.COOKED_TUNA_CHUNK.get(), (ItemLike)SpawnItems.ANGLER_FISH.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42406_, (ItemLike)SpawnItems.TUNA_SANDWICH.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42699_, (ItemLike)SpawnItems.CLAM_CHOWDER.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256968_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_279528_, (ItemLike)SpawnItems.SCHOOL_POTTERY_SHERD.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_279545_, (ItemLike)SpawnItems.SHELL_POTTERY_SHERD.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_279650_, (ItemLike)SpawnItems.CROWN_POTTERY_SHERD.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_279636_, (ItemLike)SpawnItems.SPADE_POTTERY_SHERD.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42500_, (ItemLike)SpawnItems.SHELL_FRAGMENTS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42784_, (ItemLike)SpawnItems.SNAIL_SHELL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42355_, (ItemLike)SpawnItems.MUCUS.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256731_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_220212_, (ItemLike)SpawnItems.ANGLER_FISH_SPAWN_EGG.get(), (ItemLike)SpawnItems.ANT_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42552_, (ItemLike)SpawnItems.CLAM_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42626_, (ItemLike)SpawnItems.OCTOPUS_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42638_, (ItemLike)SpawnItems.SEA_COW_SPAWN_EGG.get(), (ItemLike)SpawnItems.SEAHORSE_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42644_, (ItemLike)SpawnItems.SNAIL_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42598_, (ItemLike)SpawnItems.TUNA_SPAWN_EGG.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42566_, (ItemLike)SpawnItems.HERRING_SPAWN_EGG.get(), (ItemLike)SpawnItems.HAMSTER_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42596_, (ItemLike)SpawnItems.SUNFISH_SPAWN_EGG.get());
        }
    }
}

