/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.inventory;

import com.ninni.spawn.client.inventory.PigmentShifterSlot;
import com.ninni.spawn.mixin.accessor.TropicalFishAccessor;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnMenuTypes;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PigmentShifterMenu
extends AbstractContainerMenu {
    private final Level level;
    private final ContainerLevelAccess access;
    final Slot bodyDyeSlot;
    final Slot patternDyeSlot;
    final Slot patternSlot;
    final Slot bodyPlanSlot;
    final Slot bucketSlot;
    final Slot resultSlot;
    long lastSoundTime;
    public final Container inputContainer = new SimpleContainer(5){

        public void m_6596_() {
            PigmentShifterMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };
    private final ResultContainer outputContainer = new ResultContainer(){

        public void m_6596_() {
            PigmentShifterMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };

    public PigmentShifterMenu(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory, ContainerLevelAccess.f_39287_);
    }

    public PigmentShifterMenu(int i, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super((MenuType)SpawnMenuTypes.PIGMENT_SHIFTER.get(), i);
        int l;
        this.access = containerLevelAccess;
        this.level = inventory.f_35978_.m_9236_();
        this.bucketSlot = this.m_38897_(new Slot(this.inputContainer, 0, 14, 35){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_204117_(SpawnTags.CUSTOMIZABLE_MOB_ITEMS);
            }
        });
        this.bodyDyeSlot = this.m_38897_(new PigmentShifterSlot(this.inputContainer, 1, 57, 26){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_41720_() instanceof DyeItem;
            }
        });
        this.patternDyeSlot = this.m_38897_(new PigmentShifterSlot(this.inputContainer, 2, 57, 45){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_41720_() instanceof DyeItem;
            }
        });
        this.bodyPlanSlot = this.m_38897_(new PigmentShifterSlot(this.inputContainer, 3, 38, 26){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_204117_(SpawnTags.CHANGES_BODY_PLAN);
            }
        });
        this.patternSlot = this.m_38897_(new PigmentShifterSlot(this.inputContainer, 4, 38, 45){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_204117_(SpawnTags.CHANGES_PATTERN);
            }
        });
        this.resultSlot = this.m_38897_(new Slot((Container)this.outputContainer, 0, 145, 35){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack itemStack) {
                PigmentShifterMenu.this.bucketSlot.m_6201_(1);
                PigmentShifterMenu.this.bodyDyeSlot.m_6201_(1);
                PigmentShifterMenu.this.patternDyeSlot.m_6201_(1);
                PigmentShifterMenu.this.bodyPlanSlot.m_6201_(1);
                PigmentShifterMenu.this.patternSlot.m_6201_(1);
                containerLevelAccess.m_39292_((level, blockPos) -> {
                    long l = level.m_46467_();
                    if (PigmentShifterMenu.this.lastSoundTime != l) {
                        level.m_5594_(null, blockPos, (SoundEvent)SpawnSoundEvents.PIGMENT_SHIFTER_TRANSFORM.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        PigmentShifterMenu.this.lastSoundTime = l;
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        SpawnCriteriaTriggers.MODIFY_FISH.trigger(serverPlayer);
                    }
                });
                super.m_142406_(player, itemStack);
            }
        });
        for (l = 0; l < 3; ++l) {
            for (int m = 0; m < 9; ++m) {
                this.m_38897_(new Slot((Container)inventory, m + l * 9 + 9, 8 + m * 18, 102 + l * 18 - 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)inventory, l, 8 + l * 18, 142));
        }
    }

    public void m_6199_(Container container) {
        ItemStack bucketSlotItem = this.bucketSlot.m_7993_();
        ItemStack bodyDyeSlotItem = this.bodyDyeSlot.m_7993_();
        ItemStack patternDyeSlotItem = this.patternDyeSlot.m_7993_();
        ItemStack patternSlotItem = this.patternSlot.m_7993_();
        ItemStack bodyPlanSlotItem = this.bodyPlanSlot.m_7993_();
        CompoundTag tag = bucketSlotItem.m_41783_();
        if (tag != null) {
            if (bucketSlotItem.m_204117_(SpawnTags.CUSTOMIZABLE_MOB_ITEMS)) {
                if (!bucketSlotItem.m_41619_()) {
                    ItemStack resultCopy = bucketSlotItem.m_41777_();
                    resultCopy.m_41764_(1);
                    if (bucketSlotItem.m_150930_((Item)SpawnItems.CLAM.get()) && tag.m_128425_("ClamVariant", 3)) {
                        int variantTag = bucketSlotItem.m_41783_().m_128451_("ClamVariant");
                        ((PigmentShifterSlot)this.bodyDyeSlot).setDisabled(true);
                        DyeColor patternColor = Clam.getDyeColor(variantTag);
                        ClamVariant.Pattern pattern = Clam.getPattern(variantTag);
                        ClamVariant.BaseColor baseColor = Clam.getBaseColor(variantTag);
                        int shiftedPatternId = pattern.getId() + 1;
                        if (pattern.getId() == 4) {
                            shiftedPatternId = 0;
                        }
                        int shiftedBaseColorId = PigmentShifterMenu.getClamBaseColor(baseColor);
                        ClamVariant.Pattern newPattern = ClamVariant.Pattern.byId(shiftedPatternId);
                        ClamVariant.BaseColor newBaseColor = ClamVariant.BaseColor.byId(shiftedBaseColorId);
                        Item item = patternDyeSlotItem.m_41720_();
                        if (item instanceof DyeItem) {
                            DyeItem dyeItem = (DyeItem)item;
                            patternColor = dyeItem.m_41089_();
                        }
                        if (patternSlotItem.m_204117_(SpawnTags.CHANGES_PATTERN) && newPattern != null) {
                            pattern = newPattern;
                        }
                        if (bodyPlanSlotItem.m_204117_(SpawnTags.CHANGES_BODY_PLAN) && newBaseColor != null) {
                            baseColor = newBaseColor;
                        }
                        ClamVariant.Variant variant = new ClamVariant.Variant(baseColor, pattern, patternColor);
                        Clam clam = (Clam)((EntityType)SpawnEntityType.CLAM.get()).m_20615_(this.level);
                        clam.setPackedVariant(variant.getPackedId());
                        resultCopy.m_41784_().m_128405_("ClamVariant", clam.getPackedVariant());
                        clam.m_146870_();
                        this.outputContainer.m_6836_(4, resultCopy);
                    } else if (bucketSlotItem.m_150930_(Items.f_151057_) && tag.m_128425_("Variant", 3)) {
                        int variantId = bucketSlotItem.m_41783_().m_128451_("Variant");
                        if (variantId != 4) {
                            ((PigmentShifterSlot)this.bodyDyeSlot).setDisabled(true);
                            ((PigmentShifterSlot)this.patternSlot).setDisabled(true);
                            ((PigmentShifterSlot)this.patternDyeSlot).setDisabled(true);
                            int shiftedId = variantId + 1;
                            if (variantId == 3) {
                                shiftedId = 0;
                            }
                            if (bodyPlanSlotItem.m_204117_(SpawnTags.CHANGES_BODY_PLAN)) {
                                resultCopy.m_41784_().m_128405_("Variant", shiftedId);
                            }
                            this.outputContainer.m_6836_(4, resultCopy);
                        }
                    } else {
                        DyeItem dyeItem;
                        Item newBaseColor;
                        this.setAllSlotsDisabled(false);
                        if (bucketSlotItem.m_150930_((Item)SpawnItems.SEAHORSE_BUCKET.get())) {
                            ResourceLocation currentVariant;
                            ResourceLocation newVariant = currentVariant = ResourceLocation.m_135820_((String)tag.m_128461_("Variant"));
                            boolean shiftPattern = patternSlotItem.m_204117_(SpawnTags.CHANGES_PATTERN);
                            boolean shiftBodyPlan = bodyPlanSlotItem.m_204117_(SpawnTags.CHANGES_BODY_PLAN);
                            if (shiftPattern || shiftBodyPlan) {
                                newVariant = this.getShiftedVariant(currentVariant, shiftBodyPlan, shiftPattern);
                            }
                            DyeColor baseColor = tag.m_128441_("BaseColor") ? DyeColor.m_41053_((int)tag.m_128451_("BaseColor")) : (DyeColor)Util.m_214670_((Object[])DyeColor.values(), (RandomSource)this.level.f_46441_);
                            DyeColor patternColor = tag.m_128441_("PatternColor") ? DyeColor.m_41053_((int)tag.m_128451_("PatternColor")) : (DyeColor)Util.m_214670_((Object[])DyeColor.values(), (RandomSource)this.level.f_46441_);
                            newBaseColor = bodyDyeSlotItem.m_41720_();
                            if (newBaseColor instanceof DyeItem) {
                                dyeItem = (DyeItem)newBaseColor;
                                baseColor = dyeItem.m_41089_();
                            }
                            if ((newBaseColor = patternDyeSlotItem.m_41720_()) instanceof DyeItem) {
                                dyeItem = (DyeItem)newBaseColor;
                                patternColor = dyeItem.m_41089_();
                            }
                            resultCopy.m_41784_().m_128359_("Variant", newVariant.toString());
                            resultCopy.m_41784_().m_128405_("BaseColor", baseColor.m_41060_());
                            resultCopy.m_41784_().m_128405_("PatternColor", patternColor.m_41060_());
                            this.outputContainer.m_6836_(4, resultCopy);
                        }
                        if (bucketSlotItem.m_150930_(Items.f_42459_) && tag.m_128425_("BucketVariantTag", 3)) {
                            int bucketTag = bucketSlotItem.m_41783_().m_128451_("BucketVariantTag");
                            DyeColor bodyColor = TropicalFish.m_30050_((int)bucketTag);
                            DyeColor patternColor = TropicalFish.m_30052_((int)bucketTag);
                            TropicalFish.Pattern pattern = TropicalFish.m_262390_((int)bucketTag);
                            int shiftedId = this.getTropicalFishPattern(pattern);
                            TropicalFish.Pattern newPattern = TropicalFish.Pattern.m_262381_((int)shiftedId);
                            newBaseColor = bodyDyeSlotItem.m_41720_();
                            if (newBaseColor instanceof DyeItem) {
                                dyeItem = (DyeItem)newBaseColor;
                                bodyColor = dyeItem.m_41089_();
                            }
                            if ((newBaseColor = patternDyeSlotItem.m_41720_()) instanceof DyeItem) {
                                dyeItem = (DyeItem)newBaseColor;
                                patternColor = dyeItem.m_41089_();
                            }
                            if ((patternSlotItem.m_204117_(SpawnTags.CHANGES_PATTERN) || bodyPlanSlotItem.m_204117_(SpawnTags.CHANGES_BODY_PLAN)) && newPattern != null) {
                                pattern = newPattern;
                            }
                            TropicalFish.Variant variant = new TropicalFish.Variant(pattern, bodyColor, patternColor);
                            TropicalFish tropicalFish = (TropicalFish)EntityType.f_20489_.m_20615_(this.level);
                            ((TropicalFishAccessor)tropicalFish).callSetPackedVariant(variant.m_262472_());
                            resultCopy.m_41784_().m_128405_("BucketVariantTag", ((TropicalFishAccessor)tropicalFish).callGetPackedVariant());
                            tropicalFish.m_146870_();
                        }
                        this.outputContainer.m_6836_(4, resultCopy);
                    }
                } else {
                    this.setAllSlotsDisabled(false);
                    this.outputContainer.m_8016_(4);
                }
            } else {
                this.setAllSlotsDisabled(false);
                this.outputContainer.m_8016_(4);
            }
        } else {
            this.setAllSlotsDisabled(false);
            this.outputContainer.m_8016_(4);
        }
    }

    private void setAllSlotsDisabled(boolean disabled) {
        ((PigmentShifterSlot)this.patternDyeSlot).setDisabled(disabled);
        ((PigmentShifterSlot)this.bodyDyeSlot).setDisabled(disabled);
        ((PigmentShifterSlot)this.bodyPlanSlot).setDisabled(disabled);
        ((PigmentShifterSlot)this.patternSlot).setDisabled(disabled);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.outputContainer.m_8016_(4);
        this.access.m_39292_((world, pos) -> this.m_150411_(player, this.inputContainer));
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (i == this.resultSlot.f_40219_) {
                if (!this.m_38903_(itemStack2, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (i == this.bodyDyeSlot.f_40219_ || i == this.patternDyeSlot.f_40219_ || i == this.bucketSlot.f_40219_ || i == this.bodyPlanSlot.f_40219_ || i == this.patternSlot.f_40219_ ? !this.m_38903_(itemStack2, 4, 40, false) : (itemStack2.m_41720_() instanceof DyeItem && (((PigmentShifterSlot)this.bodyDyeSlot).isDisabled() || !this.m_38903_(itemStack2, this.bodyDyeSlot.f_40219_, this.bodyDyeSlot.f_40219_ + 1, false)) ? ((PigmentShifterSlot)this.patternDyeSlot).isDisabled() || !this.m_38903_(itemStack2, this.patternDyeSlot.f_40219_, this.patternDyeSlot.f_40219_ + 1, false) : (itemStack2.m_204117_(SpawnTags.CHANGES_BODY_PLAN) ? ((PigmentShifterSlot)this.bodyPlanSlot).isDisabled() || !this.m_38903_(itemStack2, this.bodyPlanSlot.f_40219_, this.bodyPlanSlot.f_40219_ + 1, false) : (itemStack2.m_204117_(SpawnTags.CHANGES_PATTERN) ? ((PigmentShifterSlot)this.patternSlot).isDisabled() || !this.m_38903_(itemStack2, this.patternSlot.f_40219_, this.patternSlot.f_40219_ + 1, false) : (itemStack2.m_204117_(SpawnTags.CUSTOMIZABLE_MOB_ITEMS) ? !this.m_38903_(itemStack2, this.bucketSlot.f_40219_, this.bucketSlot.f_40219_ + 1, false) : (i >= 4 && i < 31 ? !this.m_38903_(itemStack2, 31, 40, false) : i >= 31 && i < 40 && !this.m_38903_(itemStack2, 4, 31, false))))))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return PigmentShifterMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)SpawnBlocks.PIGMENT_SHIFTER.get()));
    }

    private static int getClamBaseColor(ClamVariant.BaseColor baseColor) {
        int shiftedBaseColorId = baseColor.getId() + 1;
        int limit = 3;
        int start = 0;
        if (baseColor.base().getId() == 1) {
            start = 4;
            limit = 7;
        }
        if (baseColor.base().getId() == 2) {
            start = 8;
            limit = 11;
        }
        if (baseColor.getId() == limit) {
            shiftedBaseColorId = start;
        }
        return shiftedBaseColorId;
    }

    private ResourceLocation getShiftedVariant(ResourceLocation currentId, boolean shiftBodyPlan, boolean shiftPattern) {
        int index;
        String[] split = currentId.m_135815_().split("/");
        if (split.length != 2) {
            return currentId;
        }
        String currentBody = split[0];
        String currentPattern = split[1];
        List<ResourceLocation> seahorseVariants = AnimalVariantManager.DATA.stream().filter(data -> data.type().equals(SpawnEntityType.SEAHORSE.get())).map(AnimalVariantManager.AnimalVariantData::id).toList();
        List<String> allBodies = seahorseVariants.stream().map(id -> id.m_135815_().split("/")[0]).distinct().sorted().toList();
        List<String> allPatterns = seahorseVariants.stream().filter(id -> id.m_135815_().startsWith(currentBody + "/")).map(id -> id.m_135815_().split("/")[1]).distinct().sorted().toList();
        String newBody = shiftBodyPlan ? ((index = allBodies.indexOf(currentBody)) != -1 ? allBodies.get((index + 1) % allBodies.size()) : currentBody) : currentBody;
        String newPattern = shiftPattern ? ((index = allPatterns.indexOf(currentPattern)) != -1 ? allPatterns.get((index + 1) % allPatterns.size()) : currentPattern) : currentPattern;
        ResourceLocation newId = new ResourceLocation(currentId.m_135827_(), "seahorse/" + newBody + "/" + newPattern);
        if (seahorseVariants.contains(newId)) {
            return newId;
        }
        return seahorseVariants.stream().filter(id -> {
            String[] parts = id.m_135815_().split("/");
            return parts.length == 2 && parts[0].equals(newBody) && parts[1].equals(newPattern);
        }).findFirst().or(() -> seahorseVariants.stream().filter(id -> id.m_135815_().startsWith(newBody + "/")).findFirst()).or(() -> seahorseVariants.stream().filter(id -> id.m_135815_().endsWith("/" + newPattern)).findFirst()).orElse(currentId);
    }

    private int getTropicalFishPattern(TropicalFish.Pattern pattern) {
        TropicalFish.Base bodyPlan = pattern.m_262371_();
        int i = this.patternSlot.m_7993_().m_204117_(SpawnTags.CHANGES_PATTERN) ? 1 : 0;
        int newId = (pattern.m_262435_() >> 8) + i;
        int shiftedId = newId << 8;
        if (this.bodyPlanSlot.m_7993_().m_204117_(SpawnTags.CHANGES_BODY_PLAN)) {
            if (bodyPlan == TropicalFish.Base.LARGE) {
                if (pattern.m_262435_() >> 8 == 5 && i == 1) {
                    shiftedId = 0;
                }
            } else {
                shiftedId = pattern.m_262435_() >> 8 == 5 && i == 1 ? 1 : ++shiftedId;
            }
        } else if (bodyPlan == TropicalFish.Base.LARGE) {
            shiftedId = pattern.m_262435_() >> 8 == 5 && i == 1 ? 1 : ++shiftedId;
        }
        return shiftedId;
    }
}

