/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ninni.spawn.client.inventory.PigmentShifterMenu;
import com.ninni.spawn.client.inventory.PigmentShifterSlot;
import com.ninni.spawn.mixin.accessor.TropicalFishAccessor;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.Seahorse;
import com.ninni.spawn.server.entity.common.CustomInventoryPose;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class PigmentShifterScreen
extends AbstractContainerScreen<PigmentShifterMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("spawn", "textures/gui/container/fish.png");
    private static final Component BODY_PLAN_TOOLTIP = Component.m_237115_((String)"container.spawn.pigment_shifter.body_plan");
    private static final Component BODY_PLAN_TOOLTIP_PRESET_COLOR = Component.m_237115_((String)"container.spawn.pigment_shifter.body_plan.color");
    private static final Component PATTERN_TOOLTIP = Component.m_237115_((String)"container.spawn.pigment_shifter.pattern");
    private static final Component BODY_DYE_TOOLTIP = Component.m_237115_((String)"container.spawn.pigment_shifter.body_dye");
    private static final Component PATTERN_DYE_TOOLTIP = Component.m_237115_((String)"container.spawn.pigment_shifter.pattern_dye");
    private final PigmentShifterMenu menu;
    private final Level level;
    private double rotationY = 0.0;
    private double rotateY = 0.0;
    private boolean stoppedRotating;
    private float scaleModifier = 1.0f;
    private static final int BASE_BOX_X = 81;
    private static final int BASE_BOX_Y = 21;
    private static final int BASE_BOX_WIDTH = 52;
    private static final int BASE_BOX_HEIGHT = 46;
    private boolean isDraggingFromBox = false;
    private float entityOffsetX = 0.0f;
    private float entityOffsetY = 0.0f;

    public PigmentShifterScreen(PigmentShifterMenu customizerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)customizerMenu, inventory, component);
        this.menu = customizerMenu;
        this.level = inventory.f_35978_.m_9236_();
    }

    public void m_88315_(GuiGraphics poseStack, int i, int j, float f) {
        this.m_280273_(poseStack);
        super.m_88315_(poseStack, i, j, f);
        this.m_280072_(poseStack, i, j);
        this.renderOnboardingTooltips(poseStack, i, j);
    }

    protected void m_7286_(GuiGraphics poseStack, float partialTicks, int x, int y) {
        PigmentShifterSlot pigmentShifterSlot;
        ItemStack item = this.menu.resultSlot.m_7993_();
        int imgX = (this.f_96543_ - this.f_97726_) / 2;
        int imgY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_280273_(poseStack);
        poseStack.m_280218_(RESOURCE_LOCATION, imgX, imgY, 0, 0, this.f_97726_, this.f_97727_);
        Slot bodyDyeSlot = this.menu.bodyDyeSlot;
        Slot patternDyeSlot = this.menu.patternDyeSlot;
        Slot bucketSlot = this.menu.bucketSlot;
        Slot patternSlot = this.menu.patternSlot;
        Slot bodyPlanSlot = this.menu.bodyPlanSlot;
        if (!bodyDyeSlot.m_6657_()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + bodyDyeSlot.f_40220_, imgY + bodyDyeSlot.f_40221_, this.f_97726_, 0, 16, 16);
        }
        if (!patternDyeSlot.m_6657_()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + patternDyeSlot.f_40220_, imgY + patternDyeSlot.f_40221_, this.f_97726_, 0, 16, 16);
        }
        if (!bucketSlot.m_6657_()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + bucketSlot.f_40220_, imgY + bucketSlot.f_40221_, this.f_97726_ + 16, 0, 16, 16);
        }
        if (!bodyPlanSlot.m_6657_()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + bodyPlanSlot.f_40220_, imgY + bodyPlanSlot.f_40221_, this.f_97726_ + 32, 0, 16, 16);
        }
        if (!patternSlot.m_6657_()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + patternSlot.f_40220_, imgY + patternSlot.f_40221_, this.f_97726_ + 48, 0, 16, 16);
        }
        if (bodyDyeSlot instanceof PigmentShifterSlot && (pigmentShifterSlot = (PigmentShifterSlot)bodyDyeSlot).isDisabled()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + bodyDyeSlot.f_40220_, imgY + bodyDyeSlot.f_40221_, this.f_97726_ + 64, 0, 16, 16);
        }
        if (patternDyeSlot instanceof PigmentShifterSlot && (pigmentShifterSlot = (PigmentShifterSlot)patternDyeSlot).isDisabled()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + patternDyeSlot.f_40220_, imgY + patternDyeSlot.f_40221_, this.f_97726_ + 64, 0, 16, 16);
        }
        if (patternSlot instanceof PigmentShifterSlot && (pigmentShifterSlot = (PigmentShifterSlot)patternSlot).isDisabled()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + patternSlot.f_40220_, imgY + patternSlot.f_40221_, this.f_97726_ + 64, 0, 16, 16);
        }
        if (bodyPlanSlot instanceof PigmentShifterSlot && (pigmentShifterSlot = (PigmentShifterSlot)bodyPlanSlot).isDisabled()) {
            poseStack.m_280218_(RESOURCE_LOCATION, imgX + bodyPlanSlot.f_40220_, imgY + bodyPlanSlot.f_40221_, this.f_97726_ + 64, 0, 16, 16);
        }
        int boxX = imgX + 81;
        int boxY = imgY + 21;
        int boxW = 52;
        int boxH = 46;
        if (this.menu.resultSlot.m_6657_() && item.m_204117_(SpawnTags.CUSTOMIZABLE_MOB_ITEMS)) {
            ClamVariant.Variant variant;
            int tag;
            CompoundTag compoundTag = item.m_41783_();
            if (compoundTag != null && compoundTag.m_128425_("ClamVariant", 3) && item.m_150930_((Item)SpawnItems.CLAM.get())) {
                tag = compoundTag.m_128451_("ClamVariant");
                Clam clam = (Clam)((EntityType)SpawnEntityType.CLAM.get()).m_20615_(this.level);
                variant = new ClamVariant.Variant(Clam.getBaseColor(tag), Clam.getPattern(tag), Clam.getDyeColor(tag));
                clam.setPackedVariant(variant.getPackedId());
                int id = clam.getBaseColor().base().getId();
                int scale = 50;
                if (id == 1) {
                    scale = 40;
                }
                if (id == 2) {
                    scale = 25;
                }
                int h = id == 0 ? 54 : (id == 1 ? 50 : 60);
                clam.setIsRenderedInTooltip(true);
                this.enableScissorBox(boxX, boxY, boxW, boxH);
                this.renderMovableEntity(poseStack, imgX + 107, imgY + h, (int)((float)scale * this.scaleModifier), (LivingEntity)clam, 0);
                RenderSystem.disableScissor();
                clam.m_146870_();
            }
            if (compoundTag != null && compoundTag.m_128425_("Variant", 3) && item.m_150930_(Items.f_151057_) && compoundTag.m_128451_("Variant") != 4) {
                int variant2 = compoundTag.m_128451_("Variant");
                Axolotl axolotl = (Axolotl)EntityType.f_147039_.m_20615_(this.level);
                if (axolotl instanceof CustomInventoryPose) {
                    CustomInventoryPose pose = (CustomInventoryPose)axolotl;
                    pose.setIsRenderedInTooltip(true);
                }
                axolotl.m_28464_(Axolotl.Variant.m_262843_((int)variant2));
                this.enableScissorBox(boxX, boxY, boxW, boxH);
                this.renderMovableEntity(poseStack, imgX + 107, imgY + 60, (int)(30.0f * this.scaleModifier), (LivingEntity)axolotl, 0);
                RenderSystem.disableScissor();
                axolotl.m_146870_();
            }
            if (compoundTag != null) {
                if (item.m_150930_(Items.f_42459_) && compoundTag.m_128425_("BucketVariantTag", 3)) {
                    tag = compoundTag.m_128451_("BucketVariantTag");
                    TropicalFish tropicalFish = (TropicalFish)EntityType.f_20489_.m_20615_(this.level);
                    variant = new TropicalFish.Variant(TropicalFish.m_262390_((int)tag), TropicalFish.m_30050_((int)tag), TropicalFish.m_30052_((int)tag));
                    ((TropicalFishAccessor)tropicalFish).callSetPackedVariant(variant.m_262472_());
                    this.enableScissorBox(boxX, boxY, boxW, boxH);
                    this.renderMovableEntity(poseStack, imgX + 107, imgY + 50, (int)(40.0f * this.scaleModifier), (LivingEntity)tropicalFish, 1);
                    RenderSystem.disableScissor();
                    tropicalFish.m_146870_();
                }
                if (item.m_150930_((Item)SpawnItems.SEAHORSE_BUCKET.get())) {
                    Seahorse seahorse = (Seahorse)((EntityType)SpawnEntityType.SEAHORSE.get()).m_20615_(this.level);
                    if (compoundTag.m_128441_("Variant")) {
                        seahorse.setVariant(ResourceLocation.m_135820_((String)compoundTag.m_128461_("Variant")));
                    }
                    if (compoundTag.m_128441_("BaseColor")) {
                        seahorse.setBaseColor(DyeColor.m_41053_((int)compoundTag.m_128451_("BaseColor")));
                    }
                    if (compoundTag.m_128441_("PatternColor")) {
                        seahorse.setPatternColor(DyeColor.m_41053_((int)compoundTag.m_128451_("PatternColor")));
                    }
                    this.enableScissorBox(boxX, boxY, boxW, boxH);
                    this.renderMovableEntity(poseStack, imgX + 107, imgY + 58, (int)(45.0f * this.scaleModifier), (LivingEntity)seahorse, 0);
                    RenderSystem.disableScissor();
                    seahorse.m_146870_();
                }
            }
        }
    }

    private void renderOnboardingTooltips(GuiGraphics guiGraphics, int i, int j) {
        Optional<Component> optional = Optional.empty();
        if (this.f_97734_ != null) {
            if (this.menu.m_38853_(this.menu.patternSlot.f_40219_).m_7993_().m_41619_() && !((PigmentShifterSlot)this.menu.patternSlot).isDisabled() && this.f_97734_.f_40219_ == this.menu.patternSlot.f_40219_) {
                optional = Optional.of(PATTERN_TOOLTIP);
            }
            if (this.menu.m_38853_(this.menu.bodyPlanSlot.f_40219_).m_7993_().m_41619_() && !((PigmentShifterSlot)this.menu.bodyPlanSlot).isDisabled() && this.f_97734_.f_40219_ == this.menu.bodyPlanSlot.f_40219_) {
                optional = this.menu.bucketSlot.m_7993_().m_150930_((Item)SpawnItems.CLAM.get()) || this.menu.bucketSlot.m_7993_().m_150930_(Items.f_151057_) ? Optional.of(BODY_PLAN_TOOLTIP_PRESET_COLOR) : Optional.of(BODY_PLAN_TOOLTIP);
            }
            if (this.menu.m_38853_(this.menu.bodyDyeSlot.f_40219_).m_7993_().m_41619_() && !((PigmentShifterSlot)this.menu.bodyDyeSlot).isDisabled() && this.f_97734_.f_40219_ == this.menu.bodyDyeSlot.f_40219_) {
                optional = Optional.of(BODY_DYE_TOOLTIP);
            }
            if (this.menu.m_38853_(this.menu.patternDyeSlot.f_40219_).m_7993_().m_41619_() && !((PigmentShifterSlot)this.menu.patternDyeSlot).isDisabled() && this.f_97734_.f_40219_ == this.menu.patternDyeSlot.f_40219_) {
                optional = Optional.of(PATTERN_DYE_TOOLTIP);
            }
        }
        optional.ifPresent(component -> guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)component, 115), i, j));
    }

    public void renderMovableEntity(GuiGraphics poseStack, int x, int y, int scale, LivingEntity entity, int rotate) {
        this.rotationY += this.rotateY;
        x += (int)this.entityOffsetX;
        y += (int)this.entityOffsetY;
        Quaternionf quaternionf = new Quaternionf().rotateX((float)Math.toRadians(180.0));
        Quaternionf quaternionf1 = new Quaternionf().rotateY((float)this.rotationY);
        if (rotate == 1) {
            quaternionf.mul((Quaternionfc)new Quaternionf().rotateZ((float)Math.toRadians(90.0)));
            quaternionf.mul((Quaternionfc)new Quaternionf().rotateX((float)this.rotationY));
        } else if (rotate == 2) {
            quaternionf.mul((Quaternionfc)new Quaternionf().rotateX((float)Math.toRadians(90.0)));
            quaternionf.mul((Quaternionfc)new Quaternionf().rotateZ((float)(-this.rotationY)));
        } else if (rotate == 3) {
            quaternionf.mul((Quaternionfc)new Quaternionf().rotateX((float)Math.toRadians(-90.0)));
            quaternionf.mul((Quaternionfc)new Quaternionf().rotateZ((float)this.rotationY));
        } else {
            quaternionf.mul((Quaternionfc)quaternionf1);
        }
        InventoryScreen.m_280432_((GuiGraphics)poseStack, (int)x, (int)y, (int)scale, (Quaternionf)quaternionf, (Quaternionf)quaternionf1, (LivingEntity)entity);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int imgX = (this.f_96543_ - this.f_97726_) / 2;
        int imgY = (this.f_96544_ - this.f_97727_) / 2;
        int boxX = imgX + 81;
        int boxY = imgY + 21;
        if (mouseX >= (double)boxX && mouseX <= (double)(boxX + 52) && mouseY >= (double)boxY && mouseY <= (double)(boxY + 46)) {
            this.isDraggingFromBox = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingFromBox) {
            if (button == 0) {
                this.rotationY += dragX / 40.0;
                this.stoppedRotating = true;
            } else if (button == 1) {
                float x = 10.0f * this.scaleModifier;
                float y = 7.0f * this.scaleModifier;
                this.entityOffsetX = (float)Math.max((double)(-x), Math.min((double)x, (double)this.entityOffsetX + dragX));
                this.entityOffsetY = (float)Math.max((double)(-y), Math.min((double)y, (double)this.entityOffsetY + dragY));
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.rotateY = this.stoppedRotating ? 0.0 : 0.005;
        this.isDraggingFromBox = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scaleModifier = Math.max(0.5f, Math.min(4.0f, this.scaleModifier + (float)delta * 0.1f));
        return true;
    }

    private void enableScissorBox(int x, int y, int width, int height) {
        int scale = (int)this.f_96541_.m_91268_().m_85449_();
        RenderSystem.enableScissor((int)(x * scale), (int)(this.f_96541_.m_91268_().m_85442_() - (y + height) * scale), (int)(width * scale), (int)(height * scale));
    }
}

