/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.BarracudaAnimations;
import com.ninni.spawn.server.entity.Barracuda;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BarracudaModel
extends HierarchicalModel<Barracuda> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart torso;
    private final ModelPart tail;
    private final ModelPart tailTip;
    private final ModelPart tailFin;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private float bodyYSmooth;
    private float tailYSmooth;
    private float bodyXSmooth;
    private float tailXSmooth;

    public BarracudaModel(ModelPart root) {
        this.root = root;
        this.all = this.root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.torso = this.body.m_171324_("torso");
        this.tail = this.torso.m_171324_("tail");
        this.tailTip = this.tail.m_171324_("tailTip");
        this.tailFin = this.tailTip.m_171324_("tailFin");
        this.leftFin = this.torso.m_171324_("leftFin");
        this.rightFin = this.torso.m_171324_("rightFin");
    }

    public void setupAnim(Barracuda entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        float deg = (float)Math.PI / 180;
        this.all.f_104203_ = headPitch * deg;
        this.all.f_104204_ = headYaw * deg;
        if (entity.isRenderedInTooltip()) {
            this.m_288214_(BarracudaAnimations.TOOLTIP);
            return;
        }
        if (!entity.m_20072_()) {
            this.all.f_104205_ = 1.5707964f;
        }
        this.m_267799_(BarracudaAnimations.SWIM, limbSwing, limbSwingAmount, 1.0f, 8.0f);
        float pt = Minecraft.m_91087_().m_91296_();
        float bodyY = Mth.m_14179_((float)pt, (float)entity.getBodyPart().f_19859_, (float)entity.getBodyPart().m_146908_());
        float tailY = Mth.m_14179_((float)pt, (float)entity.getTailPart().f_19859_, (float)entity.getTailPart().m_146908_());
        float baseY = Mth.m_14179_((float)pt, (float)entity.f_19859_, (float)entity.m_146908_());
        float bodyYTarget = Mth.m_14177_((float)(bodyY - baseY));
        float tailYTarget = Mth.m_14177_((float)(tailY - bodyY));
        this.bodyYSmooth += (bodyYTarget - this.bodyYSmooth) * 0.25f;
        this.tailYSmooth += (tailYTarget - this.tailYSmooth) * 0.3f;
        this.torso.f_104204_ += this.bodyYSmooth * deg;
        this.tail.f_104204_ += this.tailYSmooth * 1.5f * deg;
        this.tailTip.f_104204_ += this.tailYSmooth * deg;
        this.tailFin.f_104204_ += this.tailYSmooth * 2.0f * deg;
        float bodyX = Mth.m_14179_((float)pt, (float)entity.getBodyPart().f_19860_, (float)entity.getBodyPart().m_146909_());
        float tailX = Mth.m_14179_((float)pt, (float)entity.getTailPart().f_19860_, (float)entity.getTailPart().m_146909_());
        float baseX = Mth.m_14179_((float)pt, (float)entity.f_19860_, (float)entity.m_146909_());
        float bodyXTarget = Mth.m_14177_((float)(bodyX - baseX));
        float tailXTarget = Mth.m_14177_((float)(tailX - bodyX));
        this.bodyXSmooth += (bodyXTarget - this.bodyXSmooth) * 0.25f;
        this.tailXSmooth += (tailXTarget - this.tailXSmooth) * 0.3f;
        this.torso.f_104203_ += this.bodyXSmooth * deg;
        this.tail.f_104203_ += this.tailXSmooth * 1.5f * deg;
        this.tailTip.f_104203_ += this.tailXSmooth * deg;
        this.tailFin.f_104203_ += this.tailXSmooth * 2.0f * deg;
        this.head.f_104204_ += Mth.m_14089_((float)(ageInTicks * 0.4f + 3.0f)) * 0.2f * 0.25f;
        this.body.f_104201_ += Mth.m_14089_((float)(ageInTicks * 0.2f)) * 1.5f * 0.125f;
        this.body.f_104204_ += Mth.m_14089_((float)(ageInTicks * 0.4f + 2.0f)) * 0.2f * 0.25f;
        this.body.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.2f + 2.0f)) * 0.05f * 0.25f;
        this.tail.f_104204_ += Mth.m_14089_((float)(ageInTicks * 0.4f + 1.0f)) * 0.4f * 0.25f;
        this.tailFin.f_104204_ += Mth.m_14089_((float)(ageInTicks * 0.4f)) * 0.8f * 0.25f;
        this.rightFin.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.4f + 1.0f)) * 0.4f * 0.25f;
        this.leftFin.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.4f + 1.0f + (float)Math.PI)) * 0.4f * 0.25f;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)22.0f, (float)4.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(19, 6).m_171488_(-1.5f, -2.5f, -2.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 16).m_171488_(-1.5f, -2.5f, -12.0f, 3.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(38, 16).m_171488_(-1.5f, -0.5f, -12.0f, 3.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-0.5f, (float)-13.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, -2.0f, -12.0f, 4.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171488_(-2.0f, 1.0f, -12.0f, 4.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)-2.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.5f, -2.5f, 0.0f, 3.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, -1).m_171488_(0.0f, -4.5f, 4.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-0.5f, (float)-13.0f));
        PartDefinition tail = torso.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -2.5f, 0.0f, 3.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(19, -7).m_171488_(0.0f, -5.5f, 3.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 1).m_171488_(0.0f, 2.5f, 3.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)13.0f));
        PartDefinition tailTip = tail.m_171599_("tailTip", CubeListBuilder.m_171558_().m_171514_(19, 18).m_171488_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)13.0f));
        PartDefinition tailFin = tailTip.m_171599_("tailFin", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(0.0f, -4.5f, -1.0f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition leftFin = torso.m_171599_("leftFin", CubeListBuilder.m_171558_().m_171514_(0, -4).m_171488_(0.0f, 0.0f, -1.5f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)2.5f, (float)3.5f));
        PartDefinition rightFin = torso.m_171599_("rightFin", CubeListBuilder.m_171558_().m_171514_(0, -4).m_171480_().m_171488_(0.0f, 0.0f, -1.5f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)2.5f, (float)3.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

