/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.ClamAnimations;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClamModel
extends HierarchicalModel<Clam> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart clam;
    private final ModelPart bottom;
    private final ModelPart top;

    public ClamModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.root = root;
        this.all = root.m_171324_("all");
        this.clam = this.all.m_171324_("clam");
        this.bottom = this.clam.m_171324_("bottom");
        this.top = this.clam.m_171324_("top");
    }

    public void setupAnim(Clam entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        if (entity.isRenderedInTooltip()) {
            if (entity.getBaseColor().base() == ClamVariant.Base.GIANT_CLAM) {
                this.clam.f_233553_ = 1.25f;
                this.clam.f_233554_ = 1.25f;
                this.clam.f_233555_ = 1.25f;
            }
            if (entity.getBaseColor().base() == ClamVariant.Base.SCALLOP) {
                this.clam.m_171327_(1.5707964f, 0.0f, 0.0f);
                this.clam.f_233553_ = 1.0f;
                this.clam.f_233554_ = 1.0f;
                this.clam.f_233555_ = 1.0f;
            }
            if (entity.getBaseColor().base() == ClamVariant.Base.WEDGE_SHELL) {
                this.clam.m_171327_(1.5707964f, 0.0f, 0.0f);
                this.clam.f_233553_ = 0.75f;
                this.clam.f_233554_ = 0.75f;
                this.clam.f_233555_ = 0.75f;
            }
        }
        if (entity.getBaseColor().base() == ClamVariant.Base.GIANT_CLAM) {
            this.m_233385_(entity.anchoringAnimationState, ClamAnimations.ANCHOR, ageInTicks, 1.0f);
            this.m_233385_(entity.openAnimationState, ClamAnimations.OPEN, ageInTicks, 1.0f);
            if (entity.isAnchored() && !entity.anchoringAnimationState.m_216984_()) {
                this.m_288214_(ClamAnimations.ANCHORED);
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createWedgeShellLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition clam = all.m_171599_("clam", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.5f));
        PartDefinition bottom = clam.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -0.5f, -4.0f, 7.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-1.5f, -0.5f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition top = clam.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public static LayerDefinition createScallopLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition clam = all.m_171599_("clam", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition bottom = clam.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -1.0f, -9.0f, 9.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 9).m_171488_(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.5f));
        PartDefinition top = clam.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public static LayerDefinition createGiantClamLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition clam = all.m_171599_("clam", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)0.0f));
        PartDefinition bottom = clam.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-10.0f, 0.0f, -15.0f, 20.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(0, 65).m_171488_(-10.0f, -2.0f, -15.0f, 20.0f, 7.0f, 15.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)7.5f));
        PartDefinition top = clam.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-10.0f, -7.0f, -15.0f, 20.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(-10.0f, -4.0f, -15.0f, 20.0f, 7.0f, 15.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)7.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)97);
    }
}

