/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.SnailAnimations;
import com.ninni.spawn.server.entity.Snail;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel
extends AgeableHierarchicalModel<Snail> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart leftWhisker;
    private final ModelPart rightWhisker;
    private final ModelPart leftEyeStalk;
    private final ModelPart leftEye;
    private final ModelPart rightEyeStalk;
    private final ModelPart rightEye;
    private final ModelPart shell;

    public SnailModel(ModelPart root) {
        super(0.5f, 24.0f);
        this.root = root;
        this.all = this.root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.leftWhisker = this.body.m_171324_("leftWhisker");
        this.rightWhisker = this.body.m_171324_("rightWhisker");
        this.leftEyeStalk = this.body.m_171324_("leftEyeStalk");
        this.leftEye = this.leftEyeStalk.m_171324_("leftEye");
        this.rightEyeStalk = this.body.m_171324_("rightEyeStalk");
        this.rightEye = this.rightEyeStalk.m_171324_("rightEye");
        this.shell = this.all.m_171324_("shell");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(Snail entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float pi = (float)Math.PI;
        this.shell.f_104207_ = entity.getShellGrowthTicks() == 0;
        this.leftEyeStalk.f_104203_ = headPitch * pi / 180.0f;
        this.leftEyeStalk.f_104204_ = headYaw * pi / 180.0f;
        this.rightEyeStalk.f_104203_ = headPitch * pi / 180.0f;
        this.rightEyeStalk.f_104204_ = headYaw * pi / 180.0f;
        this.leftEye.f_104205_ = Mth.m_14031_((float)(ageInTicks * 0.05f)) * 0.1f;
        this.leftEye.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.025f)) * 0.2f;
        this.leftEye.f_104201_ = Mth.m_14089_((float)(ageInTicks * 0.025f + pi / 2.0f)) * 0.5f - 3.0f;
        this.rightEye.f_104205_ = Mth.m_14031_((float)(ageInTicks * 0.05f + pi)) * 0.1f;
        this.rightEye.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.025f + pi)) * 0.2f;
        this.rightEye.f_104201_ = Mth.m_14089_((float)(ageInTicks * 0.025f - pi / 2.0f)) * 0.5f - 3.0f;
        this.m_233381_(entity.hideAnimationState, SnailAnimations.HIDE, ageInTicks);
        this.m_233381_(entity.shakeAnimationState, SnailAnimations.SHAKE, ageInTicks);
        this.m_233381_(entity.stopHidingAnimationState, SnailAnimations.STOP_HIDING, ageInTicks);
        this.m_233381_(entity.pinchedLeftAnimationState, SnailAnimations.PINCHED_LEFT, ageInTicks);
        this.m_233381_(entity.pinchedRightAnimationState, SnailAnimations.PINCHED_RIGHT, ageInTicks);
        if (this.f_102610_) {
            this.m_288214_(SnailAnimations.BABY_PROPORTIONS);
        }
        if (entity.m_20089_() == Pose.CROUCHING && !entity.hideAnimationState.m_216984_() && !entity.stopHidingAnimationState.m_216984_()) {
            this.m_288214_(SnailAnimations.HIDING);
        }
        if (!entity.isScared()) {
            if (this.f_102610_) {
                this.m_267799_(SnailAnimations.SLITHER, limbSwing, limbSwingAmount, 4.0f, 8.0f);
            } else {
                this.m_267799_(SnailAnimations.SLITHER, limbSwing, limbSwingAmount, 8.0f, 8.0f);
            }
        }
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -12.0f, 7.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)6.0f));
        PartDefinition leftWhisker = body.m_171599_("leftWhisker", CubeListBuilder.m_171558_().m_171514_(10, 17).m_171488_(0.0f, -2.5f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-4.5f, (float)-12.0f));
        PartDefinition rightWhisker = body.m_171599_("rightWhisker", CubeListBuilder.m_171558_().m_171514_(10, 17).m_171480_().m_171488_(-4.0f, -2.5f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-4.5f, (float)-12.0f));
        PartDefinition leftEyeStalk = body.m_171599_("leftEyeStalk", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171488_(-0.5f, -4.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-5.0f, (float)-10.5f));
        PartDefinition leftEye = leftEyeStalk.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-0.5f, -3.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition rightEyeStalk = body.m_171599_("rightEyeStalk", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171480_().m_171488_(-0.5f, -4.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-5.0f, (float)-10.5f));
        PartDefinition rightEye = rightEyeStalk.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171488_(-2.5f, -3.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition shell = all.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-5.0f, -5.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 52).m_171488_(-4.0f, 0.0f, -7.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

