/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.ninni.spawn.client.model.animation.SunfishAnimation;
import com.ninni.spawn.server.entity.Sunfish;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SunfishModel
extends HierarchicalModel<Sunfish> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart topFin;
    private final ModelPart bottomFin;
    private final ModelPart tailFin;
    private final ModelPart leftFin;
    private final ModelPart rightFin;

    public SunfishModel(ModelPart root) {
        this.root = root;
        this.all = root.m_171324_("all");
        this.topFin = this.all.m_171324_("topFin");
        this.bottomFin = this.all.m_171324_("bottomFin");
        this.tailFin = this.all.m_171324_("tailFin");
        this.leftFin = this.all.m_171324_("leftFin");
        this.rightFin = this.all.m_171324_("rightFin");
    }

    public void setupAnim(Sunfish entity, float limbSwing, float limbSwingAmount, float animationProgress, float headYaw, float headPitch) {
        float pi = (float)Math.PI;
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_6162_()) {
            this.all.f_104201_ = 11.0f;
            this.all.f_104204_ = 0.0f;
            this.all.f_104205_ = 0.0f;
            this.tailFin.f_104204_ = 0.0f;
            this.leftFin.f_104204_ = 0.8f;
            this.rightFin.f_104204_ = -0.8f;
            this.topFin.f_104205_ = 0.0f;
            this.bottomFin.f_104205_ = 0.0f;
            if (entity.m_20072_()) {
                if (!entity.isBasking()) {
                    this.m_267799_(SunfishAnimation.SWIM, limbSwing, limbSwingAmount, 2.5f, 8.0f);
                }
                this.m_233385_(entity.idleAnimationState, SunfishAnimation.IDLE, animationProgress, 1.0f);
                this.all.f_104205_ += entity.baskingProgress * ((float)Math.PI / 180) * 90.0f;
                this.all.f_104201_ += entity.baskingProgress * 8.0f;
            } else {
                this.m_233385_(entity.landAnimationState, SunfishAnimation.LAND, animationProgress, 1.0f);
            }
        } else {
            if (!entity.m_20072_()) {
                this.all.f_104201_ = entity.getSunfishAge() == -2 ? 22.5f : 22.0f;
                this.all.f_104205_ = pi / 2.0f;
                this.all.f_104203_ = 0.0f;
                this.all.f_104204_ = 0.0f;
            } else {
                this.all.f_104205_ = 0.0f;
                this.all.f_104203_ = headPitch * ((float)Math.PI / 180);
                this.all.f_104204_ = headYaw * ((float)Math.PI / 180);
            }
            this.all.f_104201_ += Mth.m_14031_((float)(animationProgress * 0.2f)) * 1.5f * 0.5f;
            this.all.f_104204_ += Mth.m_14089_((float)(animationProgress * 0.2f)) * 0.4f * 0.25f;
            this.tailFin.f_104204_ = Mth.m_14089_((float)(animationProgress * 0.4f)) * 0.8f * 0.25f;
            this.leftFin.f_104204_ = Mth.m_14089_((float)(animationProgress * 0.4f)) * 0.8f * 0.25f + 0.8f;
            this.rightFin.f_104204_ = Mth.m_14089_((float)(animationProgress * 0.4f + pi)) * 0.8f * 0.25f - 0.8f;
            this.topFin.f_104205_ = Mth.m_14089_((float)(animationProgress * 0.4f)) * 1.6f * 0.25f;
            this.bottomFin.f_104205_ = Mth.m_14089_((float)(animationProgress * 0.4f + pi)) * 1.6f * 0.25f;
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -12.0f, -23.0f, 6.0f, 23.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-3.5f, -5.0f, -24.0f, 7.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)11.0f));
        PartDefinition topFin = all.m_171599_("topFin", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(-1.0f, -15.0f, -5.0f, 2.0f, 15.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)-3.25f));
        PartDefinition bottomFin = all.m_171599_("bottomFin", CubeListBuilder.m_171558_().m_171514_(38, 1).m_171488_(-1.0f, 0.0f, -5.0f, 2.0f, 15.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)-3.25f));
        PartDefinition tailFin = all.m_171599_("tailFin", CubeListBuilder.m_171558_().m_171514_(64, -6).m_171488_(0.0f, -9.0f, 0.0f, 0.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)3.0f));
        PartDefinition leftFin = all.m_171599_("leftFin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-3.0f, (float)-11.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightFin = all.m_171599_("rightFin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-3.0f, (float)-11.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)80, (int)80);
    }

    public static LayerDefinition createBabyBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -5.0f, -9.5f, 4.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)4.0f));
        PartDefinition topFin = all.m_171599_("topFin", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-0.5f, -7.0f, -1.5f, 1.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition bottomFin = all.m_171599_("bottomFin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 0.0f, -1.5f, 1.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition tailFin = all.m_171599_("tailFin", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(0.0f, -5.0f, 0.0f, 0.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.5f));
        PartDefinition leftFin = all.m_171599_("leftFin", CubeListBuilder.m_171558_().m_171514_(8, 20).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)1.0f, (float)-4.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightFin = all.m_171599_("rightFin", CubeListBuilder.m_171558_().m_171514_(8, 20).m_171480_().m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)-4.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public static LayerDefinition createNewbornBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 3.0f).m_171514_(0, 2).m_171481_(0.0f, -2.5f, -2.0f, 0.0f, 5.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)22.5f, (float)0.5f));
        all.m_171599_("leftFin", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171481_(0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f), PartPose.m_171423_((float)1.5f, (float)0.5f, (float)-0.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        all.m_171599_("rightFin", CubeListBuilder.m_171558_().m_171514_(0, -1).m_171480_().m_171481_(0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)0.5f, (float)-0.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        all.m_171599_("bottomFin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-0.5f));
        all.m_171599_("topFin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-0.5f));
        all.m_171599_("tailFin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }
}

