/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.block.ClamLauncherBlock;
import com.ninni.spawn.server.block.entity.ClamLauncherBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ClamLauncherRenderer
implements BlockEntityRenderer<ClamLauncherBlockEntity> {
    public static final Material SHELL_TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("spawn", "entity/clam/clam_launcher/clam_launcher"));
    private final ModelPart bottom;
    private final ModelPart top;

    public ClamLauncherRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(SpawnEntityModelLayers.CLAM_LAUNCHER);
        this.bottom = modelPart.m_171324_("bottom");
        this.top = modelPart.m_171324_("top");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 14.0f, new CubeDeformation(-0.01f)).m_171514_(0, 32).m_171488_(-3.0f, -2.0f, 6.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-8.0f, -2.0f, -14.0f, 16.0f, 2.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void render(ClamLauncherBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        VertexConsumer vertexConsumer = SHELL_TEXTURE.m_119194_(multiBufferSource, RenderType::m_110458_);
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        Direction d = (Direction)blockEntity.m_58900_().m_61143_((Property)ClamLauncherBlock.FACING);
        float g = ((Direction)blockEntity.m_58900_().m_61143_((Property)ClamLauncherBlock.FACING)).m_122435_();
        if (d == Direction.NORTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        } else if (d == Direction.SOUTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(g));
        }
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.PI));
        poseStack.m_85836_();
        if (((Boolean)blockEntity.m_58900_().m_61143_((Property)ClamLauncherBlock.POWERED)).booleanValue()) {
            poseStack.m_252880_(0.0f, 1.4f, 0.35f);
            poseStack.m_252781_(new Quaternionf().rotateX(-Mth.m_14179_((float)blockEntity.activeRotation, (float)blockEntity.activeRotation, (float)1.0f)));
            poseStack.m_252880_(0.0f, -1.4f, -0.35f);
        }
        this.top.m_104301_(poseStack, vertexConsumer, i, j);
        poseStack.m_85849_();
        this.bottom.m_104301_(poseStack, vertexConsumer, i, j);
    }
}

