/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.block.ClamLauncherBlock;
import com.ninni.spawn.server.block.entity.HamsterWheelBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class HamsterWheelRenderer
implements BlockEntityRenderer<HamsterWheelBlockEntity> {
    public static final Material TEXTURE = new Material(TextureAtlas.f_118259_, new ResourceLocation("spawn", "entity/hamster/wheel/wheel"));
    private final ModelPart stand;
    private final ModelPart wheel;

    public HamsterWheelRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(SpawnEntityModelLayers.HAMSTER_WHEEL);
        this.stand = modelPart.m_171324_("stand");
        this.wheel = modelPart.m_171324_("wheel");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition stand = partdefinition.m_171599_("stand", CubeListBuilder.m_171558_().m_171514_(-1, 19).m_171488_(-0.5f, -9.0f, 3.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(-10, 30).m_171488_(-5.0f, -0.1f, -5.0f, 10.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-0.5f, -9.0f, 4.0f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition wheel = partdefinition.m_171599_("wheel", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.5f, -6.5f, -6.0f, 13.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(4, 22).m_171480_().m_171488_(4.5f, 4.5f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(4, 22).m_171488_(-6.5f, 4.5f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(24, 22).m_171488_(-6.5f, -6.5f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(24, 22).m_171480_().m_171488_(4.5f, -6.5f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void render(HamsterWheelBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        VertexConsumer vertexConsumer = TEXTURE.m_119194_(multiBufferSource, RenderType::m_110458_);
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        Direction d = (Direction)blockEntity.m_58900_().m_61143_((Property)ClamLauncherBlock.FACING);
        float g = ((Direction)blockEntity.m_58900_().m_61143_((Property)ClamLauncherBlock.FACING)).m_122435_();
        if (d == Direction.NORTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        } else if (d == Direction.SOUTH) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(g));
        }
        poseStack.m_252781_(new Quaternionf().rotateZ((float)Math.PI));
        poseStack.m_85836_();
        this.wheel.f_104205_ = blockEntity.angle + blockEntity.speed * f;
        this.wheel.m_104301_(poseStack, vertexConsumer, i, j);
        poseStack.m_85849_();
        this.stand.m_104301_(poseStack, vertexConsumer, i, j);
    }
}

