/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.AnglerFishModel;
import com.ninni.spawn.client.renderer.entity.feature.AnglerFishBioluminescenceLayer;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.AnglerFish;
import java.util.function.Predicate;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnglerFishRenderer<E extends AnglerFish>
extends MobRenderer<E, AnglerFishModel<E>> {
    private final AnglerFishModel<E> normalModel;
    private final AnglerFishModel<E> deflatedModel;

    public AnglerFishRenderer(EntityRendererProvider.Context context) {
        super(context, null, 0.3f);
        this.m_115326_((RenderLayer)new AnglerFishBioluminescenceLayer<AnglerFish>((RenderLayerParent<AnglerFish, AnglerFishModel<AnglerFish>>)this, Predicate.not(AnglerFish::isDeflated)));
        this.normalModel = this.createModel(context, SpawnEntityModelLayers.ANGLER_FISH);
        this.f_115290_ = this.normalModel;
        this.deflatedModel = this.createModel(context, SpawnEntityModelLayers.ANGLER_FISH_DEFLATED);
    }

    public void render(E mob, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.f_115290_ = ((AnglerFish)mob).isDeflated() ? this.deflatedModel : this.normalModel;
        super.m_7392_(mob, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(E entity) {
        ResourceLocation base = AnimalVariantManager.getVariantTexture(entity, "", "");
        ResourceLocation deflated = AnimalVariantManager.getVariantTexture(entity, "", "_deflated");
        return ((AnglerFish)entity).isDeflated() ? deflated : base;
    }

    protected void scale(E entity, PoseStack poseStack, float partialTickTime) {
        float scale = AnimalVariantManager.getVariantScale(entity);
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_(entity, poseStack, partialTickTime);
    }

    public AnglerFishModel<E> createModel(EntityRendererProvider.Context context, ModelLayerLocation layer) {
        return new AnglerFishModel(context.m_174023_(layer));
    }
}

