/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.ClamModel;
import com.ninni.spawn.client.renderer.entity.feature.ClamPatternLayer;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClamRenderer
extends MobRenderer<Clam, ClamModel> {
    private final ClamModel modelWedgeShell = (ClamModel)this.m_7200_();
    private final ClamModel modelScallop;
    private final ClamModel modelGiantClam;

    public ClamRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ClamModel(context.m_174023_(SpawnEntityModelLayers.CLAM_WEDGE_SHELL)), 0.0f);
        this.modelScallop = new ClamModel(context.m_174023_(SpawnEntityModelLayers.CLAM_SCALLOP));
        this.modelGiantClam = new ClamModel(context.m_174023_(SpawnEntityModelLayers.CLAM_GIANT_CLAM));
        this.m_115326_(new ClamPatternLayer((RenderLayerParent<Clam, ClamModel>)this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(Clam entity) {
        return new ResourceLocation("spawn", "textures/entity/clam/" + entity.getBaseColor().baseName() + "_" + entity.getBaseColor().colorName() + ".png");
    }

    public void render(Clam clam, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.f_115290_ = switch (clam.getVariant().baseColor().base()) {
            default -> throw new IncompatibleClassChangeError();
            case ClamVariant.Base.WEDGE_SHELL -> this.modelWedgeShell;
            case ClamVariant.Base.SCALLOP -> this.modelScallop;
            case ClamVariant.Base.GIANT_CLAM -> this.modelGiantClam;
        };
        super.m_7392_((Mob)clam, f, g, poseStack, multiBufferSource, i);
    }
}

