/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.ninni.spawn.client.model.SeahorseModel;
import com.ninni.spawn.client.renderer.entity.feature.SeahorseOverlayLayer;
import com.ninni.spawn.client.renderer.entity.feature.SeahorsePatternLayer;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Seahorse;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeahorseRenderer
extends MobRenderer<Seahorse, SeahorseModel<Seahorse>> {
    private final SeahorseModel<Seahorse> modelStout = (SeahorseModel)this.m_7200_();
    private final SeahorseModel<Seahorse> modelTiny;
    private final SeahorseModel<Seahorse> modelLanky;
    private final SeahorseModel<Seahorse> modelBonky;

    public SeahorseRenderer(EntityRendererProvider.Context context) {
        super(context, new SeahorseModel(context.m_174023_(SpawnEntityModelLayers.SEAHORSE_STOUT)), 0.2f);
        this.modelTiny = new SeahorseModel(context.m_174023_(SpawnEntityModelLayers.SEAHORSE_TINY));
        this.modelLanky = new SeahorseModel(context.m_174023_(SpawnEntityModelLayers.SEAHORSE_LANKY));
        this.modelBonky = new SeahorseModel(context.m_174023_(SpawnEntityModelLayers.SEAHORSE_BONKY));
        this.m_115326_(new SeahorsePatternLayer((RenderLayerParent<Seahorse, SeahorseModel<Seahorse>>)this, context.m_174027_()));
        this.m_115326_(new SeahorseOverlayLayer((RenderLayerParent<Seahorse, SeahorseModel<Seahorse>>)this, context.m_174027_()));
    }

    public void render(Seahorse seahorse, float f, float idk, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        String shape;
        ResourceLocation effective = AnimalVariantManager.getNameTagOverride((LivingEntity)seahorse).map(AnimalVariantManager.AnimalVariantData::id).orElse(seahorse.getVariant());
        SeahorseModel<Seahorse> chosen = switch (shape = (String)SeahorseRenderer.getShapeAndPattern(effective).getFirst()) {
            case "tiny" -> this.modelTiny;
            case "lanky" -> this.modelLanky;
            case "bonky" -> this.modelBonky;
            default -> this.modelStout;
        };
        this.f_115290_ = chosen;
        float[] baseColor = seahorse.getBaseColor().m_41068_();
        float[] color = SeahorseRenderer.saturateColor(baseColor[0], baseColor[1], baseColor[2], 1.25f);
        ((SeahorseModel)this.f_115290_).m_170501_(color[0], color[1], color[2]);
        super.m_7392_((Mob)seahorse, f, idk, poseStack, multiBufferSource, i);
        ((SeahorseModel)this.f_115290_).m_170501_(1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getTextureLocation(Seahorse entity) {
        return SeahorseRenderer.getSeahorseTexture(entity, "base");
    }

    public static ResourceLocation getSeahorseTexture(Seahorse entity, String layer) {
        return AnimalVariantManager.getNameTagOverride((LivingEntity)entity).map(data -> new ResourceLocation(data.id().m_135827_(), "textures/entity/seahorse/" + (String)SeahorseRenderer.getShapeAndPattern(data.id()).getFirst() + "/" + (String)SeahorseRenderer.getShapeAndPattern(data.id()).getSecond() + "/" + layer + ".png")).orElseGet(() -> new ResourceLocation(entity.getVariant().m_135827_(), "textures/entity/seahorse/" + (String)SeahorseRenderer.getShapeAndPattern(entity.getVariant()).getFirst() + "/" + (String)SeahorseRenderer.getShapeAndPattern(entity.getVariant()).getSecond() + "/" + layer + ".png"));
    }

    public static Pair<String, String> getShapeAndPattern(ResourceLocation variant) {
        String[] split = variant.m_135815_().split("/");
        String shape = split.length > 0 ? split[0] : "stout";
        String pattern = split.length > 1 ? split[1] : "plain";
        return new Pair((Object)shape, (Object)pattern);
    }

    protected void scale(Seahorse entity, PoseStack poseStack, float partialTickTime) {
        float scale = AnimalVariantManager.getVariantScale((LivingEntity)entity);
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
    }

    public static float[] saturateColor(float r, float g, float b, float saturationBoost) {
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float l = (max + min) / 2.0f;
        float s = delta == 0.0f ? 0.0f : delta / (1.0f - Math.abs(2.0f * l - 1.0f));
        s = Math.min(s * saturationBoost, 1.0f);
        float h = delta == 0.0f ? 0.0f : (max == r ? (g - b) / delta % 6.0f : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        return SeahorseRenderer.hslToRgb(h, s, l);
    }

    private static float[] hslToRgb(float h, float s, float l) {
        float b1;
        float g1;
        float r1;
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h * 6.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        if ((double)h < 0.16666666666666666) {
            r1 = c;
            g1 = x;
            b1 = 0.0f;
        } else if ((double)h < 0.3333333333333333) {
            r1 = x;
            g1 = c;
            b1 = 0.0f;
        } else if ((double)h < 0.5) {
            r1 = 0.0f;
            g1 = c;
            b1 = x;
        } else if ((double)h < 0.6666666666666666) {
            r1 = 0.0f;
            g1 = x;
            b1 = c;
        } else if ((double)h < 0.8333333333333334) {
            r1 = x;
            g1 = 0.0f;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0f;
            b1 = x;
        }
        return new float[]{r1 + m, g1 + m, b1 + m};
    }
}

