/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.SunfishModel;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Sunfish;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SunfishRenderer
extends MobRenderer<Sunfish, SunfishModel> {
    private final SunfishModel modelAdult = (SunfishModel)this.m_7200_();
    private final SunfishModel modelBaby;
    private final SunfishModel modelNewborn;

    public SunfishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SunfishModel(context.m_174023_(SpawnEntityModelLayers.SUNFISH)), 0.0f);
        this.modelBaby = new SunfishModel(context.m_174023_(SpawnEntityModelLayers.SUNFISH_BABY));
        this.modelNewborn = new SunfishModel(context.m_174023_(SpawnEntityModelLayers.SUNFISH_NEWBORN));
    }

    public void render(Sunfish sunfish, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.f_115290_ = switch (sunfish.getSunfishAge()) {
            case -2 -> this.modelNewborn;
            case -1 -> this.modelBaby;
            default -> this.modelAdult;
        };
        super.m_7392_((Mob)sunfish, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(Sunfish sunfish) {
        if (sunfish.getSunfishAge() == -2) {
            return SunfishRenderer.getResourceLocation(sunfish, "newborn", false);
        }
        if (sunfish.getSunfishAge() == -1) {
            return SunfishRenderer.getResourceLocation(sunfish, "baby", false);
        }
        if ((double)sunfish.baskingProgress > 0.9) {
            return SunfishRenderer.getResourceLocation(sunfish, "adult", true);
        }
        return SunfishRenderer.getResourceLocation(sunfish, "adult", false);
    }

    private static ResourceLocation getResourceLocation(Sunfish sunfish, String age, boolean relaxed) {
        return AnimalVariantManager.getVariantTexture((LivingEntity)sunfish, age + "/", relaxed ? "_relaxed" : "");
    }

    protected void scale(Sunfish entity, PoseStack poseStack, float partialTickTime) {
        float scale = AnimalVariantManager.getVariantScale((LivingEntity)entity);
        poseStack.m_85841_(scale, scale, scale);
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
    }
}

