/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.spawn.client.model.AnglerFishModel;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.AnglerFish;
import java.util.function.Predicate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnglerFishBioluminescenceLayer<T extends AnglerFish>
extends EyesLayer<T, AnglerFishModel<T>> {
    private final Predicate<T> predicate;

    public AnglerFishBioluminescenceLayer(RenderLayerParent<T, AnglerFishModel<T>> renderLayerParent, Predicate<T> predicate) {
        super(renderLayerParent);
        this.predicate = predicate;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T entity, float f, float g, float h, float j, float k, float l) {
        if (!this.predicate.test(entity)) {
            return;
        }
        ResourceLocation loc = AnimalVariantManager.getVariantTexture(entity, "", "_bioluminescence");
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)loc));
        ((AnglerFishModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public RenderType m_5708_() {
        return RenderType.m_234338_((ResourceLocation)new ResourceLocation("spawn", "textures/entity/angler_fish/angler_fish_olive_bioluminescence.png"));
    }
}

