/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.ClamModel;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClamPatternLayer
extends RenderLayer<Clam, ClamModel> {
    private final ClamModel modelWedgeShell;
    private final ClamModel modelScallop;
    private final ClamModel modelGiantClam;

    public ClamPatternLayer(RenderLayerParent<Clam, ClamModel> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.modelWedgeShell = new ClamModel(entityModelSet.m_171103_(SpawnEntityModelLayers.CLAM_WEDGE_SHELL));
        this.modelScallop = new ClamModel(entityModelSet.m_171103_(SpawnEntityModelLayers.CLAM_SCALLOP));
        this.modelGiantClam = new ClamModel(entityModelSet.m_171103_(SpawnEntityModelLayers.CLAM_GIANT_CLAM));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, Clam clam, float f, float a, float h, float j, float k, float l) {
        if (clam.getPattern() != ClamVariant.Pattern.NO_PATTERN) {
            ClamModel entityModel = switch (clam.getVariant().baseColor().base()) {
                default -> throw new IncompatibleClassChangeError();
                case ClamVariant.Base.WEDGE_SHELL -> this.modelWedgeShell;
                case ClamVariant.Base.SCALLOP -> this.modelScallop;
                case ClamVariant.Base.GIANT_CLAM -> this.modelGiantClam;
            };
            ResourceLocation resourceLocation = new ResourceLocation("spawn", "textures/entity/clam/variant/" + clam.getBaseColor().baseName() + "_" + clam.getPattern().patternName() + ".png");
            int fireworkColor = clam.getDyeColor().m_41070_();
            float r = (float)(fireworkColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(fireworkColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(fireworkColor & 0xFF) / 255.0f;
            float gray = 0.3f * r + 0.59f * g + 0.11f * b;
            float saturation = switch (clam.getVariant().baseColor().base()) {
                default -> throw new IncompatibleClassChangeError();
                case ClamVariant.Base.WEDGE_SHELL -> 0.6f;
                case ClamVariant.Base.SCALLOP -> 0.7f;
                case ClamVariant.Base.GIANT_CLAM -> 1.0f;
            };
            r = gray + (r - gray) * saturation;
            g = gray + (g - gray) * saturation;
            b = gray + (b - gray) * saturation;
            ClamPatternLayer.m_117359_((EntityModel)this.m_117386_(), (EntityModel)entityModel, (ResourceLocation)resourceLocation, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)clam, (float)f, (float)a, (float)j, (float)k, (float)l, (float)h, (float)r, (float)g, (float)b);
        }
    }
}

