/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.SeahorseModel;
import com.ninni.spawn.client.renderer.entity.SeahorseRenderer;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.Seahorse;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeahorsePatternLayer
extends RenderLayer<Seahorse, SeahorseModel<Seahorse>> {
    private final SeahorseModel<Seahorse> modelStout;
    private final SeahorseModel<Seahorse> modelTiny;
    private final SeahorseModel<Seahorse> modelLanky;
    private final SeahorseModel<Seahorse> modelBonky;

    public SeahorsePatternLayer(RenderLayerParent<Seahorse, SeahorseModel<Seahorse>> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.modelStout = new SeahorseModel(entityModelSet.m_171103_(SpawnEntityModelLayers.SEAHORSE_STOUT));
        this.modelTiny = new SeahorseModel(entityModelSet.m_171103_(SpawnEntityModelLayers.SEAHORSE_TINY));
        this.modelLanky = new SeahorseModel(entityModelSet.m_171103_(SpawnEntityModelLayers.SEAHORSE_LANKY));
        this.modelBonky = new SeahorseModel(entityModelSet.m_171103_(SpawnEntityModelLayers.SEAHORSE_BONKY));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, Seahorse seahorse, float f, float g, float h, float j, float k, float l) {
        String shape;
        ResourceLocation effective = AnimalVariantManager.getNameTagOverride((LivingEntity)seahorse).map(AnimalVariantManager.AnimalVariantData::id).orElse(seahorse.getVariant());
        SeahorseModel<Seahorse> model = switch (shape = (String)SeahorseRenderer.getShapeAndPattern(effective).getFirst()) {
            case "tiny" -> this.modelTiny;
            case "lanky" -> this.modelLanky;
            case "bonky" -> this.modelBonky;
            default -> this.modelStout;
        };
        float[] baseColor = seahorse.getPatternColor().m_41068_();
        float[] color = SeahorseRenderer.saturateColor(baseColor[0], baseColor[1], baseColor[2], 1.25f);
        SeahorsePatternLayer.m_117359_((EntityModel)this.m_117386_(), model, (ResourceLocation)this.getPatternTextureLocation(seahorse), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)seahorse, (float)f, (float)g, (float)j, (float)k, (float)l, (float)h, (float)color[0], (float)color[1], (float)color[2]);
    }

    public ResourceLocation getPatternTextureLocation(Seahorse entity) {
        return SeahorseRenderer.getSeahorseTexture(entity, "pattern");
    }
}

