/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.Spawn;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnProperties;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.entity.AnthillBlockEntity;
import com.ninni.spawn.server.data.AnthillRotManager;
import com.ninni.spawn.server.entity.Ant;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AnthillBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty RESOURCE_LEVEL = SpawnProperties.RESOURCE_LEVEL;

    public AnthillBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)RESOURCE_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, blockState, blockEntity, itemStack);
        if (!level.f_46443_ && blockEntity instanceof AnthillBlockEntity) {
            AnthillBlockEntity anthillBlockEntity = (AnthillBlockEntity)blockEntity;
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack) == 0) {
                anthillBlockEntity.angerAnts(player, blockState, AnthillBlockEntity.AntState.EMERGENCY);
                level.m_46717_(blockPos, (Block)this);
                this.angerNearbyAnts(level, blockPos);
            }
        }
    }

    private void angerNearbyAnts(Level world, BlockPos pos) {
        List antList = world.m_45976_(Ant.class, new AABB(pos).m_82377_(8.0, 6.0, 8.0));
        if (!antList.isEmpty()) {
            List playerList = world.m_45976_(Player.class, new AABB(pos).m_82377_(8.0, 6.0, 8.0));
            for (Ant ant : antList) {
                if (ant.m_5448_() != null || ant.m_21824_()) continue;
                ant.m_6710_((LivingEntity)playerList.get(world.f_46441_.m_188503_(playerList.size())));
            }
        }
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public @Nullable BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new AnthillBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : AnthillBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)SpawnBlockEntityTypes.ANTHILL.get()), AnthillBlockEntity::serverTick);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        if (!world.m_5776_() && player.m_7500_() && world.m_46469_().m_46207_(GameRules.f_46136_) && (blockEntity = world.m_7702_(pos)) instanceof AnthillBlockEntity) {
            boolean bl;
            AnthillBlockEntity blockEntity1 = (AnthillBlockEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            boolean bl2 = bl = !blockEntity1.hasNoAnts();
            if (bl) {
                CompoundTag nbtCompound = new CompoundTag();
                nbtCompound.m_128365_("Ants", (Tag)blockEntity1.getAnts());
                BlockItem.m_186338_((ItemStack)itemStack, (BlockEntityType)((BlockEntityType)SpawnBlockEntityTypes.ANTHILL.get()), (CompoundTag)nbtCompound);
                nbtCompound = new CompoundTag();
                itemStack.m_41700_("BlockStateTag", (Tag)nbtCompound);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemStack);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(world, pos, blockState, player);
    }

    public boolean m_6724_(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)RESOURCE_LEVEL) == 5;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource randomSource) {
        int range = 1;
        boolean transformedAny = false;
        for (int x = -range; x <= range; ++x) {
            block1: for (int z = -range; z <= range; ++z) {
                BlockPos targetPos = pos.m_7918_(x, -1, z);
                BlockState targetState = world.m_8055_(targetPos);
                for (AnthillRotManager.AnthillRotData data : Spawn.PROXY.getAnthillRotManager().getData()) {
                    Property property2;
                    if (!data.input().matches(targetState.m_60734_())) continue;
                    BlockState newState = data.output().state();
                    for (Property property2 : targetState.m_61147_()) {
                        if (!newState.m_61138_(property2)) continue;
                        newState = AnthillBlock.m_152454_(newState, targetState, property2);
                    }
                    world.m_7731_(targetPos, newState, 2);
                    property2 = world.m_7702_(targetPos);
                    if (property2 instanceof BrushableBlockEntity) {
                        BrushableBlockEntity brushable = (BrushableBlockEntity)property2;
                        ResourceLocation lootTable = data.lootTable();
                        if (lootTable != null) {
                            brushable.m_277049_(lootTable, targetPos.m_121878_());
                        }
                    }
                    transformedAny = true;
                    continue block1;
                }
            }
        }
        if (transformedAny) {
            world.m_247517_(null, pos, (SoundEvent)SpawnSoundEvents.ANTHILL_RESOURCE.get(), SoundSource.BLOCKS);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)RESOURCE_LEVEL, (Comparable)Integer.valueOf(0)), 2);
        }
    }

    private static <T extends Comparable<T>> BlockState m_152454_(BlockState to, BlockState from, Property<T> property) {
        return (BlockState)to.m_61124_(property, from.m_61143_(property));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        Entity entity = (Entity)builder.m_287159_(LootContextParams.f_81455_);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_)) instanceof AnthillBlockEntity) {
            AnthillBlockEntity blockEntity1 = (AnthillBlockEntity)blockEntity;
            blockEntity1.angerAnts(null, state, AnthillBlockEntity.AntState.EMERGENCY);
        }
        return super.m_49635_(state, builder);
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, RESOURCE_LEVEL});
    }
}

