/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.registry.SpawnProperties;
import com.ninni.spawn.server.block.state.properties.BigSeaPickleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BigSeaPickleBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHAPE_DOUBLE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TIP = SpawnProperties.TIP;
    public static final EnumProperty<BigSeaPickleType> TYPE = SpawnProperties.BIG_SEA_PICKLE_TYPE;

    public BigSeaPickleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)BigSeaPickleType.SINGLE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_(TYPE) != BigSeaPickleType.SINGLE ? SHAPE_DOUBLE : SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean isWater;
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        BlockState state = level.m_8055_(pos);
        boolean bl = isWater = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        if (state.m_60713_((Block)this) && state.m_61143_(TYPE) == BigSeaPickleType.SINGLE) {
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            return (BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)((Object)(aboveState.m_60713_((Block)this) ? BigSeaPickleType.BOTTOM : BigSeaPickleType.DOUBLE)))).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(BigSeaPickleBlock.shouldTipBeTrue(isWater, false, (LevelReader)level, pos)));
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)BigSeaPickleType.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(BigSeaPickleBlock.shouldTipBeTrue(isWater, true, (LevelReader)level, pos)));
    }

    public static boolean shouldTipBeTrue(boolean isWater, boolean isSingle, LevelReader level, BlockPos pos) {
        if (isWater) {
            if (isSingle) {
                return true;
            }
            return level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_) && !level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50567_);
        }
        return false;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)SpawnProperties.TIP) != false ? 15 : 0;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return !state.m_60812_(level, pos).m_83263_(Direction.UP).m_83281_() || state.m_60783_(level, pos, Direction.UP);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.mayPlaceOn(level.m_8055_(blockpos), (BlockGetter)level, blockpos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean isWater;
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        BigSeaPickleType type = (BigSeaPickleType)((Object)state.m_61143_(TYPE));
        boolean bl = isWater = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        if (type == BigSeaPickleType.BOTTOM) {
            type = BigSeaPickleType.DOUBLE;
        }
        if (aboveState.m_60713_((Block)this) && type == BigSeaPickleType.DOUBLE) {
            type = BigSeaPickleType.BOTTOM;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(BigSeaPickleBlock.shouldTipBeTrue(isWater, type == BigSeaPickleType.SINGLE, (LevelReader)level, pos)))).m_61124_(TYPE, (Comparable)((Object)type));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TIP, TYPE});
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && state.m_61143_(TYPE) == BigSeaPickleType.SINGLE || super.m_6864_(state, useContext);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState newState;
        boolean isWaterlogged;
        if (state.m_61143_(TYPE) == BigSeaPickleType.SINGLE && level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13051_)) {
            isWaterlogged = (Boolean)state.m_61143_((Property)WATERLOGGED);
            newState = (BlockState)((BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)((Object)BigSeaPickleType.DOUBLE))).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(BigSeaPickleBlock.shouldTipBeTrue(isWaterlogged, false, (LevelReader)level, pos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
            level.m_7731_(pos, newState, 2);
        }
        if (state.m_61143_(TYPE) == BigSeaPickleType.DOUBLE && level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13051_)) {
            isWaterlogged = level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_;
            newState = (BlockState)((BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)((Object)BigSeaPickleType.SINGLE))).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(BigSeaPickleBlock.shouldTipBeTrue(isWaterlogged, true, (LevelReader)level, pos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
            level.m_7731_(pos.m_7494_(), newState, 2);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

