/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block;

import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnProperties;
import com.ninni.spawn.registry.SpawnTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MucusBlockBlock
extends Block {
    private static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;
    public static final BooleanProperty SOLID = SpawnProperties.SOLID;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);

    public MucusBlockBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7)));
    }

    public @Nullable BlockState m_5573_(BlockPlaceContext ctx) {
        return MucusBlockBlock.updateDistanceFromWater(this.m_49966_(), ctx.m_43725_(), ctx.m_8083_());
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        int i = MucusBlockBlock.getDistanceFromWater(blockState2) + 1;
        if (i != 1 || (Integer)blockState.m_61143_((Property)DISTANCE) != i) {
            levelAccessor.m_186460_(blockPos, (Block)this, 2);
        }
        return blockState;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        serverLevel.m_7731_(blockPos, MucusBlockBlock.updateDistanceFromWater(blockState, (Level)serverLevel, blockPos), 3);
    }

    private static BlockState updateDistanceFromWater(BlockState state, Level world, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutable.m_122159_((Vec3i)pos, direction);
            i = Math.min(i, MucusBlockBlock.getDistanceFromWater(world.m_8055_((BlockPos)mutable)) + 1);
            if (i == 1) break;
        }
        world.m_5594_(null, pos, world.m_8055_(pos).m_60734_().m_49962_(state).m_56775_(), SoundSource.BLOCKS, 0.15f, 1.5f);
        return (BlockState)((BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)SOLID, (Comparable)Boolean.valueOf(i < 7));
    }

    public static int getDistanceFromWater(BlockState state) {
        if (state.m_204336_(SpawnTags.MUCUS_SOLIDIFIER)) {
            return 0;
        }
        if (state.m_204336_(SpawnTags.MUCUS_SOLIDIFICATION_SPREADER)) {
            return (Integer)state.m_61143_((Property)DISTANCE);
        }
        return 7;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_6095_() == SpawnEntityType.SNAIL.get() || entity.m_6095_() == EntityType.f_20550_) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            SpawnCriteriaTriggers.GOT_STUCK_IN_MUCUS.trigger(serverPlayer);
        }
        entity.m_7601_(blockState, new Vec3(0.5, 0.5, 0.5));
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)SOLID) != false ? Shapes.m_83144_() : SHAPE;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SOLID, DISTANCE});
    }
}

