/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block.entity;

import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnNetwork;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.block.MorayCreviceBlock;
import com.ninni.spawn.server.block.entity.VariantHolderBlockEntity;
import com.ninni.spawn.server.block.state.properties.CaptureState;
import com.ninni.spawn.server.entity.Sunfish;
import com.ninni.spawn.server.network.BlockEntitySyncPacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MorayCreviceBlockEntity
extends VariantHolderBlockEntity {
    private int pounceTicks = 0;
    public static final int POUNCE_DURATION = 10;
    private ItemStack storedBucket = ItemStack.f_41583_;
    private int targetEntityId = -1;
    private int peekTicks = 0;
    private int peekTotalTicks = 0;
    private int peekClientAge = 0;
    public static final int PEEK_MIN_TICKS = 120;
    public static final int PEEK_MAX_TICKS = 200;

    public MorayCreviceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SpawnBlockEntityTypes.MORAY_CREVICE.get(), pos, state);
    }

    public static void serverTick(MorayCreviceBlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null || level.f_46443_) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        CaptureState stage = (CaptureState)((Object)state.m_61143_(MorayCreviceBlock.STATE));
        if (!((Boolean)state.m_61143_((Property)MorayCreviceBlock.SUBMERGED)).booleanValue()) {
            if (stage == CaptureState.PEEKING || stage == CaptureState.POUNCING) {
                level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.READY)), 3);
                blockEntity.peekTicks = 0;
                blockEntity.targetEntityId = -1;
                blockEntity.sync();
            }
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)MorayCreviceBlock.FACING);
        switch (stage) {
            case READY: {
                if (blockEntity.peekTicks <= 0 && level.f_46441_.m_188501_() < 0.001f) {
                    blockEntity.peekTotalTicks = blockEntity.peekTicks = 120 + level.f_46441_.m_188503_(81);
                    level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.PEEKING)), 3);
                    blockEntity.sync();
                    return;
                }
                if (((Boolean)state.m_61143_((Property)MorayCreviceBlock.POWERED)).booleanValue()) {
                    return;
                }
                AABB box = blockEntity.lookAABB(facing, 3);
                List targets = level.m_6443_(LivingEntity.class, box, entity -> {
                    Sunfish sunfish;
                    if (entity instanceof Sunfish && !(sunfish = (Sunfish)entity).m_6162_()) {
                        return false;
                    }
                    return entity instanceof Bucketable && entity.m_6084_();
                });
                if (targets.isEmpty()) break;
                LivingEntity tgt = (LivingEntity)targets.get(0);
                if (!blockEntity.hasClearLineOfSightTo((Entity)tgt, facing)) {
                    return;
                }
                blockEntity.targetEntityId = tgt.m_19879_();
                blockEntity.pounceTicks = 10;
                level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.POUNCING)), 3);
                level.m_5594_(null, blockEntity.f_58858_, (SoundEvent)SpawnSoundEvents.MORAY_CREVICE_CATCH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                blockEntity.sync();
                break;
            }
            case PEEKING: {
                if (blockEntity.tryAcquireTargetWhileActive(facing)) {
                    blockEntity.pounceTicks = 10;
                    level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.POUNCING)), 3);
                    level.m_5594_(null, blockEntity.f_58858_, (SoundEvent)SpawnSoundEvents.MORAY_CREVICE_CATCH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    blockEntity.sync();
                    return;
                }
                if (blockEntity.peekTicks > 0) {
                    --blockEntity.peekTicks;
                    break;
                }
                level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.READY)), 3);
                blockEntity.sync();
                break;
            }
            case POUNCING: {
                if (blockEntity.pounceTicks > 0) {
                    --blockEntity.pounceTicks;
                    blockEntity.pullTargetSlightly();
                    break;
                }
                Entity target = level.m_6815_(blockEntity.targetEntityId);
                if (blockEntity.storedBucket.m_41619_() && target instanceof Bucketable) {
                    Bucketable bkt = (Bucketable)target;
                    ItemStack bucketStack = bkt.m_28282_();
                    if (!bucketStack.m_41619_()) {
                        bkt.m_6872_(bucketStack);
                        if (level instanceof ServerLevel) {
                            ServerLevel sl = (ServerLevel)level;
                            sl.m_8767_((ParticleOptions)ParticleTypes.f_123774_, target.m_20185_(), target.m_20186_(), target.m_20189_(), 10, 0.2, 0.1, 0.2, 0.02);
                        }
                        target.m_146870_();
                        blockEntity.storedBucket = bucketStack.m_41777_();
                        level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.FULL)), 3);
                        blockEntity.sync();
                        break;
                    }
                    level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.READY)), 3);
                    blockEntity.sync();
                    break;
                }
                level.m_7731_(blockEntity.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.READY)), 3);
                blockEntity.sync();
                break;
            }
        }
    }

    private boolean tryAcquireTargetWhileActive(Direction facing) {
        LivingEntity tgt;
        if (this.f_58857_ == null) {
            return false;
        }
        AABB box = this.lookAABB(facing, 3);
        List targets = this.f_58857_.m_6443_(LivingEntity.class, box, entity -> {
            Sunfish sunfish;
            if (entity instanceof Sunfish && !(sunfish = (Sunfish)entity).m_6162_()) {
                return false;
            }
            return entity instanceof Bucketable && entity.m_6084_();
        });
        if (!targets.isEmpty() && this.hasClearLineOfSightTo((Entity)(tgt = (LivingEntity)targets.get(0)), facing)) {
            this.targetEntityId = tgt.m_19879_();
            return true;
        }
        return false;
    }

    private AABB lookAABB(Direction facing, int length) {
        BlockPos base = this.f_58858_;
        BlockPos end = base.m_5484_(facing, length);
        int minX = Math.min(base.m_123341_(), end.m_123341_());
        int minY = base.m_123342_();
        int minZ = Math.min(base.m_123343_(), end.m_123343_());
        int maxX = Math.max(base.m_123341_(), end.m_123341_()) + 1;
        int maxY = base.m_123342_() + 1;
        int maxZ = Math.max(base.m_123343_(), end.m_123343_()) + 1;
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private Vec3 mouthPos(Direction facing) {
        Vec3 c = this.f_58858_.m_252807_();
        return c.m_82520_((double)facing.m_122429_() * 0.501, 0.5 - c.f_82480_ + (double)this.f_58858_.m_123342_(), (double)facing.m_122431_() * 0.501);
    }

    private boolean hasClearLineOfSightTo(Entity target, Direction facing) {
        Vec3 end;
        if (this.f_58857_ == null) {
            return false;
        }
        Vec3 start = this.mouthPos(facing);
        BlockHitResult result = this.f_58857_.m_45547_(new ClipContext(start, end = target.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return result.m_6662_() == HitResult.Type.MISS;
    }

    public static void clientTick(MorayCreviceBlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null || !level.f_46443_) {
            return;
        }
        CaptureState stage = (CaptureState)((Object)blockEntity.m_58900_().m_61143_(MorayCreviceBlock.STATE));
        if (stage == CaptureState.POUNCING && blockEntity.pounceTicks > 0) {
            --blockEntity.pounceTicks;
        }
        blockEntity.peekClientAge = stage == CaptureState.PEEKING ? ++blockEntity.peekClientAge : 0;
    }

    private void pullTargetSlightly() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Entity e;
            ServerLevel sl = (ServerLevel)level;
            if (this.targetEntityId != -1 && (e = sl.m_6815_(this.targetEntityId)) != null) {
                Vec3 center = this.f_58858_.m_252807_();
                Vec3 v = center.m_82546_(e.m_20182_()).m_82541_().m_82490_(0.05);
                e.m_5997_(v.f_82479_, v.f_82480_ * 0.2, v.f_82481_);
            }
        }
    }

    public void forceStopClientAnims() {
        this.pounceTicks = 0;
        this.peekClientAge = 0;
    }

    public int getPounceTicks() {
        return this.pounceTicks;
    }

    public int getPeekTotalTicks() {
        return this.peekTotalTicks;
    }

    public int getPeekClientAge() {
        return this.peekClientAge;
    }

    public ItemStack takeBucketedFish() {
        ItemStack out = this.storedBucket;
        this.storedBucket = ItemStack.f_41583_;
        this.sync();
        return out;
    }

    public boolean hasFish() {
        return !this.storedBucket.m_41619_();
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "peel");
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state;
            this.ensureVariantAssigned();
            if (!this.storedBucket.m_41619_() && (state = this.m_58900_()).m_61143_(MorayCreviceBlock.STATE) != CaptureState.FULL) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_(MorayCreviceBlock.STATE, (Comparable)((Object)CaptureState.FULL)), 3);
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pounceTicks = tag.m_128451_("PounceTicks");
        this.targetEntityId = tag.m_128451_("TargetId");
        this.peekTicks = tag.m_128451_("PeekTicks");
        this.peekTotalTicks = tag.m_128451_("PeekTotalTicks");
        this.storedBucket = tag.m_128441_("StoredBucket") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("StoredBucket")) : ItemStack.f_41583_;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("PounceTicks", this.pounceTicks);
        tag.m_128405_("TargetId", this.targetEntityId);
        tag.m_128405_("PeekTicks", this.peekTicks);
        tag.m_128405_("PeekTotalTicks", this.peekTotalTicks);
        if (!this.storedBucket.m_41619_()) {
            tag.m_128365_("StoredBucket", (Tag)this.storedBucket.m_41739_(new CompoundTag()));
        }
    }

    public void sync() {
        this.m_6596_();
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.m_5776_()) {
            SpawnNetwork.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new BlockEntitySyncPacket(this.f_58858_, tag));
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    public @Nullable Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }
}

