/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block.entity;

import com.ninni.spawn.client.inventory.OctoductMenu;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.server.block.OctoductBlock;
import com.ninni.spawn.server.entity.Octopus;
import com.ninni.spawn.server.entity.common.Catchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class OctoductBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private int expelCooldown = 0;

    public OctoductBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)SpawnBlockEntityTypes.OCTODUCT.get(), blockPos, blockState);
    }

    public int m_6643_() {
        return 9;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OctoductBlockEntity blockEntity) {
        if (!((Boolean)state.m_61143_((Property)OctoductBlock.ENABLED)).booleanValue()) {
            return;
        }
        if (blockEntity.expelCooldown > 0) {
            --blockEntity.expelCooldown;
            return;
        }
        if (((Boolean)state.m_61143_((Property)OctoductBlock.EXPELLING)).booleanValue() && (level.m_8055_(pos.m_7494_()).m_60795_() || level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_))) {
            for (int i = 0; i < blockEntity.m_6643_(); ++i) {
                ItemStack stack = blockEntity.m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() != SpawnItems.CAPTURED_OCTOPUS.get()) continue;
                Vec3 vec = Vec3.m_82512_((Vec3i)pos.m_7494_()).m_82520_(0.0, -0.5, 0.0);
                Mob mob = Catchable.releaseFromTag(stack.m_41783_(), (ServerLevel)level, vec, 0.0f, 0.0f, (EntityType)SpawnEntityType.OCTOPUS.get());
                if (mob instanceof Octopus) {
                    Octopus octopus = (Octopus)mob;
                    octopus.m_9236_().m_7605_((Entity)octopus, (byte)9);
                    octopus.enterExitCooldown = 20;
                }
                if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Item")) {
                    blockEntity.m_6836_(i, ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("Item")));
                } else {
                    blockEntity.m_6836_(i, ItemStack.f_41583_);
                }
                blockEntity.expelCooldown = 60;
                break;
            }
        }
    }

    public int getRandomSlot(RandomSource random) {
        this.m_59640_(null);
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.items.size(); ++k) {
            if (((ItemStack)this.items.get(k)).m_41619_() || random.m_188503_(j++) != 0) continue;
            i = k;
        }
        return i;
    }

    public int addItem(ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            this.m_6836_(i, stack);
            return i;
        }
        return -1;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"spawn.container.octoduct");
    }

    public boolean hasSpaceFor(ItemStack stack) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack slot = this.m_8020_(i);
            if (!slot.m_41619_() && (!ItemStack.m_150942_((ItemStack)slot, (ItemStack)stack) || slot.m_41613_() >= slot.m_41741_())) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new OctoductMenu(id, player, (Container)this);
    }
}

