/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.block.entity;

import com.ninni.spawn.server.data.BlockVariantManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class VariantHolderBlockEntity
extends BlockEntity
implements Nameable {
    private ResourceLocation variant;
    private Component customName;

    protected VariantHolderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract ResourceLocation getDefaultVariant();

    public void setVariant(ResourceLocation id) {
        this.variant = id;
        this.m_6596_();
    }

    public ResourceLocation getVariant() {
        return this.variant != null ? this.variant : this.getDefaultVariant();
    }

    public void ensureVariantAssigned() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!BlockVariantManager.isValidVariant(this, this.variant)) {
            BlockVariantManager.assignNaturally(this);
            this.m_6596_();
        }
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
        this.m_6596_();
    }

    protected Component getDefaultName() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public void m_142466_(CompoundTag tag) {
        ResourceLocation rl;
        super.m_142466_(tag);
        if (tag.m_128425_("Variant", 8) && (rl = ResourceLocation.m_135820_((String)tag.m_128461_("Variant"))) != null) {
            this.variant = rl;
        }
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.variant != null) {
            tag.m_128359_("Variant", this.variant.toString());
        }
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }
}

