/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.data;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.spawn.Spawn;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;

public class AnimalVariantManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final List<AnimalVariantData> DATA = Lists.newArrayList();

    public AnimalVariantManager() {
        super(GSON_INSTANCE, "animal_variants");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DATA.clear();
        object.forEach((resourceLocation, jsonElement) -> {
            AnimalVariantData data = AnimalVariantData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().orElseGet(() -> {
                Spawn.LOGGER.error("Failed to read animal variant entry for resource {}", resourceLocation);
                return null;
            });
            if (data != null) {
                DATA.add(data);
            }
        });
        Spawn.LOGGER.info("Loaded {} animal variants", (Object)DATA.size());
    }

    public static boolean isValidVariant(ResourceLocation id) {
        for (AnimalVariantData data : DATA) {
            if (!data.id().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    public static void getNaturallyOccurringVariant(LivingEntity entity) {
        if (entity instanceof JsonVariantHolder) {
            WeightedEntry variant;
            int minYLevel;
            int maxYLevel;
            int yLevel;
            JsonVariantHolder variantHolder = (JsonVariantHolder)entity;
            Holder holder = entity.m_9236_().m_204166_(entity.m_20183_());
            List<WeightedEntry> weightedEntries = AnimalVariantManager.buildWeightedEntries((Entity)entity, arg_0 -> AnimalVariantManager.lambda$getNaturallyOccurringVariant$2(holder, yLevel = entity.m_20183_().m_123342_(), maxYLevel = entity.m_9236_().m_151558_(), minYLevel = entity.m_9236_().m_141937_(), arg_0));
            if (weightedEntries.isEmpty()) {
                weightedEntries = AnimalVariantManager.buildWeightedEntries((Entity)entity, data -> data.location().isEmpty() && yLevel <= data.maxSpawnHeight().orElse(maxYLevel) && yLevel > data.minSpawnHeight().orElse(minYLevel));
            }
            if ((variant = AnimalVariantManager.chooseWeightedVariant(weightedEntries, entity)) != null) {
                variantHolder.setVariant(variant.id());
                variantHolder.setVariantScale(variant.scale());
            } else {
                variantHolder.setVariant(variantHolder.getDefaultVariant());
            }
        }
    }

    private static WeightedEntry chooseWeightedVariant(List<WeightedEntry> entries, LivingEntity entity) {
        if (entries.isEmpty()) {
            return null;
        }
        int totalWeight = entries.stream().mapToInt(WeightedEntry::weight).sum();
        int randomWeight = entity.m_9236_().f_46441_.m_188503_(totalWeight);
        if (totalWeight <= 0) {
            return null;
        }
        int cumulativeWeight = 0;
        for (WeightedEntry entry : entries) {
            if (randomWeight >= (cumulativeWeight += entry.weight())) continue;
            return entry;
        }
        return null;
    }

    private static List<WeightedEntry> buildWeightedEntries(Entity entity, Predicate<AnimalVariantData> filter) {
        ArrayList<WeightedEntry> weightedEntries = new ArrayList<WeightedEntry>();
        for (AnimalVariantData data : DATA) {
            if (!AnimalVariantManager.matchesEntityType(entity, data) || !filter.test(data) || !data.spawnWeight().isPresent() || !data.nameTag().isEmpty()) continue;
            weightedEntries.add(new WeightedEntry(data.id(), data.scale(), data.spawnWeight().get()));
        }
        return weightedEntries;
    }

    private static boolean matchesEntityType(Entity entity, AnimalVariantData data) {
        return entity.m_6095_().equals(data.type()) || data.childType().isPresent() && entity.m_6095_().equals(data.childType().get());
    }

    public static Optional<AnimalVariantData> getNameTagOverride(LivingEntity entity) {
        Component customName = entity.m_7770_();
        if (customName == null) {
            return Optional.empty();
        }
        for (AnimalVariantData data : DATA) {
            if (!AnimalVariantManager.matchesEntityType((Entity)entity, data) || !data.nameTag().isPresent() || !data.nameTag().get().matches(customName)) continue;
            return Optional.of(data);
        }
        return Optional.empty();
    }

    public static ResourceLocation getVariantTexture(LivingEntity entity, String subfolder, String extra) {
        if (!(entity instanceof JsonVariantHolder)) {
            return null;
        }
        JsonVariantHolder variantHolder = (JsonVariantHolder)entity;
        String entityName = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).m_135815_();
        return AnimalVariantManager.getNameTagOverride(entity).map(data -> new ResourceLocation(data.id().m_135827_(), "textures/entity/" + entityName + "/" + subfolder + entityName + "_" + data.id().m_135815_() + extra + ".png")).orElseGet(() -> new ResourceLocation(variantHolder.getVariant().m_135827_(), "textures/entity/" + entityName + "/" + subfolder + entityName + "_" + variantHolder.getVariant().m_135815_() + extra + ".png"));
    }

    public static float getVariantScale(LivingEntity entity) {
        if (!(entity instanceof JsonVariantHolder)) {
            return 1.0f;
        }
        JsonVariantHolder variantHolder = (JsonVariantHolder)entity;
        return AnimalVariantManager.getNameTagOverride(entity).map(AnimalVariantData::scale).orElse(Float.valueOf(variantHolder.getVariantScale())).floatValue();
    }

    private static /* synthetic */ boolean lambda$getNaturallyOccurringVariant$2(Holder holder, int yLevel, int maxYLevel, int minYLevel, AnimalVariantData data) {
        return data.location().isPresent() && data.location().get().matchesBiome((Holder<Biome>)holder) && yLevel <= data.maxSpawnHeight().orElse(maxYLevel) && yLevel > data.minSpawnHeight().orElse(minYLevel);
    }

    public record AnimalVariantData(EntityType<?> type, Optional<EntityType<?>> childType, ResourceLocation id, Optional<Location> location, Optional<Integer> spawnWeight, Optional<Integer> maxSpawnHeight, Optional<Integer> minSpawnHeight, float scale, Optional<NameTagRule> nameTag) {
        public static final Codec<Location> LOCATION_CODEC = Codec.either((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_), (Codec)TagKey.m_203886_((ResourceKey)Registries.f_256952_)).xmap(Location::new, Location::get);
        public static final Codec<AnimalVariantData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("type").forGetter(AnimalVariantData::type), (App)BuiltInRegistries.f_256780_.m_194605_().optionalFieldOf("childType").forGetter(AnimalVariantData::childType), (App)ResourceLocation.f_135803_.fieldOf("id").forGetter(AnimalVariantData::id), (App)LOCATION_CODEC.optionalFieldOf("location").forGetter(AnimalVariantData::location), (App)Codec.INT.optionalFieldOf("spawnWeight").forGetter(AnimalVariantData::spawnWeight), (App)Codec.INT.optionalFieldOf("maxSpawnHeight").forGetter(AnimalVariantData::maxSpawnHeight), (App)Codec.INT.optionalFieldOf("minSpawnHeight").forGetter(AnimalVariantData::minSpawnHeight), (App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(1.0f)).forGetter(AnimalVariantData::scale), (App)NameTagRule.CODEC.optionalFieldOf("nameTag").forGetter(AnimalVariantData::nameTag)).apply((Applicative)instance, AnimalVariantData::new));
    }

    public record WeightedEntry(ResourceLocation id, float scale, int weight) {
    }

    public record NameTagRule(List<String> names, boolean ignoreCase) {
        static final Codec<NameTagRule> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("names").forGetter(NameTagRule::names), (App)Codec.BOOL.optionalFieldOf("ignoreCase", (Object)true).forGetter(NameTagRule::ignoreCase)).apply((Applicative)i, NameTagRule::new));

        boolean matches(Component customName) {
            if (customName == null) {
                return false;
            }
            String actual = customName.getString();
            for (String n : this.names) {
                if (!(this.ignoreCase ? actual.equalsIgnoreCase(n) : actual.equals(n))) continue;
                return true;
            }
            return false;
        }
    }

    public static class Location {
        private final Either<ResourceKey<Biome>, TagKey<Biome>> value;

        public Location(Either<ResourceKey<Biome>, TagKey<Biome>> value) {
            this.value = value;
        }

        public Either<ResourceKey<Biome>, TagKey<Biome>> get() {
            return this.value;
        }

        public boolean matchesBiome(Holder<Biome> biome) {
            if (this.value.left().isPresent()) {
                return biome.m_203565_((ResourceKey)this.value.left().get());
            }
            return biome.m_203656_((TagKey)this.value.right().get());
        }
    }
}

