/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.spawn.Spawn;
import com.ninni.spawn.registry.SpawnNetwork;
import com.ninni.spawn.server.data.BlockOrTag;
import com.ninni.spawn.server.network.AnthillRotSyncPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class AnthillRotManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final List<AnthillRotData> DATA = Lists.newArrayList();

    public AnthillRotManager() {
        super(GSON_INSTANCE, "anthill_rot_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DATA.clear();
        object.forEach((resourceLocation, jsonElement) -> {
            AnthillRotData data = AnthillRotData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().orElseGet(() -> {
                Spawn.LOGGER.error("Failed to read anthill rot recipe for resource {}", resourceLocation);
                return null;
            });
            if (data != null && (data.input().isTag() || data.input().getBlock() != Blocks.f_50016_) && !data.output().state().m_60795_()) {
                DATA.add(data);
            }
        });
        Spawn.LOGGER.info("Loaded {} anthill rot recipes", (Object)DATA.size());
    }

    public List<AnthillRotData> getData() {
        return DATA;
    }

    public void onDatapackSync(@Nullable ServerPlayer player) {
        if (DATA.isEmpty()) {
            return;
        }
        HashBiMap registryMap = HashBiMap.create();
        for (AnthillRotData data : DATA) {
            ResourceLocation id = data.input().isTag() ? data.input().getTag().f_203868_() : BuiltInRegistries.f_256975_.m_7981_((Object)data.input().getBlock());
            registryMap.put((Object)id, (Object)data);
        }
        if (player == null) {
            SpawnNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AnthillRotSyncPacket((BiMap<ResourceLocation, AnthillRotData>)registryMap));
        } else {
            SpawnNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AnthillRotSyncPacket((BiMap<ResourceLocation, AnthillRotData>)registryMap));
        }
    }

    public void synchronizeRegistryForClient(BiMap<ResourceLocation, AnthillRotData> newData) {
        DATA.clear();
        DATA.addAll(newData.values());
    }

    public record AnthillRotData(BlockOrTag input, BlockStateWithProps output, @Nullable ResourceLocation lootTable) {
        public static final Codec<AnthillRotData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockOrTag.CODEC.fieldOf("input").forGetter(AnthillRotData::input), (App)BlockStateWithProps.CODEC.fieldOf("output").forGetter(AnthillRotData::output), (App)ResourceLocation.f_135803_.optionalFieldOf("loot_table").forGetter(data -> Optional.ofNullable(data.lootTable()))).apply((Applicative)instance, (input, output, lootOpt) -> new AnthillRotData((BlockOrTag)input, (BlockStateWithProps)output, lootOpt.orElse(null))));

        public static AnthillRotData fromNetwork(FriendlyByteBuf buf) {
            BlockOrTag input = BlockOrTag.fromNetwork(buf);
            BlockStateWithProps output = BlockStateWithProps.fromNetwork(buf);
            boolean hasLoot = buf.readBoolean();
            ResourceLocation loot = hasLoot ? buf.m_130281_() : null;
            return new AnthillRotData(input, output, loot);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            this.input.toNetwork(buf);
            this.output.toNetwork(buf);
            buf.writeBoolean(this.lootTable != null);
            if (this.lootTable != null) {
                buf.m_130085_(this.lootTable);
            }
        }
    }

    public record BlockStateWithProps(BlockState state, Map<String, String> explicitProps) {
        public static final Codec<BlockStateWithProps> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(bs -> BuiltInRegistries.f_256975_.m_7981_((Object)bs.state.m_60734_())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties", Map.of()).forGetter(bs -> bs.explicitProps)).apply((Applicative)instance, (name, propMap) -> {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(name);
            BlockState state = block.m_49966_();
            for (Map.Entry entry : propMap.entrySet()) {
                Property property = block.m_49965_().m_61081_((String)entry.getKey());
                if (property == null) continue;
                state = BlockStateWithProps.applyProperty(state, property, (String)entry.getValue());
            }
            return new BlockStateWithProps(state, (Map<String, String>)propMap);
        }));

        private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, Property<T> prop, String valueStr) {
            Optional value = prop.m_6215_(valueStr);
            return value.map(v -> (BlockState)state.m_61124_(prop, v)).orElse(state);
        }

        public static BlockStateWithProps fromNetwork(FriendlyByteBuf buf) {
            Block block = (Block)buf.m_236816_((IdMap)BuiltInRegistries.f_256975_);
            BlockState state = block.m_49966_();
            int propCount = buf.m_130242_();
            HashMap<String, String> explicitProps = new HashMap<String, String>();
            for (int i = 0; i < propCount; ++i) {
                String key = buf.m_130277_();
                String value = buf.m_130277_();
                explicitProps.put(key, value);
                Property prop = block.m_49965_().m_61081_(key);
                if (prop == null) continue;
                state = BlockStateWithProps.applyProperty(state, prop, value);
            }
            return new BlockStateWithProps(state, explicitProps);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)this.state.m_60734_());
            buf.m_130130_(this.explicitProps.size());
            for (Map.Entry<String, String> entry : this.explicitProps.entrySet()) {
                buf.m_130070_(entry.getKey());
                buf.m_130070_(entry.getValue());
            }
        }
    }
}

