/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockOrTag {
    private final Block block;
    private final TagKey<Block> tag;
    public static final Codec<BlockOrTag> CODEC = Codec.STRING.comapFlatMap(string -> {
        if (string.startsWith("#")) {
            ResourceLocation id = new ResourceLocation(string.substring(1));
            return DataResult.success((Object)new BlockOrTag((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id)));
        }
        ResourceLocation id = new ResourceLocation(string);
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
        if (block == null || block == Blocks.f_50016_) {
            return DataResult.error(() -> "Unknown block: " + id);
        }
        return DataResult.success((Object)new BlockOrTag(block));
    }, value -> {
        if (value.isTag()) {
            return "#" + value.tag.f_203868_();
        }
        return BuiltInRegistries.f_256975_.m_7981_((Object)value.block).toString();
    });

    public BlockOrTag(Block block) {
        this.block = block;
        this.tag = null;
    }

    public BlockOrTag(TagKey<Block> tag) {
        this.block = null;
        this.tag = tag;
    }

    public boolean isTag() {
        return this.tag != null;
    }

    public boolean matches(Block block) {
        return this.isTag() ? block.m_49966_().m_204336_(this.tag) : block.equals(this.block);
    }

    public Block getBlock() {
        return this.block;
    }

    public TagKey<Block> getTag() {
        return this.tag;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isTag());
        if (this.isTag()) {
            buf.m_130085_(this.tag.f_203868_());
        } else {
            buf.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)this.block);
        }
    }

    public static BlockOrTag fromNetwork(FriendlyByteBuf buf) {
        boolean isTag = buf.readBoolean();
        if (isTag) {
            ResourceLocation tagId = buf.m_130281_();
            return new BlockOrTag((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagId));
        }
        Block block = (Block)buf.m_236816_((IdMap)BuiltInRegistries.f_256975_);
        return new BlockOrTag(block);
    }
}

