/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.entity.common.BarracudaPart;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.entity.common.CustomInventoryPose;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Barracuda
extends WaterAnimal
implements JsonVariantHolder,
Catchable,
CustomInventoryPose {
    private static final EntityDataAccessor<Boolean> HAS_BEEN_CAUGHT = SynchedEntityData.m_135353_(Barracuda.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Barracuda.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Barracuda.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean isRenderedInTooltip;
    private final BarracudaPart headPart;
    private final BarracudaPart bodyPart;
    private final BarracudaPart tailPart;
    private final BarracudaPart[] subEntities;
    private static final int TRAIL_SIZE = 8;
    private int trailIndex = 0;
    private final Vec3[] headTrail = new Vec3[8];
    private final float[] yawTrail = new float[8];
    private final float[] pitchTrail = new float[8];

    public Barracuda(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.headPart = new BarracudaPart(this, "head", 0.8f, 0.4f);
        this.bodyPart = new BarracudaPart(this, "body", 0.8f, 0.4f);
        this.tailPart = new BarracudaPart(this, "tail", 0.8f, 0.4f);
        this.subEntities = new BarracudaPart[]{this.headPart, this.bodyPart, this.tailPart};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        for (int i = 0; i < 8; ++i) {
            this.headTrail[i] = this.m_20182_();
            this.yawTrail[i] = this.m_146908_();
            this.pitchTrail[i] = this.m_146909_();
        }
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 20, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public void m_20234_(int i1) {
        super.m_20234_(i1);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(i1 + i + 1);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new BarracudaChargeGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 3.0, 1));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Barracuda.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(HAS_BEEN_CAUGHT, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void saveDataToTag(Mob mob, CompoundTag tag) {
        Catchable.super.saveDataToTag(mob, tag);
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    @Override
    public void loadDataFromTag(Mob mob, CompoundTag tag) {
        Catchable.super.loadDataFromTag(mob, tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.6f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean hurtPart(BarracudaPart part, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        this.trailIndex = (this.trailIndex + 1) % 8;
        this.headTrail[this.trailIndex] = this.m_20182_();
        this.yawTrail[this.trailIndex] = this.m_146908_();
        this.pitchTrail[this.trailIndex] = this.m_146909_();
        this.placeSegmentInterpolated(this.headPart, 0.0f);
        this.placeSegmentInterpolated(this.bodyPart, 3.0f);
        this.placeSegmentInterpolated(this.tailPart, 6.0f);
    }

    private void placeSegmentInterpolated(BarracudaPart part, float delayTicks) {
        float samplePos = ((float)this.trailIndex - delayTicks + 8.0f) % 8.0f;
        int i0 = (int)Math.floor(samplePos);
        int i1 = (i0 + 1) % 8;
        float f = samplePos - (float)i0;
        Vec3 pos = this.headTrail[i0].m_165921_(this.headTrail[i1], (double)f);
        float yaw = Mth.m_14179_((float)f, (float)this.yawTrail[i0], (float)this.yawTrail[i1]);
        float pitch = Mth.m_14179_((float)f, (float)this.pitchTrail[i0], (float)this.pitchTrail[i1]);
        double offset = part == this.headPart ? -0.5 : (part == this.bodyPart ? 0.0 : 0.5);
        double center = (double)this.m_20206_() * 0.35;
        float yawRad = (float)Math.toRadians(yaw);
        float pitchRad = (float)Math.toRadians(pitch);
        double fx = -Math.sin(yawRad) * Math.cos(pitchRad);
        double fy = -Math.sin(pitchRad);
        double fz = Math.cos(yawRad) * Math.cos(pitchRad);
        double x = pos.f_82479_ - fx * offset;
        double y = pos.f_82480_ + center - fy * offset;
        double z = pos.f_82481_ - fz * offset;
        part.setOldPartPos(part.m_20185_(), part.m_20186_(), part.m_20189_(), part.m_146908_(), part.m_146909_());
        part.setPartPos(x, y, z, yaw, pitch);
    }

    public BarracudaPart getHeadPart() {
        return this.headPart;
    }

    public BarracudaPart getBodyPart() {
        return this.bodyPart;
    }

    public BarracudaPart getTailPart() {
        return this.tailPart;
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.FISH_DEATH.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.BIG_FISH_SWIM.get();
    }

    protected @Nullable SoundEvent m_7515_() {
        return SoundEvents.f_271165_;
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.FISH_HURT.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)SpawnSoundEvents.FISH_FLOP.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.65f;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.hasBeenCaught();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.hasBeenCaught() && !this.m_8077_();
    }

    @Override
    public boolean canBeCatched(@Nullable ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasBeenCaught() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BEEN_CAUGHT);
    }

    @Override
    public void setHasBeenCaught(boolean bl) {
        this.f_19804_.m_135381_(HAS_BEEN_CAUGHT, (Object)bl);
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.f_11785_;
    }

    @Override
    public SoundEvent getReleaseSound() {
        return SoundEvents.f_11785_;
    }

    @Override
    public void setVariant(ResourceLocation location) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)location.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "scrap_metal");
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public boolean isHeadCollidingWith(Entity entity, double expand) {
        return this.headPart.m_20191_().m_82400_(expand).m_82381_(entity.m_20191_());
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.02f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Override
    public boolean isRenderedInTooltip() {
        return this.isRenderedInTooltip;
    }

    @Override
    public void setIsRenderedInTooltip(boolean bl) {
        this.isRenderedInTooltip = bl;
    }

    public static class BarracudaChargeGoal
    extends Goal {
        private final Barracuda fish;
        private LivingEntity target;
        private int windupTicks;
        private int chargingTicks;
        private boolean charging;

        public BarracudaChargeGoal(Barracuda fish) {
            this.fish = fish;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.fish.m_5448_();
            if (target == null || !this.fish.m_20069_()) {
                return false;
            }
            double d = this.fish.m_20270_((Entity)target);
            return d > 3.0 && d < 10.0;
        }

        public void m_8056_() {
            this.target = this.fish.m_5448_();
            this.windupTicks = 20;
            this.chargingTicks = 80;
            this.charging = false;
            this.fish.m_21573_().m_26573_();
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && this.chargingTicks > 0;
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, -0.01, 0.0));
            if (this.chargingTicks > 0) {
                --this.chargingTicks;
            }
            if (this.windupTicks > 0) {
                this.fish.m_21563_().m_24960_((Entity)this.target, 60.0f, 30.0f);
                --this.windupTicks;
                return;
            }
            if (this.fish.isHeadCollidingWith((Entity)this.target, 0.2)) {
                this.target.m_6469_(this.fish.m_269291_().m_269333_((LivingEntity)this.fish), 6.0f);
                Vec3 knock = this.fish.m_20184_().m_82490_(0.5);
                this.target.m_5997_(knock.f_82479_, 0.2, knock.f_82481_);
                this.fish.m_5496_((SoundEvent)SpawnSoundEvents.BARRACUDA_ATTACK.get(), 1.0f, 1.0f);
                this.m_8041_();
                return;
            }
            if (!this.charging) {
                this.charging = true;
                Vec3 dir = this.target.m_20182_().m_82546_(this.fish.m_20182_()).m_82541_();
                Vec3 burst = dir.m_82490_(1.8).m_82542_(1.0, 0.8, 1.0);
                for (int i = 0; i < 30; ++i) {
                    Level level = this.fish.m_9236_();
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.fish.m_20182_().f_82479_ + this.fish.f_19796_.m_188583_() * 0.5, this.fish.m_20182_().f_82480_ - 0.5 + this.fish.f_19796_.m_188583_() * 0.5, this.fish.m_20182_().f_82481_ + this.fish.f_19796_.m_188583_() * 0.5, 0, 0.0, 0.0, 0.0, (double)0.1f);
                }
                this.fish.m_5496_((SoundEvent)SpawnSoundEvents.BARRACUDA_CHARGE.get(), (float)(1.0 + dir.m_165925_() / 10.0), 1.0f);
                this.fish.m_20256_(burst);
            }
        }

        public void m_8041_() {
            if ((double)this.fish.f_19796_.m_188501_() < 0.4) {
                this.fish.m_6710_(null);
            }
            this.charging = false;
            this.chargingTicks = 0;
        }
    }
}

