/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.entity.common.CustomInventoryPose;
import com.ninni.spawn.server.entity.variant.ClamVariant;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Clam
extends Mob
implements VariantHolder<ClamVariant.Variant>,
Catchable,
CustomInventoryPose {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Clam.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_BEEN_CAUGHT = SynchedEntityData.m_135353_(Clam.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANCHORED = SynchedEntityData.m_135353_(Clam.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> OPEN_TICKS = SynchedEntityData.m_135353_(Clam.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean isRenderedInTooltip = false;
    public final AnimationState anchoringAnimationState = new AnimationState();
    public final AnimationState openAnimationState = new AnimationState();
    private static final byte EVENT_PLAY_OPEN_ANIMATION = 8;

    public Clam(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_6210_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)1.2f).m_22268_(Attributes.f_22278_, 1.0);
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData spawnGroupData2 = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        if (mobSpawnType != MobSpawnType.BUCKET) {
            RandomSource randomSource = serverLevelAccessor.m_213780_();
            ClamVariant.BaseColor[] baseColors = ClamVariant.BaseColor.values();
            ClamVariant.Pattern[] patterns = ClamVariant.Pattern.values();
            Object[] dyeColors = DyeColor.values();
            if (!serverLevelAccessor.m_204166_(this.m_20183_()).m_203656_(SpawnTags.GIANT_CLAM_SPAWNS) && mobSpawnType != MobSpawnType.MOB_SUMMONED) {
                baseColors = (ClamVariant.BaseColor[])Arrays.stream(ClamVariant.BaseColor.values()).filter(color -> color.base() != ClamVariant.Base.GIANT_CLAM).toArray(ClamVariant.BaseColor[]::new);
            }
            ClamVariant.BaseColor baseColor = (ClamVariant.BaseColor)((Object)Util.m_214670_((Object[])baseColors, (RandomSource)randomSource));
            ClamVariant.Pattern pattern = (ClamVariant.Pattern)((Object)Util.m_214670_((Object[])patterns, (RandomSource)randomSource));
            DyeColor dyeColor = (DyeColor)Util.m_214670_((Object[])dyeColors, (RandomSource)randomSource);
            ClamVariant.Variant variant = new ClamVariant.Variant(baseColor, pattern, dyeColor);
            this.setPackedVariant(variant.getPackedId());
            if (this.isGiantClam(variant)) {
                this.setAnchored(true);
            }
        }
        this.m_6210_();
        return spawnGroupData2;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (player.m_21120_(interactionHand).m_41619_() && interactionHand == InteractionHand.MAIN_HAND) {
            return Catchable.catchWithItem(player, interactionHand, this, null).orElse(super.m_6071_(player, interactionHand));
        }
        return super.m_6071_(player, interactionHand);
    }

    @Override
    public @Nullable ItemStack getCaughtItem(ItemStack capturingStack) {
        return ((Item)SpawnItems.CLAM.get()).m_7968_();
    }

    @Override
    public boolean canBeCatched(@Nullable ItemStack stack) {
        return stack == null || stack.m_41619_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getBaseColor().base() == ClamVariant.Base.WEDGE_SHELL) {
            return super.m_6972_(pose).m_20390_(1.0f, 1.0f);
        }
        if (this.getBaseColor().base() == ClamVariant.Base.SCALLOP) {
            return super.m_6972_(pose).m_20390_(1.8f, 1.0f);
        }
        if (this.isGiantClam(this.getVariant())) {
            return super.m_6972_(pose).m_20390_(3.0f, 4.5f);
        }
        return super.m_6972_(pose);
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public boolean m_5829_() {
        return this.m_6084_() && this.m_20096_();
    }

    public void m_7334_(Entity entity) {
    }

    protected float m_5632_(float f, float g) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isGiantClam(this.getVariant())) {
            Level level;
            BlockPos below = this.m_20183_().m_7495_();
            if (this.m_9236_().m_8055_(below).m_204336_(SpawnTags.GIANT_CLAM_ANCHOR)) {
                if (!this.isAnchored()) {
                    this.setAnchored(true);
                    this.anchoringAnimationState.m_216977_(this.f_19797_);
                }
            } else {
                this.setAnchored(false);
                this.anchoringAnimationState.m_216973_();
            }
            if (this.isAnchored() && this.m_20069_() && this.m_6084_() && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.f_19796_.m_188503_(600) == 0 && this.getOpenTicks() == 0) {
                    this.m_9236_().m_7605_((Entity)this, (byte)8);
                    this.setOpenTicks(120);
                    this.m_5496_((SoundEvent)SpawnSoundEvents.CLAM_BIG_BUBBLES.get(), 1.0f, 1.0f);
                }
                if (this.getOpenTicks() > 0) {
                    this.setOpenTicks(this.getOpenTicks() - 1);
                }
                if (this.getOpenTicks() > 18 && this.getOpenTicks() < 110 && this.f_19796_.m_188501_() < 0.5f && this.m_20069_()) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123774_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.openAnimationState.m_216977_(this.f_19797_);
            return;
        }
        super.m_7822_(id);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        } else {
            super.m_7023_(vec3);
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        this.m_6210_();
        super.m_7350_(entityDataAccessor);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(HAS_BEEN_CAUGHT, (Object)false);
        this.f_19804_.m_135372_(ANCHORED, (Object)false);
        this.f_19804_.m_135372_(OPEN_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("ClamVariant", this.getPackedVariant());
        compoundTag.m_128405_("OpenTicks", this.getOpenTicks());
        compoundTag.m_128379_("HasBeenCaught", this.hasBeenCaught());
        compoundTag.m_128379_("Anchored", this.isAnchored());
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.m_6210_();
        super.m_7378_(compoundTag);
        this.setPackedVariant(compoundTag.m_128451_("ClamVariant"));
        this.setOpenTicks(compoundTag.m_128451_("OpenTicks"));
        this.setHasBeenCaught(compoundTag.m_128471_("HasBeenCaught"));
        this.setAnchored(compoundTag.m_128471_("Anchored"));
    }

    @Override
    public void saveDataToTag(Mob mob, CompoundTag tag) {
        Catchable.super.saveDataToTag(mob, tag);
        tag.m_128405_("ClamVariant", this.getPackedVariant());
    }

    @Override
    public void loadDataFromTag(Mob mob, CompoundTag tag) {
        Catchable.super.loadDataFromTag(mob, tag);
        this.setPackedVariant(tag.m_128451_("ClamVariant"));
    }

    public int getOpenTicks() {
        return (Integer)this.f_19804_.m_135370_(OPEN_TICKS);
    }

    public void setOpenTicks(int ticks) {
        this.f_19804_.m_135381_(OPEN_TICKS, (Object)ticks);
    }

    @Override
    public boolean hasBeenCaught() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BEEN_CAUGHT);
    }

    @Override
    public void setHasBeenCaught(boolean bl) {
        this.f_19804_.m_135381_(HAS_BEEN_CAUGHT, (Object)bl);
    }

    public boolean isAnchored() {
        return (Boolean)this.f_19804_.m_135370_(ANCHORED);
    }

    public void setAnchored(boolean bl) {
        this.f_19804_.m_135381_(ANCHORED, (Object)bl);
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_5842_()) {
            return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_HURT.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_HURT.get();
        }
        return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_HURT_LAND.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_HURT_LAND.get();
    }

    protected @Nullable SoundEvent m_5592_() {
        if (this.m_5842_()) {
            return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_DEATH.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_DEATH.get();
        }
        return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_DEATH_LAND.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_DEATH_LAND.get();
    }

    @Override
    public SoundEvent getPickupSound() {
        if (this.m_5842_()) {
            return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_COLLECT.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_COLLECT.get();
        }
        return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_COLLECT_LAND.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_COLLECT_LAND.get();
    }

    @Override
    public SoundEvent getReleaseSound() {
        if (this.m_9236_().m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_PLACE.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_PLACE.get();
        }
        return this.isGiantClam(this.getVariant()) ? (SoundEvent)SpawnSoundEvents.CLAM_BIG_PLACE_LAND.get() : (SoundEvent)SpawnSoundEvents.CLAM_SMALL_PLACE_LAND.get();
    }

    private boolean isGiantClam(ClamVariant.Variant variant) {
        return variant.baseColor().base() == ClamVariant.Base.GIANT_CLAM;
    }

    public void setPackedVariant(int i) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    public int getPackedVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.hasBeenCaught();
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)SpawnItems.CLAM.get());
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6785_(double d) {
        return !this.hasBeenCaught() && !this.m_8077_();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    public void setVariant(ClamVariant.Variant variant) {
        this.setPackedVariant(Clam.packVariant(variant.baseColor(), variant.pattern(), variant.dyeColor()));
    }

    public ClamVariant.Variant getVariant() {
        return new ClamVariant.Variant(this.getBaseColor(), this.getPattern(), this.getDyeColor());
    }

    public static int packVariant(ClamVariant.BaseColor baseColor, ClamVariant.Pattern pattern, DyeColor dyeColor) {
        return baseColor.getId() << 8 | pattern.getId() << 4 | dyeColor.m_41060_();
    }

    public ClamVariant.BaseColor getBaseColor() {
        return Clam.getBaseColor(this.getPackedVariant());
    }

    public ClamVariant.Pattern getPattern() {
        return Clam.getPattern(this.getPackedVariant());
    }

    public DyeColor getDyeColor() {
        return Clam.getDyeColor(this.getPackedVariant());
    }

    public static ClamVariant.BaseColor getBaseColor(int i) {
        return ClamVariant.BaseColor.byId(i >> 8 & 0xF);
    }

    public static ClamVariant.Pattern getPattern(int i) {
        return ClamVariant.Pattern.byId(i >> 4 & 0xF);
    }

    public static DyeColor getDyeColor(int i) {
        return DyeColor.m_41053_((int)(i & 0xF));
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<Clam> clamEntityType, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        boolean beachSpawn;
        int seaLevel = level.m_5736_();
        int minY = level.m_141937_();
        boolean inRangeUnderwater = pos.m_123342_() >= minY && pos.m_123342_() < seaLevel;
        boolean waterSpawn = inRangeUnderwater && level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7495_()).m_280296_() && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50450_);
        boolean justAboveSea = pos.m_123342_() >= seaLevel && pos.m_123342_() <= seaLevel + 5;
        boolean bl = beachSpawn = justAboveSea && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_280296_() && !level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13047_);
        if (beachSpawn) {
            return true;
        }
        return waterSpawn;
    }

    @Override
    public boolean isRenderedInTooltip() {
        return this.isRenderedInTooltip;
    }

    @Override
    public void setIsRenderedInTooltip(boolean bl) {
        this.isRenderedInTooltip = bl;
    }
}

