/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import com.ninni.spawn.server.entity.common.PathFindingFavors;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.event.ForgeEventFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Seahorse
extends AbstractFish
implements JsonVariantHolder,
PathFindingFavors {
    private static final EntityDataAccessor<Integer> DATA_BASE_COLOR = SynchedEntityData.m_135353_(Seahorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_PATTERN_COLOR = SynchedEntityData.m_135353_(Seahorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Seahorse.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Seahorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Seahorse(EntityType<? extends Seahorse> type, Level world) {
        super(type, world);
        this.f_21342_ = new FishMoveControl(this);
        this.f_21365_ = new LookControl((Mob)this);
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData spawnGroupData2 = super.m_6518_(level, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        RandomSource random = level.m_213780_();
        if (mobSpawnType != MobSpawnType.BUCKET) {
            Drowned drowned;
            if ((double)random.m_188501_() < 0.1 || level.m_204166_(this.m_20183_()).m_203565_(Biomes.f_48166_)) {
                List<DyeColor> naturalBaseColors = Arrays.stream(DyeColor.values()).toList();
                List<DyeColor> naturalPatternColors = Arrays.stream(DyeColor.values()).toList();
                this.setBaseColor((DyeColor)Util.m_214621_(naturalBaseColors, (RandomSource)random));
                this.setPatternColor((DyeColor)Util.m_214621_(naturalPatternColors, (RandomSource)random));
            } else {
                HashMap<DyeColor, DyeColor> patterns = new HashMap<DyeColor, DyeColor>();
                patterns.put(DyeColor.GREEN, DyeColor.LIME);
                patterns.put(DyeColor.LIME, DyeColor.LIME);
                patterns.put(DyeColor.GREEN, DyeColor.GREEN);
                patterns.put(DyeColor.LIME, DyeColor.GREEN);
                patterns.put(DyeColor.BROWN, DyeColor.GREEN);
                patterns.put(DyeColor.BROWN, DyeColor.BROWN);
                patterns.put(DyeColor.GREEN, DyeColor.CYAN);
                patterns.put(DyeColor.WHITE, DyeColor.ORANGE);
                patterns.put(DyeColor.WHITE, DyeColor.LIGHT_BLUE);
                patterns.put(DyeColor.YELLOW, DyeColor.WHITE);
                patterns.put(DyeColor.ORANGE, DyeColor.WHITE);
                patterns.put(DyeColor.ORANGE, DyeColor.YELLOW);
                patterns.put(DyeColor.RED, DyeColor.ORANGE);
                patterns.put(DyeColor.BLACK, DyeColor.RED);
                DyeColor randomBase = (DyeColor)Util.m_214621_(patterns.keySet().stream().toList(), (RandomSource)random);
                this.setBaseColor(randomBase);
                this.setPatternColor((DyeColor)patterns.get(randomBase));
            }
            if (random.m_188501_() < 0.0025f && (drowned = (Drowned)EntityType.f_20562_.m_20615_(this.m_9236_())) != null) {
                drowned.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                drowned.m_6518_(level, difficulty, MobSpawnType.JOCKEY, null, null);
                drowned.m_20329_((Entity)this);
                drowned.m_6863_(true);
                level.m_7967_((Entity)drowned);
            }
            AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        }
        return spawnGroupData2;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        callback.m_20372_(passenger, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.4f) + passenger.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.75, 120));
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 240));
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return this.getDepthPathfindingFavor(blockPos, levelReader);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.65).m_22268_(Attributes.f_22276_, 4.0);
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
        if (ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20457_, timer -> {})) {
            Horse horse = (Horse)EntityType.f_20457_.m_20615_((Level)level);
            if (horse != null) {
                horse.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                horse.m_21557_(this.m_21525_());
                if (this.m_8077_()) {
                    horse.m_6593_(this.m_7770_());
                    horse.m_20340_(this.m_20151_());
                }
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)horse);
                level.m_7967_((Entity)horse);
                horse.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 1, false, false));
                this.m_146870_();
            } else {
                super.m_8038_(level, lightning);
            }
        } else {
            super.m_8038_(level, lightning);
        }
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)SpawnSoundEvents.FISH_FLOP.get();
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.95f;
    }

    public ItemStack m_28282_() {
        return ((Item)SpawnItems.SEAHORSE_BUCKET.get()).m_7968_();
    }

    protected @Nullable SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.SEAHORSE_DEATH.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.FISH_SWIM.get();
    }

    public @Nullable SoundEvent m_7515_() {
        return this.m_5842_() ? (this.f_19796_.m_188503_(3) == 0 ? (SoundEvent)SpawnSoundEvents.SEAHORSE_GROWL.get() : (SoundEvent)SpawnSoundEvents.SEAHORSE_CLICK.get()) : null;
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.SEAHORSE_HURT.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BASE_COLOR, (Object)DyeColor.WHITE.m_41060_());
        this.f_19804_.m_135372_(DATA_PATTERN_COLOR, (Object)DyeColor.WHITE.m_41060_());
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("BaseColor", this.getBaseColor().m_41060_());
        tag.m_128405_("PatternColor", this.getPatternColor().m_41060_());
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128350_("VariantScale", this.getVariantScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("BaseColor", 99)) {
            this.setBaseColor(DyeColor.m_41053_((int)tag.m_128451_("BaseColor")));
        }
        if (tag.m_128425_("PatternColor", 99)) {
            this.setPatternColor(DyeColor.m_41053_((int)tag.m_128451_("PatternColor")));
        }
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("BaseColor", this.getBaseColor().m_41060_());
        tag.m_128405_("PatternColor", this.getPatternColor().m_41060_());
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128350_("VariantScale", this.getVariantScale());
    }

    public void m_142278_(CompoundTag tag) {
        super.m_142278_(tag);
        if (tag.m_128425_("BaseColor", 99)) {
            this.setBaseColor(DyeColor.m_41053_((int)tag.m_128451_("BaseColor")));
        }
        if (tag.m_128425_("PatternColor", 99)) {
            this.setPatternColor(DyeColor.m_41053_((int)tag.m_128451_("PatternColor")));
        }
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    public DyeColor getBaseColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_BASE_COLOR)));
    }

    public void setBaseColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_BASE_COLOR, (Object)color.m_41060_());
    }

    public DyeColor getPatternColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_PATTERN_COLOR)));
    }

    public void setPatternColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_PATTERN_COLOR, (Object)color.m_41060_());
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "tiny/plain");
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    private static class FishMoveControl
    extends MoveControl {
        private final AbstractFish fish;

        FishMoveControl(AbstractFish abstractFish) {
            super((Mob)abstractFish);
            this.fish = abstractFish;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13131_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)f));
                double d = this.f_24975_ - this.fish.m_20185_();
                double e = this.f_24976_ - this.fish.m_20186_();
                double g = this.f_24977_ - this.fish.m_20189_();
                if (e != 0.0) {
                    double h = Math.sqrt(d * d + e * e + g * g);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (e / h) * 0.1, 0.0));
                }
                if (d != 0.0 || g != 0.0) {
                    float i = (float)(Mth.m_14136_((double)g, (double)d) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), i, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }
}

