/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.google.common.collect.Lists;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.block.SnailEggsBlock;
import com.ninni.spawn.server.data.AnimalVariantManager;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Snail
extends Animal
implements JsonVariantHolder {
    private static final EntityDataAccessor<Integer> SCARED_TICKS = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WET_TICKS = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHELL_GROWTH = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final UniformInt regrowthTicks = UniformInt.m_146622_((int)12000, (int)24000);
    private int cooldown = 2;
    public final AnimationState pinchedLeftAnimationState = new AnimationState();
    public final AnimationState pinchedRightAnimationState = new AnimationState();
    public final AnimationState hideAnimationState = new AnimationState();
    public final AnimationState stopHidingAnimationState = new AnimationState();
    public final AnimationState shakeAnimationState = new AnimationState();
    private static final byte EVENT_HIDE = 8;
    private static final byte EVENT_STOP_HIDING = 9;
    private static final byte EVENT_SHAKE = 10;
    private static final byte EVENT_PINCH_LEFT = 11;
    private static final byte EVENT_PINCH_RIGHT = 12;
    private boolean wasScaredLastTick = false;
    private int leftPinchCooldown = 0;
    private int rightPinchCooldown = 0;
    private static final UUID IN_SHELL_ARMOR_MODIFIER_UUID = UUID.fromString("b3d7d6d0-7699-4fa9-833b-55825dc8222f");
    private static final UUID IN_SHELL_KNOCKBACK_MODIFIER_UUID = UUID.fromString("0d3ab4b3-1697-4934-abc5-6c76b2c6a34a");

    public Snail(EntityType<? extends Snail> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpawnTags.SNAIL_FEEDS);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SnailLayEggGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(SpawnTags.SNAIL_TEMPTS), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new SnailWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new SnailLookAtEntityGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new SnailLookAroundGoal(this));
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        AnimalVariantManager.getNaturallyOccurringVariant((LivingEntity)this);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_27563_(ServerLevel world, Animal other) {
        if (other instanceof Snail) {
            Snail otherSnail = (Snail)other;
            ServerPlayer serverPlayerEntity = this.m_27592_();
            if (serverPlayerEntity == null) {
                serverPlayerEntity = otherSnail.m_27592_();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayerEntity, (Animal)this, (Animal)otherSnail, null);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayerEntity, (Animal)otherSnail, (Animal)this, null);
            }
            this.m_146762_(6000);
            otherSnail.m_146762_(6000);
            this.m_27594_();
            otherSnail.m_27594_();
            this.setHasEgg(true);
            otherSnail.setHasEgg(true);
            world.m_7605_((Entity)this, (byte)18);
            if (world.m_46469_().m_46207_(GameRules.f_46135_)) {
                world.m_7967_((Entity)new ExperienceOrb((Level)world, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(7) + 1));
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCARED_TICKS, (Object)0);
        this.f_19804_.m_135372_(WET_TICKS, (Object)0);
        this.f_19804_.m_135372_(SHELL_GROWTH, (Object)0);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ScaredTicks", this.getScaredTicks());
        tag.m_128405_("WetTicks", this.getWetTicks());
        tag.m_128405_("Shelled", this.getShellGrowthTicks());
        tag.m_128379_("HasEgg", this.hasEgg());
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setScaredTicks(tag.m_128451_("ScaredTicks"));
        this.setWetTicks(tag.m_128451_("WetTicks"));
        this.setShellGrowthTicks(tag.m_128451_("Shelled"));
        this.setHasEgg(tag.m_128471_("HasEgg"));
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "podzol");
    }

    public int getScaredTicks() {
        return (Integer)this.f_19804_.m_135370_(SCARED_TICKS);
    }

    public void setScaredTicks(int scaredTicks) {
        boolean isScaredNow;
        boolean wasScared = this.isScared();
        this.f_19804_.m_135381_(SCARED_TICKS, (Object)scaredTicks);
        boolean bl = isScaredNow = scaredTicks > 0;
        if (wasScared != isScaredNow) {
            this.updateShellAttributes(isScaredNow);
        }
    }

    public boolean isScared() {
        return this.getScaredTicks() > 0;
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public int getWetTicks() {
        return (Integer)this.f_19804_.m_135370_(WET_TICKS);
    }

    public void setWetTicks(int wetTicks) {
        this.f_19804_.m_135381_(WET_TICKS, (Object)wetTicks);
    }

    public void addWetTicks(int wetTicks) {
        this.setWetTicks(this.getWetTicks() + wetTicks);
    }

    public int getShellGrowthTicks() {
        return (Integer)this.f_19804_.m_135370_(SHELL_GROWTH);
    }

    public void setShellGrowthTicks(int shellTicks) {
        this.f_19804_.m_135381_(SHELL_GROWTH, (Object)shellTicks);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_21205_().m_41619_() && !this.isScared()) {
            if (this.rightPinchCooldown == 0 && this.leftPinchCooldown == 0) {
                boolean b = this.f_19796_.m_188499_();
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, b ? (byte)11 : 12);
                    this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_PINCH.get(), 1.0f, 1.0f);
                }
                if (b) {
                    this.leftPinchCooldown = 30;
                } else {
                    this.rightPinchCooldown = 30;
                }
                return InteractionResult.SUCCESS;
            }
            if (this.leftPinchCooldown == 0) {
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)11);
                    this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_PINCH.get(), 1.0f, 1.0f);
                }
                this.leftPinchCooldown = 30;
                return InteractionResult.SUCCESS;
            }
            if (this.rightPinchCooldown == 0) {
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)12);
                    this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_PINCH.get(), 1.0f, 1.0f);
                }
                this.rightPinchCooldown = 30;
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_6898_(itemStack) && this.m_146764_() == 0) {
            if (itemStack.m_150930_(Items.f_42400_)) {
                this.m_19998_((ItemLike)Items.f_42399_);
            }
            this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_EAT.get(), 1.0f, 1.0f);
        }
        if (itemStack.m_150930_(Items.f_42447_) && !this.isScared() && this.getWetTicks() < 900) {
            if (!this.m_9236_().f_46443_) {
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42446_.m_7968_());
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(hand, itemstack1);
                }
                this.addWetTicks(300);
                this.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        int shellGrowthTicks;
        List list;
        super.m_8107_();
        if (this.rightPinchCooldown > 0) {
            --this.rightPinchCooldown;
        }
        if (this.leftPinchCooldown > 0) {
            --this.leftPinchCooldown;
        }
        if (this.isScared() && !this.wasScaredLastTick && !this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)8);
        }
        if (this.isScared()) {
            if (this.f_19796_.m_188503_(100) == 0) {
                this.m_9236_().m_7605_((Entity)this, (byte)10);
            }
        } else if (this.wasScaredLastTick && !this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)9);
        }
        this.wasScaredLastTick = this.isScared();
        if (this.getWetTicks() > 0) {
            this.addWetTicks(-1);
            if (this.f_19796_.m_188503_(10) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123804_, this.m_20208_(0.6), this.m_20186_() + this.f_19796_.m_188500_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_20075_().m_204336_(SpawnTags.MUCUS_SOLIDIFIER) || this.m_20070_()) {
            this.addWetTicks(1);
        }
        if (!this.m_9236_().f_46443_ && this.m_20096_() && this.getWetTicks() > 0) {
            BlockState blockState = ((Block)SpawnBlocks.MUCUS.get()).m_49966_();
            for (int l = 0; l < 4; ++l) {
                if (this.cooldown >= 0) continue;
                int i = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockPos2 = new BlockPos(i, Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)(this.m_20189_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.m_9236_().m_8055_(blockPos2).m_60795_() || !blockState.m_60710_((LevelReader)this.m_9236_(), blockPos2)) continue;
                this.m_9236_().m_46597_(blockPos2, blockState);
                this.cooldown = 10;
                this.m_7355_(blockPos2, blockState);
                this.m_9236_().m_220407_(GameEvent.f_157797_, blockPos2, GameEvent.Context.m_223719_((Entity)this, (BlockState)blockState));
            }
            --this.cooldown;
        }
        if (!(list = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82400_(4.0), this::isValidEntity)).isEmpty()) {
            this.setScaredTicks(100);
        }
        if (this.getScaredTicks() > 0) {
            this.m_21573_().m_26573_();
            if (list.isEmpty()) {
                this.setScaredTicks(this.getScaredTicks() - 1);
            }
        }
        if (!this.m_9236_().m_5776_() && (shellGrowthTicks = this.getShellGrowthTicks()) > 0 && !this.m_6162_()) {
            if (shellGrowthTicks == 1) {
                this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_SHELL_GROW.get(), 1.0f, 1.0f);
            }
            this.setShellGrowthTicks(shellGrowthTicks - 1);
        }
    }

    private boolean isValidEntity(Player entity) {
        return this.getShellGrowthTicks() == 0 && !entity.m_5833_() && entity.m_6084_() && !entity.m_150110_().f_35937_ && !entity.m_6144_();
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 8: {
                this.stopHidingAnimationState.m_216973_();
                this.hideAnimationState.m_216977_(this.f_19797_);
                this.m_20124_(Pose.CROUCHING);
                break;
            }
            case 9: {
                this.hideAnimationState.m_216973_();
                this.stopHidingAnimationState.m_216977_(this.f_19797_);
                this.m_20124_(Pose.STANDING);
                break;
            }
            case 10: {
                this.shakeAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 11: {
                this.pinchedLeftAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 12: {
                this.pinchedRightAnimationState.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    private void updateShellAttributes(boolean enteringShell) {
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        AttributeInstance knockback = this.m_21051_(Attributes.f_22278_);
        if (enteringShell) {
            if (armor != null && armor.m_22111_(IN_SHELL_ARMOR_MODIFIER_UUID) == null) {
                armor.m_22125_(new AttributeModifier(IN_SHELL_ARMOR_MODIFIER_UUID, "In shell armor", 20.0, AttributeModifier.Operation.ADDITION));
            }
            if (knockback != null && knockback.m_22111_(IN_SHELL_KNOCKBACK_MODIFIER_UUID) == null) {
                knockback.m_22125_(new AttributeModifier(IN_SHELL_KNOCKBACK_MODIFIER_UUID, "In shell knockback", 1.0, AttributeModifier.Operation.ADDITION));
            }
        } else {
            if (armor != null) {
                armor.m_22120_(IN_SHELL_ARMOR_MODIFIER_UUID);
            }
            if (knockback != null) {
                knockback.m_22120_(IN_SHELL_KNOCKBACK_MODIFIER_UUID);
            }
        }
    }

    public boolean m_6094_() {
        return !this.isScared();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && this.getShellGrowthTicks() == 0) {
            if (source.m_269533_(DamageTypeTags.f_268524_)) {
                if (!this.isScared()) {
                    this.m_5552_(new ItemStack((ItemLike)SpawnItems.SNAIL_SHELL.get()), 0.1f);
                    this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_HURT_HIDDEN.get(), 1.0f, 1.0f);
                    this.setShellGrowthTicks(this.regrowthTicks.m_214085_(this.f_19796_));
                }
                return false;
            }
            if (!this.isScared() && this.getShellGrowthTicks() == 0 && amount < 12.0f) {
                this.setScaredTicks(100);
                this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_HURT_HIDDEN.get(), 1.0f, 1.0f);
                return false;
            }
            this.setScaredTicks(100);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_5829_() {
        return this.isScared();
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isScared()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    protected @Nullable SoundEvent m_7515_() {
        return "Gary".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString())) ? SoundEvents.f_11785_ : super.m_7515_();
    }

    protected @Nullable SoundEvent m_7975_(DamageSource source) {
        return this.isScared() ? (SoundEvent)SpawnSoundEvents.SNAIL_HURT_HIDDEN.get() : (SoundEvent)SpawnSoundEvents.SNAIL_HURT.get();
    }

    protected @Nullable SoundEvent m_5592_() {
        return this.isScared() ? (SoundEvent)SpawnSoundEvents.SNAIL_DEATH_HIDDEN.get() : (SoundEvent)SpawnSoundEvents.SNAIL_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_SLIDE.get(), 0.15f, 1.0f);
    }

    public @Nullable AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static boolean canSpawn(EntityType<Snail> snailEntityEntityType, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && Animal.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public static class SnailLayEggGoal
    extends Goal {
        private final Snail snail;
        private BlockPos layPos;

        SnailLayEggGoal(Snail snail) {
            this.snail = snail;
        }

        public boolean m_8036_() {
            BlockPos layPos = this.getLayPosition();
            if (this.layPos == null && layPos != null) {
                this.layPos = layPos;
            }
            return this.layPos != null && this.snail.hasEgg();
        }

        public boolean m_8045_() {
            return this.layPos != null && this.snail.m_9236_().m_8055_(this.layPos).m_204336_(BlockTags.f_144274_) && this.snail.m_9236_().m_8055_(this.layPos.m_7494_()).m_60795_();
        }

        public void m_8056_() {
            if (this.layPos != null) {
                Vec3 vec3d = Vec3.m_82512_((Vec3i)this.layPos);
                this.snail.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                this.snail.m_21563_().m_24964_(vec3d);
            }
        }

        public void m_8037_() {
            Vec3 vec3d;
            double distance;
            if (this.layPos != null && (distance = (double)Mth.m_14116_((float)((float)this.snail.m_20238_(vec3d = Vec3.m_82512_((Vec3i)this.layPos))))) <= 2.0) {
                this.snail.m_5496_((SoundEvent)SpawnSoundEvents.SNAIL_LAY_EGGS.get(), 1.0f, 1.0f);
                this.snail.m_9236_().m_7731_(this.layPos, (BlockState)((Block)SpawnBlocks.SNAIL_EGGS.get()).m_49966_().m_61124_((Property)SnailEggsBlock.m_153933_((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true)), 2);
                this.snail.setHasEgg(false);
            }
        }

        private @Nullable BlockPos getLayPosition() {
            ArrayList list = Lists.newArrayList();
            int range = 8;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos position = new BlockPos((int)this.snail.m_20185_() + x, (int)this.snail.m_20186_(), (int)this.snail.m_20189_() + z);
                    if (!this.snail.m_9236_().m_8055_(position.m_7495_()).m_204336_(BlockTags.f_144274_) || !this.snail.m_9236_().m_8055_(position).m_60795_()) continue;
                    list.add(position);
                }
            }
            if (list.isEmpty()) {
                return null;
            }
            return (BlockPos)list.get(this.snail.f_19796_.m_188503_(list.size()));
        }
    }

    public static class SnailWanderGoal
    extends WaterAvoidingRandomStrollGoal {
        private final Snail mob;

        public SnailWanderGoal(Snail mob, double d) {
            super((PathfinderMob)mob, d);
            this.mob = mob;
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isScared();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isScared();
        }
    }

    public static class SnailLookAtEntityGoal
    extends LookAtPlayerGoal {
        private final Snail mob;

        public SnailLookAtEntityGoal(Snail mob, Class<? extends LivingEntity> targetType, float range) {
            super((Mob)mob, targetType, range);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isScared();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isScared();
        }
    }

    public static class SnailLookAroundGoal
    extends RandomLookAroundGoal {
        private final Snail mob;

        public SnailLookAroundGoal(Snail mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.isScared();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.mob.isScared();
        }
    }
}

