/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.entity.common.DancesToJukebox;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class Stickbug
extends Animal
implements JsonVariantHolder,
TraceableEntity,
DancesToJukebox {
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Stickbug.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Stickbug.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(Stickbug.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> DATA_LOOKING_AROUND = SynchedEntityData.m_135353_(Stickbug.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DANCING = SynchedEntityData.m_135353_(Stickbug.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_HIDING_COOLDOWN = SynchedEntityData.m_135353_(Stickbug.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int pickupDelay;
    @Nullable
    private UUID thrower;
    @Nullable
    private UUID target;
    public final float bobOffs;
    public final AnimationState lookOutAnimationState = new AnimationState();
    public final AnimationState danceAnimationState = new AnimationState();
    private int danceAnimationTimeout = 0;
    private static final byte EVENT_LOOK_OUT = 8;
    private static final byte EVENT_STOP_LOOK_OUT = 9;
    private BlockPos jukeboxPosition;

    public Stickbug(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.bobOffs = this.f_19796_.m_188501_() * (float)Math.PI * 2.0f;
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        this.m_274367_(1.0f);
        this.setDefaultPickUpDelay();
    }

    protected Stickbug(Level level, double posX, double posY, double posZ, @Nullable ItemStack itemStack) {
        this(level, posX, posY, posZ, itemStack, level.f_46441_.m_188500_() * 0.2 - 0.1, 0.2, level.f_46441_.m_188500_() * 0.2 - 0.1);
    }

    protected Stickbug(Player player, @Nullable ItemStack itemStack) {
        this(player.m_9236_(), player.m_20185_(), player.m_20188_() - (double)0.3f, player.m_20189_(), itemStack);
    }

    protected Stickbug(Level level, double posX, double posY, double posZ, @Nullable ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        this((EntityType<? extends Animal>)((EntityType)SpawnEntityType.STICKBUG.get()), level);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(deltaX, deltaY, deltaZ);
        this.setItem(new ItemStack((ItemLike)Items.f_42398_));
        this.setHidingCooldown(6000);
        if (itemStack != null) {
            this.loadFromItem(itemStack);
        }
    }

    public static Stickbug createStickbug(Player player, @Nullable ItemStack itemStack) {
        return new Stickbug(player, itemStack);
    }

    public static Stickbug createStickbug(Level level, double posX, double posY, double posZ, @Nullable ItemStack itemStack) {
        return new Stickbug(level, posX, posY, posZ, itemStack);
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 8: {
                this.lookOutAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 9: {
                this.lookOutAnimationState.m_216973_();
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.2, 1.6, p -> this.getItem().m_41619_() && !(p instanceof Stickbug) && !p.m_21093_(this::m_6898_)));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this, 30));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)SpawnEntityType.STICKBUG.get()).m_20615_((Level)level);
    }

    public ItemStack turnIntoItem() {
        ItemStack stack = new ItemStack((ItemLike)SpawnItems.SUSPICIOUS_STICK.get());
        CompoundTag tag = new CompoundTag();
        if (this.m_6162_()) {
            tag.m_128405_("Age", this.m_146764_());
        }
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    private void loadFromItem(ItemStack itemStack) {
        if (itemStack.m_41788_()) {
            this.m_6593_(itemStack.m_41786_());
        }
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("Age")) {
            this.m_146762_(itemStack.m_41783_().m_128451_("Age"));
        }
    }

    public void hide() {
        this.setItem(Items.f_42398_.m_7968_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42398_.m_7968_()), this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 10, 0.2, 0.1, 0.2, 0.02);
        }
        this.m_5496_((SoundEvent)SpawnSoundEvents.STICKBUG_TRANSFORM.get(), 0.6f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
        this.setPickUpDelay(20);
        this.setHidingCooldown((20 + this.f_19796_.m_188503_(40)) * 20);
    }

    public void stopHiding(@Nullable Vec3 jump, boolean scared) {
        this.setItem(ItemStack.f_41583_);
        if (jump != null) {
            Vec3 away = this.m_20182_().m_82546_(jump).m_82541_().m_82490_(0.5);
            this.m_20256_(this.m_20184_().m_82520_(away.f_82479_, 0.15, away.f_82481_));
        }
        this.f_19812_ = true;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42398_.m_7968_()), this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 10, 0.2, 0.1, 0.2, 0.02);
        }
        this.m_5496_((SoundEvent)SpawnSoundEvents.STICKBUG_TRANSFORM.get(), 0.6f, 0.9f + this.f_19796_.m_188501_() * 0.2f);
        if (scared) {
            this.m_216990_((SoundEvent)SpawnSoundEvents.STICKBUG_SCARED.get());
        }
        this.f_19794_ = false;
        this.setPickUpDelay(40);
        this.setHidingCooldown((2 + this.f_19796_.m_188503_(5)) * 60 * 20);
    }

    public void m_8119_() {
        if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
            --this.pickupDelay;
        }
        if (this.getHidingCooldown() > 0) {
            this.setHidingCooldown(this.getHidingCooldown() - 1);
        } else if (!this.isDancing() && !this.isLookingAround()) {
            if (this.getItem().m_41619_()) {
                this.hide();
            } else {
                this.stopHiding(null, false);
            }
        }
        if (!this.getItem().m_41619_()) {
            this.m_6075_();
            this.itemTick();
            return;
        }
        if (this.jukeboxPosition == null || !this.jukeboxPosition.m_203195_((Position)this.m_20182_(), 15.0) || !this.m_9236_().m_8055_(this.jukeboxPosition).m_60713_(Blocks.f_50131_)) {
            this.setDancing(false);
            this.jukeboxPosition = null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.isDancing() || this.m_9236_().m_46758_(this.m_20183_())) {
                if (this.danceAnimationTimeout <= 0) {
                    this.danceAnimationTimeout = 19;
                    this.danceAnimationState.m_216977_(this.f_19797_);
                } else {
                    --this.danceAnimationTimeout;
                }
            } else if (this.danceAnimationState.m_216984_()) {
                this.danceAnimationState.m_216973_();
            }
        }
        if (this.m_20068_()) {
            this.m_20242_(false);
        }
        super.m_8119_();
    }

    private void itemTick() {
        Player near;
        double dd;
        ItemEntity fakeItem;
        HopperBlockEntity hopperBlockEntity;
        this.m_20242_(true);
        BlockEntity blockEntity = this.m_9236_().m_7702_(this.m_20099_());
        if (blockEntity instanceof HopperBlockEntity && HopperBlockEntity.m_59331_((Container)(hopperBlockEntity = (HopperBlockEntity)blockEntity), (ItemEntity)(fakeItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.turnIntoItem())))) {
            this.m_146870_();
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 prev = this.m_20184_();
        float f = this.m_20192_() - 0.11111111f;
        FluidType fluidType = this.getMaxHeightFluidType();
        if (!fluidType.isAir() && !fluidType.isVanilla() && this.getFluidTypeHeight(fluidType) > (double)f) {
            Vec3 m = this.m_20184_();
            this.m_20334_(m.f_82479_ * (double)0.99f, m.f_82480_ + (double)(m.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), m.f_82481_ * (double)0.99f);
        } else if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > (double)f) {
            this.setUnderwaterMovement();
        } else if (this.m_20077_() && this.m_204036_(FluidTags.f_13132_) > (double)f) {
            this.setUnderLavaMovement();
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        if (this.m_9236_().f_46443_) {
            this.f_19794_ = false;
        } else {
            boolean bl = this.f_19794_ = !this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82406_(1.0E-7));
            if (this.f_19794_) {
                this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
            }
        }
        if (!this.m_20096_() || this.m_20184_().m_165925_() > 1.0E-5 || (this.f_19797_ + this.m_19879_()) % 4 == 0) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            float f1 = 0.98f;
            if (this.m_20096_()) {
                BlockPos groundPos = this.m_20099_();
                f1 = this.m_9236_().m_8055_(groundPos).getFriction((LevelReader)this.m_9236_(), groundPos, (Entity)this) * 0.98f;
            }
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.98, (double)f1));
            if (this.m_20096_()) {
                Vec3 v = this.m_20184_();
                if (v.f_82480_ < 0.0) {
                    this.m_20256_(v.m_82542_(1.0, -0.5, 1.0));
                }
            }
        }
        if (this.f_146733_ != Short.MIN_VALUE) {
            ++this.f_146733_;
        }
        this.f_19812_ |= this.m_20073_();
        if (!this.m_9236_().f_46443_ && (dd = this.m_20184_().m_82546_(prev).m_82556_()) > 0.01) {
            this.f_19812_ = true;
        }
        if (!(this.m_9236_().f_46443_ || this.hasPickUpDelay() || (near = this.m_9236_().m_45930_((Entity)this, 3.0)) == null || !near.m_6084_() || near.m_5833_() || near.m_6047_() || near.m_7500_())) {
            if (near instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)near;
                SpawnCriteriaTriggers.DISCOVER_STICKBUG.trigger(serverPlayer);
            }
            this.stopHiding(near.m_20182_(), true);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(SpawnTags.STICKBUG_FEEDS);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_ITEM, (Object)Items.f_42398_.m_7968_());
        this.f_19804_.m_135372_(DATA_LOOKING_AROUND, (Object)false);
        this.f_19804_.m_135372_(DATA_DANCING, (Object)false);
        this.f_19804_.m_135372_(DATA_HIDING_COOLDOWN, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Variant", this.getVariant().toString());
        if (this.getVariantScale() != 1.0f) {
            tag.m_128350_("VariantScale", this.getVariantScale());
        }
        if (!this.getItem().m_41619_()) {
            tag.m_128365_("Item", (Tag)this.getItem().m_41739_(new CompoundTag()));
        }
        tag.m_128376_("Age", (short)this.f_146733_);
        tag.m_128405_("HidingCooldown", this.getHidingCooldown());
        tag.m_128376_("PickupDelay", (short)this.pickupDelay);
        tag.m_128379_("LookingAround", this.isLookingAround());
        tag.m_128379_("Dancing", this.isDancing());
        if (this.thrower != null) {
            tag.m_128362_("Thrower", this.thrower);
        }
        if (this.target != null) {
            tag.m_128362_("Owner", this.target);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadOrAssignVariant((Mob)this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
        if (tag.m_128441_("PickupDelay")) {
            this.pickupDelay = tag.m_128448_("PickupDelay");
        }
        if (tag.m_128403_("Owner")) {
            this.target = tag.m_128342_("Owner");
        }
        if (tag.m_128403_("Thrower")) {
            this.thrower = tag.m_128342_("Thrower");
        }
        this.setItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item")));
        this.setLookingAround(tag.m_128471_("LookingAround"));
        this.setDancing(tag.m_128471_("Dancing"));
        this.setHidingCooldown(tag.m_128451_("HidingCooldown"));
    }

    public int getHidingCooldown() {
        return (Integer)this.m_20088_().m_135370_(DATA_HIDING_COOLDOWN);
    }

    public void setHidingCooldown(int cooldown) {
        this.m_20088_().m_135381_(DATA_HIDING_COOLDOWN, (Object)cooldown);
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.m_20088_().m_135381_(DATA_ITEM, (Object)stack);
    }

    public boolean isLookingAround() {
        return (Boolean)this.m_20088_().m_135370_(DATA_LOOKING_AROUND);
    }

    public void setLookingAround(boolean b) {
        this.m_20088_().m_135381_(DATA_LOOKING_AROUND, (Object)b);
    }

    public boolean isDancing() {
        return (Boolean)this.m_20088_().m_135370_(DATA_DANCING);
    }

    @Override
    public void setDancing(boolean b) {
        this.m_20088_().m_135381_(DATA_DANCING, (Object)b);
    }

    @Override
    public void setJukeboxPos(BlockPos pos) {
        this.jukeboxPosition = pos;
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "oak");
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt;
        if (source.m_276093_(DamageTypes.f_268585_)) {
            this.m_146870_();
        }
        if (hurt = super.m_6469_(source, amount)) {
            this.setDancing(false);
            this.jukeboxPosition = null;
        }
        return hurt;
    }

    protected BlockPos m_20099_() {
        return this.m_216986_(0.999999f);
    }

    private void setUnderwaterMovement() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
    }

    private void setUnderLavaMovement() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }

    @Nullable
    public Entity m_19749_() {
        Level level;
        if (this.thrower != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            return serverlevel.m_8791_(this.thrower);
        }
        return null;
    }

    public void setTarget(@Nullable UUID target) {
        this.target = target;
    }

    public void setThrower(@Nullable UUID thrower) {
        this.thrower = thrower;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public float getSpin(float partialTicks) {
        return ((float)this.f_19797_ + partialTicks) / 20.0f + this.bobOffs;
    }

    public float m_213816_() {
        if (!this.getItem().m_41619_()) {
            return 180.0f - this.getSpin(0.5f) / ((float)Math.PI * 2) * 360.0f;
        }
        return super.m_213816_();
    }

    public boolean m_6097_() {
        return this.getItem().m_41619_();
    }

    public void m_6123_(Player player) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.pickupDelay > 0) {
            return;
        }
        if (this.isDancing()) {
            return;
        }
        if (player.m_6047_() && this.getItem().m_41619_()) {
            return;
        }
        if (this.target == null || this.target.equals(player.m_20148_())) {
            ItemStack stack = this.turnIntoItem();
            ItemEntity fake = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), stack);
            fake.m_32061_();
            if (this.thrower != null) {
                fake.m_32052_(this.thrower);
            }
            if (this.target != null) {
                fake.m_266426_(this.target);
            }
            this.m_9236_().m_7967_((Entity)fake);
            fake.m_6123_(player);
            this.m_146870_();
        }
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (this.getItem().m_41619_()) {
            super.m_7840_(y, onGround, state, pos);
        } else {
            this.m_183634_();
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        if (!this.getItem().m_41619_()) {
            return false;
        }
        return super.m_142535_(fallDistance, damageMultiplier, source);
    }

    public boolean m_5843_() {
        return super.m_5843_() && this.getItem().m_41619_();
    }

    protected void m_21229_() {
        if (this.getItem().m_41619_()) {
            super.m_21229_();
        }
    }

    public void m_5997_(double x, double y, double z) {
        if (this.getItem().m_41619_()) {
            super.m_5997_(x, y, z);
        }
    }

    protected void m_6138_() {
        if (this.getItem().m_41619_()) {
            super.m_6138_();
        }
    }

    public void m_7334_(Entity entity) {
        if (this.getItem().m_41619_()) {
            super.m_7334_(entity);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isLookingAround() || this.isDancing()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            travelVector = travelVector.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(travelVector);
    }

    public void m_6818_(BlockPos pos, boolean playing) {
        this.playDiscClient(this.m_19879_(), pos, playing);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.getItem().m_41619_() ? (SoundEvent)SpawnSoundEvents.STICKBUG_AMBIENT.get() : null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.STICKBUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.STICKBUG_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.getItem().m_41619_()) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.STICKBUG_STEP.get(), 0.15f, 1.0f);
        }
    }

    public static class LookAroundGoal
    extends Goal {
        public Stickbug stickbug;
        public int timer;
        public int duration;

        public LookAroundGoal(Stickbug stickbug, int duration) {
            this.stickbug = stickbug;
            this.duration = duration;
        }

        public boolean m_8036_() {
            return !this.stickbug.hasPickUpDelay() && !this.stickbug.isDancing() && !this.stickbug.isLookingAround() && this.stickbug.m_21214_() == null && this.stickbug.m_6084_() && this.stickbug.getItem().m_41619_() && this.stickbug.m_217043_().m_188501_() < 0.01f && this.stickbug.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.timer = this.duration;
            this.stickbug.m_21573_().m_26573_();
            this.stickbug.m_9236_().m_7605_((Entity)this.stickbug, (byte)8);
            this.stickbug.setLookingAround(true);
        }

        public boolean m_8045_() {
            return this.timer > 0 && this.stickbug.m_21214_() == null && this.stickbug.m_6084_() && this.stickbug.getItem().m_41619_() && !this.stickbug.isDancing();
        }

        public void m_8037_() {
            --this.timer;
        }

        public void m_8041_() {
            this.stickbug.m_9236_().m_7605_((Entity)this.stickbug, (byte)9);
            this.stickbug.setLookingAround(false);
        }
    }
}

