/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity;

import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.entity.Tuna;
import com.ninni.spawn.server.entity.common.JsonVariantHolder;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TunaEgg
extends Mob
implements Bucketable,
JsonVariantHolder {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TunaEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HATCH_TICKS = SynchedEntityData.m_135353_(TunaEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(TunaEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(TunaEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public long lastHit;

    public TunaEgg(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        long l = this.m_9236_().m_46467_();
        boolean bl = damageSource.m_7640_() instanceof AbstractArrow;
        if (l - this.lastHit <= 5L || bl) {
            this.broken();
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)32);
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
            this.m_216990_((SoundEvent)SpawnSoundEvents.TUNA_EGG_HIT.get());
            this.lastHit = l;
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(HATCH_TICKS, (Object)6000);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)this.getDefaultVariant().toString());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean bl) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)bl);
    }

    public int getHatchTicks() {
        return (Integer)this.f_19804_.m_135370_(HATCH_TICKS);
    }

    public void setHatchTicks(int hatchTicks) {
        this.f_19804_.m_135381_(HATCH_TICKS, (Object)hatchTicks);
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("FromBucket", this.m_27487_());
        tag.m_128405_("HatchTicks", this.getHatchTicks());
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128350_("VariantScale", this.getVariantScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_27497_(tag.m_128471_("FromBucket"));
        this.setHatchTicks(tag.m_128451_("HatchTicks"));
        this.loadOrAssignVariant(this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    protected void handleAirSupply(int i) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(i - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.broken();
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public void m_8107_() {
        Level level;
        super.m_8107_();
        if (this.getHatchTicks() > 0) {
            this.setHatchTicks(this.getHatchTicks() - 1);
        }
        if (this.getHatchTicks() == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.hatch(serverLevel);
        }
    }

    public void broken() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpawnSoundEvents.TUNA_EGG_BROKEN.get(), this.m_5720_(), 1.0f, 1.0f);
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)SpawnParticles.TUNA_EGG.get()), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 10, (double)this.m_20205_(), (double)this.m_20206_(), (double)this.m_20205_(), 0.5);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        Optional interactionResult = Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this);
        if (interactionResult.isPresent() && ((InteractionResult)interactionResult.get()).m_19077_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpawnCriteriaTriggers.CATCH_BABY_MOB.trigger(serverPlayer);
            }
            return (InteractionResult)interactionResult.get();
        }
        return super.m_6071_(player, interactionHand);
    }

    public void hatch(ServerLevel level) {
        Tuna tuna = (Tuna)((EntityType)SpawnEntityType.TUNA.get()).m_20615_((Level)level);
        assert (tuna != null);
        tuna.m_6863_(true);
        tuna.setVariant(this.getVariant());
        tuna.setVariantScale(this.getVariantScale());
        tuna.m_6593_(this.m_7770_());
        tuna.m_21530_();
        tuna.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        level.m_7967_((Entity)tuna);
        this.broken();
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        this.loadOrAssignVariant(this, tag, "Variant");
        if (tag.m_128441_("VariantScale")) {
            this.setVariantScale(tag.m_128457_("VariantScale"));
        }
    }

    public void m_6872_(ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("HatchTicks", this.getHatchTicks());
        tag.m_128359_("Variant", this.getVariant().toString());
        tag.m_128350_("VariantScale", this.getVariantScale());
    }

    @Override
    public void setVariant(ResourceLocation resourceLocation) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)resourceLocation.toString());
    }

    @Override
    public ResourceLocation getVariant() {
        return ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(DATA_VARIANT)));
    }

    @Override
    public ResourceLocation getDefaultVariant() {
        return new ResourceLocation("spawn", "bluefin");
    }

    @Override
    public void setVariantScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    @Override
    public float getVariantScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    protected @Nullable SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.TUNA_EGG_HIT.get();
    }

    public SoundEvent m_142623_() {
        return (SoundEvent)SpawnSoundEvents.BUCKET_FILL_TUNA_EGG.get();
    }

    public ItemStack m_28282_() {
        return ((Item)SpawnItems.TUNA_EGG_BUCKET.get()).m_7968_();
    }
}

