/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity.ai.goal;

import com.ninni.spawn.server.entity.common.BoidFishEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class BoidFishSchoolingGoal
extends Goal {
    public final float separationInfluence;
    public final float separationRange;
    public final float alignmentInfluence;
    public final float cohesionInfluence;
    private final BoidFishEntity mob;
    private int timer = 0;

    public BoidFishSchoolingGoal(BoidFishEntity mob, float separationInfluence, float separationRange, float alignmentInfluence, float cohesionInfluence) {
        this.mob = mob;
        this.separationInfluence = separationInfluence;
        this.separationRange = separationRange;
        this.alignmentInfluence = alignmentInfluence;
        this.cohesionInfluence = cohesionInfluence;
    }

    public boolean m_8036_() {
        return this.mob.m_20072_() && (this.mob.isFollower() || this.mob.hasFollowers()) && this.mob.cantFollowTimer == 0;
    }

    public void m_8037_() {
        if (this.mob.f_19862_) {
            ++this.timer;
            if (this.timer > 60) {
                this.mob.cantFollowTimer = 60;
                this.timer = 0;
            }
        } else {
            this.timer = 0;
        }
        this.mob.m_246865_(this.random());
        this.mob.m_246865_(this.separation());
        this.mob.m_246865_(this.cohesion());
        this.mob.m_246865_(this.alignment());
    }

    public Vec3 random() {
        Vec3 velocity = this.mob.m_20184_();
        if ((double)Mth.m_14154_((float)((float)velocity.f_82479_)) < 0.1 && (double)Mth.m_14154_((float)((float)velocity.f_82481_)) < 0.1 && this.mob.hasFollowers()) {
            return new Vec3((double)this.randomSign() * 0.4, 0.0, (double)this.randomSign() * 0.4);
        }
        return Vec3.f_82478_;
    }

    public int randomSign() {
        return this.mob.m_217043_().m_188499_() ? -1 : 1;
    }

    public Vec3 separation() {
        Vec3 c = Vec3.f_82478_;
        for (BoidFishEntity nearbyMob : this.mob.ownSchool) {
            if (!(nearbyMob.m_20182_().m_82546_(this.mob.m_20182_()).m_82553_() < (double)this.separationRange) || nearbyMob.m_21224_()) continue;
            c = c.m_82546_(nearbyMob.m_20182_().m_82546_(this.mob.m_20182_()));
        }
        if (this.mob.isFollower()) {
            for (BoidFishEntity nearbyMob : this.mob.leader.ownSchool) {
                if (!(nearbyMob.m_20182_().m_82546_(this.mob.m_20182_()).m_82553_() < (double)this.separationRange) || nearbyMob.m_21224_()) continue;
                c = c.m_82546_(nearbyMob.m_20182_().m_82546_(this.mob.m_20182_()));
            }
        }
        return c.m_82490_((double)this.separationInfluence);
    }

    public Vec3 alignment() {
        Vec3 c = Vec3.f_82478_;
        for (BoidFishEntity nearbyMob : this.mob.ownSchool) {
            if (!nearbyMob.m_21224_()) {
                c = c.m_82549_(nearbyMob.m_20184_());
            }
            c = c.m_82490_((double)(1.0f / (float)this.mob.ownSchool.size()));
        }
        if (this.mob.isFollower()) {
            for (BoidFishEntity nearbyMob : this.mob.leader.ownSchool) {
                if (nearbyMob.m_21224_()) continue;
                c = c.m_82549_(nearbyMob.m_20184_());
            }
            c = c.m_82490_((double)(1.0f / (float)this.mob.leader.ownSchool.size()));
        }
        c = c.m_82546_(this.mob.m_20184_());
        return c.m_82490_((double)this.alignmentInfluence);
    }

    public Vec3 cohesion() {
        Vec3 c = Vec3.f_82478_;
        for (BoidFishEntity nearbyMob : this.mob.ownSchool) {
            if (!nearbyMob.m_21224_()) {
                c = c.m_82549_(nearbyMob.m_20182_());
            }
            c = c.m_82490_((double)(1.0f / (float)this.mob.ownSchool.size()));
        }
        if (this.mob.isFollower()) {
            for (BoidFishEntity nearbyMob : this.mob.leader.ownSchool) {
                if (nearbyMob.m_21224_()) continue;
                c = c.m_82549_(nearbyMob.m_20182_());
            }
            c = c.m_82490_((double)(1.0f / (float)this.mob.leader.ownSchool.size()));
        }
        c = c.m_82546_(this.mob.m_20182_());
        return c.m_82490_((double)this.cohesionInfluence);
    }
}

