/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BoidFishEntity
extends AbstractFish {
    public @Nullable BoidFishEntity leader;
    public List<BoidFishEntity> ownSchool = new ArrayList<BoidFishEntity>();
    private int maxSchoolSize;
    public int cantFollowTimer;

    public BoidFishEntity(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    public @Nullable SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (spawnData == null) {
            return new SchoolSpawnGroupData(this);
        }
        BoidFishEntity leader = ((SchoolSpawnGroupData)spawnData).leader;
        if (leader != null && leader.m_6084_() && leader.canBeFollowed()) {
            this.startFollowing(leader);
        }
        return spawnData;
    }

    public int getMaxSchoolSize() {
        return this.maxSchoolSize;
    }

    public void SetMaxSchoolSize(int i) {
        this.maxSchoolSize = i;
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public void startFollowing(BoidFishEntity abstractSchoolingFish) {
        if (this.cantFollowTimer == 0) {
            this.leader = abstractSchoolingFish;
            abstractSchoolingFish.addToOwnSchoolFollower(this);
        }
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollowerFromOwnSchool(this);
            this.leader = null;
        }
    }

    protected SoundEvent m_5501_() {
        return this.isFollower() || this.hasFollowers() ? (this.f_19796_.m_188503_(this.isFollower() ? this.leader.ownSchool.size() : this.ownSchool.size()) == 0 ? super.m_5501_() : SoundEvents.f_271165_) : super.m_5501_();
    }

    private void addToOwnSchoolFollower(BoidFishEntity entity) {
        if (entity.cantFollowTimer == 0) {
            this.ownSchool.add(entity);
        }
    }

    private void removeFollowerFromOwnSchool(BoidFishEntity entity) {
        this.ownSchool.remove((Object)entity);
    }

    public boolean canBeFollowed() {
        return !this.isFollower() && this.ownSchool.size() < this.getMaxSchoolSize() && this.cantFollowTimer == 0;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.cantFollowTimer > 0) {
            --this.cantFollowTimer;
            this.stopFollowing();
        }
    }

    public boolean hasFollowers() {
        return !this.ownSchool.isEmpty();
    }

    public void addFollowers(Stream<? extends BoidFishEntity> stream) {
        stream.limit(this.getMaxSchoolSize() - this.ownSchool.size()).filter(boidFish -> boidFish != this).forEach(boidFish -> boidFish.startFollowing(this));
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 400.0;
    }

    public static class SchoolSpawnGroupData
    implements SpawnGroupData {
        public final BoidFishEntity leader;

        public SchoolSpawnGroupData(BoidFishEntity leader) {
            this.leader = leader;
        }
    }

    public static class FishSwimGoal
    extends RandomSwimmingGoal {
        private final BoidFishEntity fish;

        public FishSwimGoal(BoidFishEntity boidFish) {
            super((PathfinderMob)boidFish, 1.0, 120);
            this.fish = boidFish;
        }

        public boolean m_8036_() {
            return !this.fish.isFollower() && !this.fish.hasFollowers() && super.m_8036_();
        }
    }
}

