/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.entity.variant;

import com.ninni.spawn.server.entity.Clam;
import java.util.function.IntFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.item.DyeColor;

public class ClamVariant {

    public static enum Base {
        WEDGE_SHELL(0, "wedge_shell"),
        SCALLOP(1, "scallop"),
        GIANT_CLAM(2, "giant_clam");

        final int id;
        private final String name;

        private Base(int j, String name) {
            this.id = j;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum BaseColor {
        WBLUE(0, Base.WEDGE_SHELL, "blue", 10468813),
        WBROWN(1, Base.WEDGE_SHELL, "brown", 12750447),
        WPURPLE(2, Base.WEDGE_SHELL, "purple", 16246271),
        WYELLOW(3, Base.WEDGE_SHELL, "yellow", 14863006),
        SPURPLE(4, Base.SCALLOP, "purple", 8352673),
        SRED(5, Base.SCALLOP, "red", 11626611),
        SWHITE(6, Base.SCALLOP, "white", 16177364),
        SYELLOW(7, Base.SCALLOP, "yellow", 14593673),
        GCYAN(8, Base.GIANT_CLAM, "cyan", 55807),
        GGREEN(9, Base.GIANT_CLAM, "green", 7588118),
        GORANGE(10, Base.GIANT_CLAM, "orange", 16684863),
        GPURPLE(11, Base.GIANT_CLAM, "purple", 9580031);

        private static final IntFunction<BaseColor> BY_ID;
        final int id;
        final Base base;
        private final String name;
        private final int textColor;

        private BaseColor(int j, Base base, String name, int textColor) {
            this.id = j;
            this.name = name;
            this.base = base;
            this.textColor = textColor;
        }

        public int getTextColor() {
            return this.textColor;
        }

        public int getId() {
            return this.id;
        }

        public Base base() {
            return this.base;
        }

        public String baseName() {
            return this.base.name;
        }

        public String colorName() {
            return this.name;
        }

        public static BaseColor byId(int i) {
            return BY_ID.apply(i);
        }

        public Component colorDisplayName() {
            return Component.m_237115_((String)("entity.spawn.clam.color." + this.name));
        }

        public Component baseDisplayName() {
            return Component.m_237115_((String)("entity.spawn.clam.base." + this.base.name));
        }

        static {
            BY_ID = ByIdMap.m_262845_(BaseColor::getId, (Object[])BaseColor.values(), (Object)((Object)WBLUE));
        }
    }

    public static enum Pattern {
        NO_PATTERN(0, "no_pattern"),
        STRIPED(1, "striped"),
        DOTTED(2, "dotted"),
        TILED(3, "tiled"),
        RIDGED(4, "ridged");

        private static final IntFunction<Pattern> BY_ID;
        final int id;
        private final String name;

        private Pattern(int j, String name) {
            this.id = j;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String patternName() {
            return this.name;
        }

        public static Pattern byId(int i) {
            return BY_ID.apply(i);
        }

        public Component patternDisplayName() {
            return Component.m_237115_((String)("entity.spawn.clam.pattern." + this.name));
        }

        static {
            BY_ID = ByIdMap.m_262845_(Pattern::getId, (Object[])Pattern.values(), (Object)((Object)NO_PATTERN));
        }
    }

    public record Variant(BaseColor baseColor, Pattern pattern, DyeColor dyeColor) {
        public int getPackedId() {
            return Clam.packVariant(this.baseColor, this.pattern, this.dyeColor);
        }
    }
}

