/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.events;

import com.ninni.spawn.Spawn;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnTags;
import com.ninni.spawn.server.block.state.behaviors.MorayCreviceDispenserBehavior;
import com.ninni.spawn.server.entity.AnglerFish;
import com.ninni.spawn.server.entity.Ant;
import com.ninni.spawn.server.entity.Barracuda;
import com.ninni.spawn.server.entity.Clam;
import com.ninni.spawn.server.entity.Hamster;
import com.ninni.spawn.server.entity.Herring;
import com.ninni.spawn.server.entity.Octopus;
import com.ninni.spawn.server.entity.SeaCow;
import com.ninni.spawn.server.entity.Seahorse;
import com.ninni.spawn.server.entity.Snail;
import com.ninni.spawn.server.entity.Stickbug;
import com.ninni.spawn.server.entity.Sunfish;
import com.ninni.spawn.server.entity.Tuna;
import com.ninni.spawn.server.entity.TunaEgg;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="spawn", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEvents {
    DispenseItemBehavior dispenseBucket = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource p_123561_, ItemStack p_123562_) {
            DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)p_123562_.m_41720_();
            BlockPos blockpos = p_123561_.m_7961_().m_121945_((Direction)p_123561_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = p_123561_.m_7727_();
            if (dispensiblecontaineritem.emptyContents(null, (Level)level, blockpos, null, p_123562_)) {
                dispensiblecontaineritem.m_142131_(null, (Level)level, p_123562_, blockpos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return this.defaultDispenseItemBehavior.m_6115_(p_123561_, p_123562_);
        }
    };

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put((EntityType)SpawnEntityType.ANGLER_FISH.get(), AnglerFish.m_27495_().m_22265_());
        event.put((EntityType)SpawnEntityType.TUNA.get(), Tuna.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.TUNA_EGG.get(), TunaEgg.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.SEAHORSE.get(), Seahorse.m_27495_().m_22265_());
        event.put((EntityType)SpawnEntityType.SNAIL.get(), Snail.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.HAMSTER.get(), Hamster.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.ANT.get(), Ant.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.SUNFISH.get(), Sunfish.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.OCTOPUS.get(), Octopus.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.SEA_COW.get(), SeaCow.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.CLAM.get(), Clam.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.HERRING.get(), Herring.m_27495_().m_22265_());
        event.put((EntityType)SpawnEntityType.STICKBUG.get(), Stickbug.createAttributes().m_22265_());
        event.put((EntityType)SpawnEntityType.BARRACUDA.get(), Barracuda.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)SpawnEntityType.ANGLER_FISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.TUNA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Tuna::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.SEAHORSE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.SNAIL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Snail::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.HAMSTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Hamster::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.ANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.WORLD_SURFACE_WG, Ant::canSpawn, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.SUNFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Sunfish::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.OCTOPUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Octopus::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.SEA_COW.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.CLAM.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Clam::checkSurfaceWaterAnimalSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.HERRING.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.STICKBUG.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)SpawnEntityType.BARRACUDA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    @SubscribeEvent
    public void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)Spawn.PROXY.getAnimalVariantManager());
        event.addListener((PreparableReloadListener)Spawn.PROXY.getBlockVariantManager());
        event.addListener((PreparableReloadListener)Spawn.PROXY.getAnthillRotManager());
    }

    @SubscribeEvent
    public void register(EntityStruckByLightningEvent event) {
        ItemEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof ItemEntity && (entity = (ItemEntity)entity2).m_32055_().m_204117_(SpawnTags.SURVIVES_LIGHTNING)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        ItemStack stack = event.getEntity().m_32055_();
        Player player = event.getPlayer();
        if (stack.m_150930_((Item)SpawnItems.SUSPICIOUS_STICK.get())) {
            event.setCanceled(true);
            for (int i = 0; i < stack.m_41613_(); ++i) {
                if (player.m_9236_().f_46443_) {
                    player.m_6674_(InteractionHand.MAIN_HAND);
                }
                Stickbug stickbug = Stickbug.createStickbug(player, stack);
                stickbug.setPickUpDelay(40);
                stickbug.setThrower(player.m_20148_());
                float f8 = Mth.m_14031_((float)(player.m_146909_() * ((float)Math.PI / 180)));
                float f2 = Mth.m_14089_((float)(player.m_146909_() * ((float)Math.PI / 180)));
                float f3 = Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                float f4 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                float f5 = player.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float f6 = 0.02f * player.m_217043_().m_188501_();
                stickbug.m_20334_((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f8 * 0.3f + 0.1f + (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                if (player.m_9236_().f_46443_) continue;
                player.m_9236_().m_7967_((Entity)stickbug);
            }
        }
    }

    @SubscribeEvent
    public void openInventory(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        NonNullList slots = event.getContainer().f_38839_;
        RandomSource random = player.m_217043_();
        ArrayList<Integer> stickbugSlots = new ArrayList<Integer>();
        for (Slot slot : slots) {
            if (!slot.m_6657_() || !slot.m_7993_().m_150930_((Item)SpawnItems.SUSPICIOUS_STICK.get())) continue;
            stickbugSlots.add(slot.f_40219_);
        }
        if (stickbugSlots.isEmpty()) {
            return;
        }
        Iterator iterator = stickbugSlots.iterator();
        while (iterator.hasNext()) {
            Slot toSlot;
            Slot fromSlot;
            ItemStack fromStack;
            int from = (Integer)iterator.next();
            if (!((double)random.m_188501_() < 0.3) || (fromStack = (fromSlot = (Slot)slots.get(from)).m_7993_()).m_41619_()) continue;
            ArrayList<Integer> emptySlots = new ArrayList<Integer>();
            for (int j = 0; j < slots.size(); ++j) {
                if (j == from) continue;
                toSlot = (Slot)slots.get(j);
                if (toSlot.f_40218_ != fromSlot.f_40218_ || !toSlot.m_7993_().m_41619_() || !toSlot.m_5857_(fromStack)) continue;
                emptySlots.add(j);
            }
            if (emptySlots.isEmpty()) continue;
            int to = (Integer)emptySlots.get(random.m_188503_(emptySlots.size()));
            toSlot = (Slot)slots.get(to);
            toSlot.m_5852_(fromStack.m_41777_());
            toSlot.m_6654_();
            fromSlot.m_5852_(ItemStack.f_41583_);
            fromSlot.m_6654_();
        }
        event.getContainer().m_38946_();
    }

    @SubscribeEvent
    public void registerDispenserBehaviors(TagsUpdatedEvent event) {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpawnItems.HERRING_BUCKET.get()), (DispenseItemBehavior)this.dispenseBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpawnItems.SEAHORSE_BUCKET.get()), (DispenseItemBehavior)this.dispenseBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpawnItems.TUNA_EGG_BUCKET.get()), (DispenseItemBehavior)this.dispenseBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpawnItems.ANGLER_FISH_BUCKET.get()), (DispenseItemBehavior)this.dispenseBucket);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)SpawnItems.BABY_SUNFISH_BUCKET.get()), (DispenseItemBehavior)this.dispenseBucket);
        DispenseItemBehavior waterBucket = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42447_);
        MorayCreviceDispenserBehavior wrapped = new MorayCreviceDispenserBehavior((DispenseItemBehavior)(waterBucket != null ? waterBucket : new DefaultDispenseItemBehavior()));
        DispenserBlock.m_52672_((ItemLike)Items.f_42447_, (DispenseItemBehavior)wrapped);
    }
}

