/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.item;

import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import com.ninni.spawn.server.entity.Octopus;
import com.ninni.spawn.server.entity.common.Catchable;
import com.ninni.spawn.server.entity.common.ChestBlockEntityAccessor;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CapturedOctopusItem
extends Item {
    public CapturedOctopusItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack innerstack;
        BlockHitResult blockHitResult = BucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack itemStack = player.m_21120_(interactionHand);
        Direction direction = blockHitResult.m_82434_();
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockPos blockPos3 = blockPos.m_121945_(direction);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.spawn(player, interactionHand, level, itemStack, blockPos3);
            level.m_142346_((Entity)player, GameEvent.f_157810_, blockPos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_("Item") && (innerstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Item"))).m_150930_(Items.f_220219_)) {
            player.m_36335_().m_41524_((Item)this, 60);
            player.m_6672_(interactionHand);
            level.m_6269_(player, (Entity)player, (SoundEvent)SpawnSoundEvents.GOAT_HORN_OCTOPUS.get(), SoundSource.RECORDS, 3.0f, 1.0f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_214171_(GameEvent.f_223696_, player.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void spawn(Player player, InteractionHand interactionHand, Level level, ItemStack itemStack, BlockPos blockPos) {
        BlockHitResult blockHitResult = BucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity blockEntity2 = (ChestBlockEntity)blockEntity;
            if (state.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE) {
                List list = level.m_45976_(Octopus.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)));
                if (!list.isEmpty()) {
                    player.m_5661_((Component)Component.m_237110_((String)"spawn.container.isAlreadyLocked", (Object[])new Object[]{blockEntity2.m_5446_()}), true);
                    return;
                }
                Octopus entity = (Octopus)((EntityType)SpawnEntityType.OCTOPUS.get()).m_20592_(serverLevel, itemStack, null, pos.m_7495_(), MobSpawnType.BUCKET, true, false);
                entity.setLockingPos(pos);
                if (blockEntity2 instanceof ChestBlockEntityAccessor) {
                    ChestBlockEntityAccessor accessor = (ChestBlockEntityAccessor)blockEntity2;
                    accessor.setOctopusOwner(player.m_20148_());
                    blockEntity2.m_6596_();
                }
                entity.setHasBeenCaught(true);
                entity.loadDataFromTag((Mob)entity, itemStack.m_41784_());
                this.giveItemBack(player, interactionHand, itemStack);
                return;
            }
        }
        Vec3 vec = blockPos.m_252807_().m_82520_(0.0, -0.5, 0.0);
        Catchable.releaseFromTag(itemStack.m_41783_(), serverLevel, vec, player.m_146908_() - 180.0f, 0.0f, (EntityType)SpawnEntityType.OCTOPUS.get());
        this.giveItemBack(player, interactionHand, itemStack);
    }

    public void giveItemBack(Player player, InteractionHand interactionHand, ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("Item")) {
            player.m_21008_(interactionHand, ItemStack.m_41712_((CompoundTag)itemStack.m_41783_().m_128469_("Item")));
        } else if (!player.m_7500_()) {
            itemStack.m_41774_(1);
        }
    }

    public int m_8105_(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_("Item") && ItemStack.m_41712_((CompoundTag)itemStack.m_41783_().m_128469_("Item")).m_150930_(Items.f_220219_)) {
            return 60;
        }
        return 0;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        return compoundTag != null && compoundTag.m_128441_("Item") && ItemStack.m_41712_((CompoundTag)itemStack.m_41783_().m_128469_("Item")).m_150930_(Items.f_220219_) ? UseAnim.TOOT_HORN : UseAnim.NONE;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_("CustomName")) {
            list.add((Component)Component.m_237113_((String)compoundTag.m_128461_("CustomName")).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW)));
        }
        if (compoundTag != null && compoundTag.m_128441_("Variant")) {
            ResourceLocation loc = ResourceLocation.m_135820_((String)compoundTag.m_128461_("Variant"));
            list.add((Component)Component.m_237115_((String)("variant." + loc.m_135827_() + ".octopus." + loc.m_135815_())).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY)));
        }
        list.add((Component)Component.m_237113_((String)" "));
        list.add((Component)Component.m_237115_((String)"item.spawn.captured_octopus.captured").m_130940_(ChatFormatting.GRAY));
        if (compoundTag != null && compoundTag.m_128441_("Item")) {
            list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)ItemStack.m_41712_((CompoundTag)itemStack.m_41783_().m_128469_("Item")).m_41720_().m_7626_(itemStack).getString()).m_130940_(ChatFormatting.BLUE)));
        } else {
            list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"item.spawn.captured_octopus.no_container").m_130940_(ChatFormatting.BLUE)));
        }
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

