/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.level;

import com.mojang.serialization.Codec;
import com.ninni.spawn.server.block.DragonflyReedsBlock;
import com.ninni.spawn.server.level.ReedsFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.FluidState;

public class DragonReedsFeature
extends Feature<ReedsFeatureConfig> {
    public DragonReedsFeature(Codec<ReedsFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ReedsFeatureConfig> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        RandomSource random = ctx.m_225041_();
        BlockPos origin = ctx.m_159777_();
        int tries = random.m_188503_(3) + 1;
        boolean placedAny = false;
        for (int i = 0; i < tries; ++i) {
            BlockPos tryPos = origin.m_7918_(random.m_188503_(7) - random.m_188503_(7), random.m_188503_(2), random.m_188503_(7) - random.m_188503_(7));
            BlockPos floor = new BlockPos(tryPos.m_123341_(), level.m_5736_() - 2, tryPos.m_123343_());
            BlockPos base = floor.m_7494_();
            BlockPos upperPos = base.m_7494_();
            if (upperPos.m_123342_() >= level.m_151558_() || !DragonReedsFeature.isGoodLower((LevelAccessor)level, base) || !DragonReedsFeature.isGoodUpper((LevelAccessor)level, upperPos)) continue;
            BlockState baseState = ((ReedsFeatureConfig)ctx.m_159778_()).provider().m_213972_(random, base);
            BlockState lower = (BlockState)((BlockState)baseState.m_61124_(DragonflyReedsBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)DragonflyReedsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            BlockState upper = (BlockState)((BlockState)baseState.m_61124_(DragonflyReedsBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)DragonflyReedsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            int flags = 18;
            level.m_7731_(base, lower, 18);
            level.m_7731_(upperPos, upper, 18);
            FluidState f = level.m_6425_(base);
            if (!f.m_76178_()) {
                level.m_186469_(base, f.m_76152_(), f.m_76152_().m_6718_((LevelReader)level));
            }
            placedAny = true;
        }
        return placedAny;
    }

    private static boolean isGoodLower(LevelAccessor level, BlockPos pos) {
        FluidState f = level.m_6425_(pos);
        return f.m_205070_(FluidTags.f_13131_) && f.m_76186_() == 8 && level.m_8055_(pos.m_7495_()).m_280296_();
    }

    private static boolean isGoodUpper(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos).m_247087_() && level.m_6425_(pos).m_76178_();
    }
}

