/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.server.level;

import com.mojang.serialization.Codec;
import com.ninni.spawn.registry.SpawnBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WindsweptGrassFeature
extends Feature<NoneFeatureConfiguration> {
    public WindsweptGrassFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        RandomSource rand = ctx.m_225041_();
        BlockPos origin = ctx.m_159777_();
        int radius = 5;
        float innerRatio = 0.45f;
        float edgeFeather = 0.8f;
        float wobble = 0.35f;
        float innerRadius = (float)radius * innerRatio;
        boolean placedAny = false;
        int wobbleSteps = 16;
        float[] wobbleTable = new float[wobbleSteps];
        for (int i = 0; i < wobbleSteps; ++i) {
            wobbleTable[i] = 1.0f + (rand.m_188501_() * 2.0f - 1.0f) * wobble;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                boolean wantTall;
                int z;
                int x;
                int y;
                if (dx * dx + dz * dz > (radius + 1) * (radius + 1)) continue;
                double ang = Math.atan2(dz, dx);
                int wobIdx = (int)Math.floor((ang + Math.PI) / (Math.PI * 2) * (double)wobbleSteps) % wobbleSteps;
                float wobMul = wobbleTable[(wobIdx + wobbleSteps) % wobbleSteps];
                float dist = (float)Math.sqrt(dx * dx + dz * dz);
                float norm = dist / ((float)radius * wobMul);
                if (norm > 1.0f || norm > edgeFeather && rand.m_188501_() < (norm - edgeFeather) / (1.0f - edgeFeather) || (y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x = origin.m_123341_() + dx, z = origin.m_123343_() + dz)) <= 66) continue;
                BlockPos pos = new BlockPos(x, y, z);
                BlockPos below = pos.m_7495_();
                if (!level.m_46859_(pos) || !level.m_6425_(pos).m_76178_() || !level.m_6425_(below).m_76178_()) continue;
                boolean bl = wantTall = norm <= innerRadius / ((float)radius * wobMul);
                if (wantTall) {
                    BlockState tall;
                    boolean replaceableUpper;
                    boolean replaceable = level.m_8055_(pos).m_204336_(BlockTags.f_278394_) || level.m_8055_(pos).m_60795_();
                    boolean bl2 = replaceableUpper = level.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_278394_) || level.m_8055_(pos.m_7494_()).m_60795_();
                    if (replaceable && replaceableUpper && (tall = ((Block)SpawnBlocks.TALL_WINDSWEPT_GRASS.get()).m_49966_()).m_60710_((LevelReader)level, pos)) {
                        DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)tall, (BlockPos)pos, (int)2);
                        placedAny = true;
                        continue;
                    }
                }
                if (!this.placeShortGrass(level, pos)) continue;
                placedAny = true;
            }
        }
        return placedAny;
    }

    private boolean placeShortGrass(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockState shortGrass = ((Block)SpawnBlocks.SHORT_WINDSWEPT_GRASS.get()).m_49966_();
        if ((state.m_204336_(BlockTags.f_278394_) || state.m_60795_()) && shortGrass.m_60710_((LevelReader)level, pos)) {
            level.m_7731_(pos, shortGrass, 2);
            return true;
        }
        return false;
    }
}

